// (C) Copyright 2011-2013 Hewlett-Packard Development Company, L.P.

define(['hp/model/Resource'],
function(Resource) {
  
    var indexUris;
  
    function haveTaskParent(indexResult, members) {
        var result;
        if ('tasks' === indexResult.category &&
            indexResult.attributes.parentTaskUri) {
            if (! indexUris) {
                indexUris = {};
                for (var i=(members.length-1); i>=0; i--) {
                    indexUris[members[i].uri] = true;
                }
            }
            result = indexUris[indexResult.attributes.parentTaskUri];
        }
        return result;
    }
    
    function postFilter(indexResults) {
        var length = indexResults.members.length;
        indexUris = undefined;
        for (var i=(indexResults.members.length - 1); i >= 0; i--) {
            indexResult = indexResults.members[i];
            if (haveTaskParent(indexResult, indexResults.members)) {
                indexResults.count -= 1;
                indexResults.total -= 1;
                indexResults.members.splice(i, 1);
            }
        }
    }
  
    var  r = new Resource(['alerts', 'tasks'], {postFilter: postFilter});
    // common filter property for activity and tasks
    r.initializeDefaultFilter = function(filter) { 
        // turn off background tasks
           filter.setHiddenNotProperty('taskType', 'Background');
        // turn off new and starting tasks
           filter.setHiddenNotProperty('state', ['New', 'Starting']);
        // turn off validation errors
           filter.setHiddenNotProperty('stateReason', 'ValidationError');
           
    }
    return r;         
       
   
});
