// (C) Copyright 2011-2013 Hewlett-Packard Development Company, L.P.
define(['hp/core/EventDispatcher',
        'fs/services/settings/ApplianceUpdateService',
        'hp/model/Session',
        'jquery'],
    function(EventDispatcher, service, session) {"use strict";
    var ApplianceUpgradeResource = ( function() {
        function ApplianceUpgradeResource() {

            var dispatcher = new EventDispatcher();

            /*
                updateState variable - will hold the state of the update process.
                0 - file is not uploaded yet
                1 - file uploaded successfully and EULA not accepted
                2 - EULA accepted
            */
            var updateState;
            var rebootRequired=false;
            var otherLoggedInUsersList = [];
            var fileName;
            var estimatedUpgradeTime;
            var availableDiskSpace=0; //in GBs
            var fileSelection = null;
            var hasErrorOrWarning = false;
            var upgradeErrorsOrWarnings = null;
            var uploadID = null;

            function getOtherUsersLoggedIn(loggedInUsersData) {
                var currentUser = '';
                var count = 0;
                var userSet = {};

                if (loggedInUsersData.count > 0) {
                    currentUser = session.getUser();
                    currentUser = (currentUser !=null)? currentUser.toLowerCase():currentUser;
                    for ( var i = 0; i < loggedInUsersData.members.length; i++) {
                        var loggedInUser = loggedInUsersData.members[i].username.toLowerCase();
                        // creating a set to avoid duplicate elements.
                        if (!userSet[loggedInUser]) {
                            userSet[loggedInUser] = true;
                            if (loggedInUser !== currentUser) {
                                otherLoggedInUsersList[count] = loggedInUser;
                                count++;
                            }
                        }
                    }
                }
            }

            function setApplianceDiskSpace(health){
                availableDiskSpace=parseInt(health.available, 10);
            }

            function onUsersLoggedInListSuccess(data) {
                getOtherUsersLoggedIn(data);
                dispatcher.fire('usersLoggedInSuccess', data);
            }

            function onUsersLoggedInListError(errorInfo) {
                dispatcher.fire('usersLoggedInError', errorInfo);
            }

            function setConditions(conditions){
                upgradeErrorsOrWarnings = conditions;
            }

            function onApplianceHealthSuccess(health){
                setApplianceDiskSpace(health.members[2]);
                setConditions(health.members);
                dispatcher.fire('applianceHealthSuccess', health);
            }

            function onApplianceHealthError(errorInfo) {
                dispatcher.fire('applianceHealthError', errorInfo);
            }

            this.getFileName = function(){
                return fileName;
            };

            this.setFileName = function(data){
                fileName = data;
            };

            this.getEstimatedUpgradeTime = function(){
                return estimatedUpgradeTime;
            };

            this.setEstimatedUpgradeTime = function(data){
                estimatedUpgradeTime = data;
            };

            this.on = function(eventName, callback) {
                dispatcher.on(eventName, callback);
            };

            this.off = function(eventName, callback) {
                dispatcher.off(eventName, callback);
            };

            this.getRebootRequired = function() {
                return rebootRequired;
            };

            this.setRebootRequired = function(value) {
                rebootRequired = value;
            };

            this.getUpdateState = function() {
                return updateState;
            };

            this.setUpdateState = function(state) {
                updateState = state;
            };

            this.getFileSelection = function() {
                return fileSelection;
            };

            this.setFileSelection = function(selection){
                fileSelection = selection;
            };

            this.clear = function() {
                updateState = 0;
                estimatedUpgradeTime = null;
            };

            this.applianceHealth = function(){
                upgradeErrorsOrWarnings = [];
                service.applianceHealth({
                    success: onApplianceHealthSuccess,
                    error: onApplianceHealthError
                });
            };

            this.usersLoggedIn = function() {
                otherLoggedInUsersList = [];
                service.usersLoggedIn({
                    success : onUsersLoggedInListSuccess,
                    error : onUsersLoggedInListError
                });
            };

            this.getOtherUsersLoggedInList = function() {
                return otherLoggedInUsersList;
            };

            this.getConditions = function() {
                return upgradeErrorsOrWarnings;
            };

            this.getAvailableDiskSpace = function() {
                return availableDiskSpace;
            };

            this.setUploadID = function(id) {
                uploadID = id;
            };

            this.getUploadID = function(id) {
                return uploadID;
            };

            this.setErrorOrWarning = function() {
                hasErrorOrWarning=true;
            };

            this.hasErrorOrWarning = function() {
                return(hasErrorOrWarning);
            };

        }

        return new ApplianceUpgradeResource();

    }());

    return ApplianceUpgradeResource;

});
