// (C) Copyright 2011-2013 Hewlett-Packard Development Company, L.P.
define(
        [],
        function() {
            "use strict";
            var AuthNProviders = (function() {
                function sortByName(a,b){
                    return (a.name.toUpperCase() > b.name.toUpperCase()) ? 1 : ((b.name.toUpperCase() > a.name.toUpperCase()) ? -1 : 0);
                }
                function AuthNProviders() {
                    var providerConfigs = [];
                  this.addProviderConfig = function(config) {
                        if (config) {
                            if (config.loginDomain === "") {
                                // newly created provider
                                providerConfigs.push(config);
                                return true;
                            } else {
                                if (this.getIndexByConfigId(config.loginDomain) === null) {
                                    providerConfigs.push(config);
                                    return true;
                                }
                            }
                            return false;
                        }
                    };
                    this.setProviderConfigs = function(value) {
                        providerConfigs = value;
                    };
                    this.getProviderConfigs = function(value) {
                        return providerConfigs;
                    };
                    this.sortProviderConfigsByName = function(){
                        providerConfigs.sort(sortByName);
                        return providerConfigs;
                    };
                    this.getProviderConfigById = function(loginDomain) {
                        if (providerConfigs !== null) {
                            for ( var i = 0; i < providerConfigs.length; i++) {
                                if (providerConfigs[i] !== null &&
                                    providerConfigs[i].loginDomain === loginDomain) {
                                    return providerConfigs[i];
                                }
                            }
                        }
                        return null;
                    };
                    this.getProviderConfigByIndex = function(index) {
                        if (providerConfigs !== null) {
                            return providerConfigs[index];
                        }
                        return null;
                    };
                    this.getIndexByConfigId = function(loginDomain) {
                        if (providerConfigs !== null) {
                            for ( var i = 0; i < providerConfigs.length; i++) {
                                if (providerConfigs[i].loginDomain === loginDomain) {
                                    return i;
                                }
                            }
                        }
                        return null;
                    };
                    this.clear = function() {
                        providerConfigs = [];
                      
                    };
               }
                return new AuthNProviders();
            }());

            return AuthNProviders;

        });
