// (C) Copyright 2012-2013 Hewlett-Packard Development Company, L.P.
define(['hp/core/Router'],
function (router) { "use strict";

    var FactoryResetRoutes = ( function() {

        var CONFIRM_CONTAINER = '#hp-dialog-container';
        var AUTH_CATEGORY = 'appliance';

        function FactoryResetRoutes() {

            var registered = false;

            this.register = function () {

                if (registered) {
                    return;
                }
                registered = true;

                router.map('settings factory reset', '/settings/reset/factoryReset(/.*|$)', {
                    container: CONFIRM_CONTAINER,
                    enter: function (location, result) {     
                        require(['text!hpPages/settings/reset/factoryReset.html',
                            'hp/view/settings/reset/FactoryResetView'],
                        function (page, view) {
                            result.loadIfManageable(page, view, AUTH_CATEGORY);
                        });
                    }
                });
            };
        }

        return new FactoryResetRoutes();
    }());

    return FactoryResetRoutes;
});
