// (C) Copyright 2013 Hewlett-Packard Development Company, L.P.
define([ 'fs/services/settings/NetworkSetupService','jquery' ], 
        function(NetworkService) {"use strict";

    var ProductConfig = ( function()  {
    	
        var productConfigMembers;
        
        function ProductConfig() {
    		
             /**
             * This function creates a hash map from the product-config.json with the 
             * product config variable as the key. If the map already exists, that is returned
             * otherwise a new map is created. 
             *  
             */
            this.getproductConfigMembers = function(handlers) {
                if(productConfigMembers) {
                    handlers.success(productConfigMembers);
                }
                else {
                    NetworkService.getProductConfig({
                        success : function(productConfig) {
                            productConfigMembers = { };
                            if (productConfig.members != null)	{
                                $.each(productConfig.members, function(i, data) {
                                    productConfigMembers[data.name] = data.value;	
                                });
                            }
                            handlers.success(productConfigMembers);
                        }
                    });
                }
            };
        }
        return new ProductConfig();
    }());
    
    return ProductConfig;

});