// (C) Copyright 2012-2013 Hewlett-Packard Development Company, L.P.
define(['hp/core/Router',
        'hp/core/UrlFragment'],
function (router, urlFragment) { "use strict";

    var SecurityRoutes = ( function() {

        var SHOW_CONTAINER = '#hp-settings-show .hp-details-show-view',
            CHANGE_CONTAINER = '#hp-change-page-container';

        var AUTH_CATEGORY = 'appliance';

        function SecurityRoutes() {

          var registered = false;

            this.register = function () {

                if (registered) {
                    return;
                }
                registered = true;

                router.map('settings show security *',
                    '/settings/show/security/(authentication|directories|certificate|publickey|firmwarebundle)' + urlFragment.viewPatternTerminal, {
                    container: SHOW_CONTAINER,
                    enter: function(location, result) {
                        require(['text!fsPages/settings/security/more.html',
                                 'fs/view/settings/security/SecurityMoreView'],
                        function(page, view) {
                            result.loadIfViewable(page, view, AUTH_CATEGORY);
                        });
                    }
                });

                router.filter('settings show security default redirector',
                        '/settings/show/security' + urlFragment.viewPatternTerminal, {
                        check: function(location, result) {
                            result.replaceWith(urlFragment.replaceView(location, 'show/security/authentication'));
                        }
                    });

                router.map('settings edit security', '/settings/edit/security(/.*|$)', {
                    container: CHANGE_CONTAINER,
                    enter: function (location, result) {
                        require(['text!fsPages/settings/security/edit.html',
                            'fs/view/settings/security/SecurityEditView'],
                        function (page, view) {
                            result.loadIfManageable(page, view, AUTH_CATEGORY);
                        });
                    }
                });

            };
        }

        return new SecurityRoutes();
    }());

    return SecurityRoutes;
});
