// (C) Copyright 2012-2013 Hewlett-Packard Development Company, L.P.
define(['hp/core/Router','hp/core/UrlFragment'],
function (router, urlFragment) { "use strict";

    var SupportRoutes = ( function() {

        var SHOW_CONTAINER = '#hp-settings-show .hp-details-show-view';
        var AUTH_CATEGORY = 'appliance';
        var CHANGE_CONTAINER = '#hp-change-page-container';

        function SupportRoutes() {
            var registered = false;
            this.register = function () {
                if (registered) {
                    return;
                }
                registered = true;

                router.map('settings show support *',
                    '/settings/show/supportaccess' + urlFragment.viewPatternTerminal, {
                    container: SHOW_CONTAINER,
                    enter: function(location, result) {
                        require(['text!fsPages/settings/support/more.html',
                            'fs/view/settings/support/SupportMoreView'],
                        function(page, view) {
                            result.loadIfViewable(page, view, AUTH_CATEGORY);
                        });
                    }
                });

                router.map('settings edit support *',
                    '/settings/edit/supportaccess' + urlFragment.viewPatternTerminal, {
                    container: CHANGE_CONTAINER,
                    enter: function(location, result) {
                        require(['text!fsPages/settings/support/edit.html',
                            'fs/view/settings/support/SupportEditView'],
                        function(page, view) {
                            result.loadIfManageable(page, view, AUTH_CATEGORY);
                        });
                    }
                });
            };
        }

        return new SupportRoutes();

    }());

    return SupportRoutes;

});