// (C) Copyright 2011-2013 Hewlett-Packard Development Company, L.P.
define(['fs/services/status/StatusService',
        'hp/core/EventDispatcher',
        'jquery'],
function(statusService, EventDispatcher) {"use strict";
    var StatusResource = ( function() {
        function StatusResource() {

            var dispatcher = new EventDispatcher();

            this.on = function(eventName, callback) {
                dispatcher.on(eventName, callback);
            };

            this.off = function(eventName, callback) {
                dispatcher.off(eventName, callback);
            };

            this.createSupportDump = function(encrypted){

                statusService.createSupportDump(encrypted, {
                    success: function(data) {
                        dispatcher.fire("createSupportDumpSuccess",data.uri);
                    },
                    error: function(errorInfo) {
                        dispatcher.fire("createSupportDumpError",errorInfo);
                    }
                });
            };

        }

        return new StatusResource();

    }());

    return StatusResource;

});
