// (C) Copyright 2013 Hewlett-Packard Development Company, L.P.
define([ 'hp/services/REST','jquery'],
function(REST) {"use strict";

    var BackupService = (function() {
        
        var API_VERSION = 100,
            OPTS = {apiVersion: API_VERSION};
        
        /**
         * @constructor Singleton class containing service logic for backup
         * @type {BackupService}
         */
        function BackupService() {
            
            /**
             * Gets a simple paginated collection which contains a backup resource
             * for the last backup (if any).
             *
             * @param {{success:function(SimplePaginatedCollection):void, 
             *          error:function(ErrorMessage):void} handlers 
             *        Handler functions for success and error conditions.
             */
            this.getLastBackup = function(handlers) {
                REST.getURI('/rest/backups', handlers, OPTS);
            };
            
            /**
             * Gets a backup resource for the requested backup.
             *
             * @param backupUri The uri of the requested backup.
             * @param {{success:function(BackupResource):void, 
             *          error:function(ErrorMessage):void} handlers 
             *        Handler functions for success and error conditions.
             */
            this.getBackup = function(backupUri, handlers) {
                REST.getURI(backupUri, handlers);
            };
            
            /**
             * Starts a backup and returns a task resource via the success handler
             *
             * @param {{success:function(TaskResource):void, 
             *          error:function(ErrorMessage):void} handlers 
             *        Handler functions for success and error conditions.
             */
            this.startBackup = function(handlers) {
                REST.postObject('/rest/backups', {}, handlers);
            };
            
            /**
             * Cancels a backup and returns a task resource via the success handler
             *
             * @param backupUri Uri of backup to cancel
             * @param {{success:function(TaskResource):void, 
             *          error:function(ErrorMessage):void} handlers 
             *        Handler functions for success and error conditions.
             */
            this.cancelBackup = function(backupUri, handlers) {
                REST.deleteURI(backupUri, 
                    handlers);
            };
            
        }

        return new BackupService();
    }());

    return BackupService;
});

