// (C) Copyright 2011-2013 Hewlett-Packard Development Company, L.P.
define([ 'hp/services/REST','jquery'],
function(REST) {"use strict";

    var RestoreService = (function() {

        // timeout value chosen based on restore testing
        var RESTORE_FAILURE_TIMEOUT = 45000; // milliseconds
        
        // Api version for the rest call to get restore result
        var API_VERSION = 100;
        
        /**
         * @constructor Singleton class containing service logic for restore
         * @type {RestoreService}
         */
        function RestoreService() {

            /**
             * Gets a RestoreResult object that contains the result of a restore. This is used
             * to determine if a restore failure message should be shown before the login page.
             *
             * @param {{success:function(RestoreResult):void, error:function(ErrorMessage):void}
             *     handlers Handler functions for success and error conditions.
             */
            this.getRestoreFailureStatus = function(handlers) {
                REST.getURI('/rest/restores/failure', handlers, {timeout: RESTORE_FAILURE_TIMEOUT, apiVersion: API_VERSION});
            };
            
            /**
             * Gets a simple paginated collection which contains a restore resource
             * with the status of the last restore (if any).
             *
             * @param {{success:function(SimplePaginatedCollection):void, error:function(ErrorMessage):void}
             *     handlers Handler functions for success and error conditions.
             */
            this.getLastRestoreStatus = function(handlers) {
                REST.getURI('/rest/restores', handlers, {timeout: RESTORE_FAILURE_TIMEOUT});
            };
            
            /**
             * Starts a restore and returns a restore resource in the response
             *
             * @param {{success:function(RestoreResource):void, error:function(ErrorMessage):void}
             *     handlers Handler functions for success and error conditions.
             * @param backupUri Uri of backup to restore
             */
            this.startRestore = function(handlers, backupUri) {
                REST.postObject('/rest/restores', 
                    {type:"RESTORE",uriOfBackupToRestore:backupUri}, 
                    handlers, 
                    {timeout: RESTORE_FAILURE_TIMEOUT});
            };
        }

        return new RestoreService();
    }());

    return RestoreService;
});

