// (C) Copyright 2013-2014 Hewlett-Packard Development Company, L.P.
define([ 'hp/services/REST', 'jquery' ],

function(REST) { "use strict";
    var newOptions = {headers : {requestername : "DEFAULT"}, apiVersion : "100"};
    return {
            getCertificate : function(host, handlers) {
                REST.getURI('/rest/certificates/https/remote/'+host, handlers, newOptions);
            },
            importCertificate : function(certObject, handlers) {
                REST.postObject('/rest/certificates', certObject, handlers, newOptions);
            },
            checkCertificateExists : function(host, handlers) {
                REST.getURI('/rest/certificates?filter='+host, handlers, newOptions);
            },
            updateCertificate : function(aliasName, certObject, handlers) {
                REST.putObject('/rest/certificates/'+aliasName,certObject, null, handlers, newOptions);
            }
        };
});

