// (C) Copyright 2012-2013 Hewlett-Packard Development Company, L.P.
define([ 'hp/services/REST','hp/model/DevelopmentSettings','jquery'],
function(REST) {"use strict";

    var WelcomeService = (function() {
 
        /**
         * @constructor Singleton class containing service logic for the welcome page  
         * @type {WelcomeService}
         */
        function WelcomeService() {
  
            /**
             * Get the current network configuration of the server.
             *
             * @param {{success:function(NodeStatsuDTO):void, error:function(ErrorMessage):void}} handlers
             *     Handler functions for success and error conditions.
             */

            this.getNodeStatus = function(handlers) {
                REST.getURI('/rest/appliance/status' , {
                    success:  handlers.success,
                    error: handlers.error
                });
            };
 
        }

        return new WelcomeService();
    }());

    return WelcomeService;
});

