// (C) Copyright 2011-2012 Hewlett-Packard Development Company, L.P.
/**
 * @type {SessionRoutes}
 */
define(['hp/core/Router'],
function (router) { "use strict";

    var InitialNetworkRoutes = ( function() {

        var CHANGE_CONTAINER = '#hp-change-page-container';
        var AUTH_CATEGORY = 'appliance';

        function InitialNetworkRoutes() {

            var registered = false;
            var networkConfiguredSettingRetrieved = false;
            var initialNetworkSettingsDone = false;

            function initialNetworkFilter(session, settings, result) {
                if (! session.canManageCategory(AUTH_CATEGORY)) {
                    // user can't manage appliance setup, let him keep going
                    result.proceed();
                } else {
                    if (networkConfiguredSettingRetrieved) {
                        if (initialNetworkSettingsDone) {
                            result.proceed();
                        } else {
                            result.redirectTo('/settings/initial-network');
                        }
                    } else {
                        settings.getSetting('setup-network-configured', {
                            success : function(networkConfiguredSetting) {
                                initialNetworkSettingsDone =
                                    (networkConfiguredSetting.value &&
                                    networkConfiguredSetting.value != 'false');
                                networkConfiguredSettingRetrieved = true;
                                if (initialNetworkSettingsDone) {
                                    result.proceed();
                                } else {
                                    result.redirectTo('/settings/initial-network');
                                }
                            },
                            error : function(errorInfo) {
                                // Assume the network has not been configured.
                                initialNetworkSettingsDone = false;
                                networkConfiguredSettingRetrieved = true;
                                result.redirectTo('/settings/initial-network');
                            }
                        });
                    }
                }
            }

            this.register = function () {

                if (registered) {
                    return;
                } 
                registered = true;

                router.map('initial network', '^/settings/initial-network(/.*|$)', {
                    menu: {
                        label: 'Setup',
                        location: '/settings/initial-network',
                        simpleBanner: false
                    },
                    container: CHANGE_CONTAINER,
                    enter: function (location, result) {
                        require(['text!fsPages/settings/initialNetwork.html',
                            'fs/view/settings/InitialNetworkView'],
                        function (page, view) {
                            // if the initial network setting were already done , redirect to edit page
                            if (!initialNetworkSettingsDone) { 
                               result.loadIfViewable(page, view, AUTH_CATEGORY);
                            } else {
                                result.redirectTo("/settings/edit/network");
                            }
                            // so we will re-load next time through the filter
                            networkConfiguredSettingRetrieved = false;
                            initialNetworkSettingsDone = false;
                        });
                    }
                });

                router.filter('initial network filter', '^.*', {
                    check: function (location, result) {
                        require(['hp/model/Session',
                            'fs/services/settings/SettingsService'],
                        function (session, settings) {
                            initialNetworkFilter(session, settings, result);
                        });
                    }
                });
            };
 
        }

        return new InitialNetworkRoutes();
    }());

    return InitialNetworkRoutes;
});
