// (C) Copyright 2011-2014 Hewlett-Packard Development Company, L.P.

define(['fs/view/activity/ActivityAlertView',
    'fs/view/activity/ActivityTaskView',
    'hp/core/NotificationFormatter',
    'hp/core/StatusState',
    'hp/core/LinkTargetBuilder',
    'hp/core/UrlFragment',
    'jquery',
    'hp/lib/jquery.hpTextFormat'],
function(activityAlertView, activityTaskView, notificationFormatter, statusState, linkTargetBuilder, urlFragment) { "use strict";

    var ActivityRenderer = (function() {
      
        /**
         * Constructor
         */
        function ActivityRenderer() {
          
            function initNotification(indexResult) {
                if (! indexResult.hasOwnProperty('_notification')) {
                    indexResult._notification = {
                        category: indexResult.category,
                        sourceCategory:
                            indexResult.attributes.associatedResourceCategory,
                        indexResource: true
                    };
                    notificationFormatter.format(indexResult._notification,
                        indexResult);
                }
                return indexResult._notification;
            }
          
            this.renderStatus = function (oObj) {
                var notification = initNotification(oObj.aData);
                return '<div class="hp-status">' +
                    (notification.changing ? '*' : notification.status) +
                    '</div>';
            };
            
            this.renderName = function(oObj) {
                var notification = initNotification(oObj.aData);
                var result = $('<span></span>').hpTextFormat(notification.summary);
                return result.html();
            };
            
            this.renderSource = function (oObj) {
                var notification = initNotification(oObj.aData);
                var category = '';
                var result;
                if (notification.sourceCategory) {
                    // leading space is important
                    category = ' <span class="hp-category">' +
                        linkTargetBuilder.
                            categoryLabel(notification.sourceCategory) +
                        '</span>';
                }
                if (notification.sourceUri) {
                    result = linkTargetBuilder.makeLink(
                        (urlFragment.decodeHtmlEntities(notification.sourceName) || '?'),
                        notification.sourceUri) + category;
                } else if (notification.sourceName) {
                    result = urlFragment.decodeHtmlEntities(notification.sourceName) + category;
                } else {
                    result = '<div class="hp-unset">not set</div>';
                }
                return result;
            };
            
            this.renderState = function (oObj) {
                var result;
                
                initNotification(oObj.aData);
                if ('tasks' === oObj.aData.category) {
                    result = activityTaskView.renderState(oObj.aData);
                } else if ('alerts' === oObj.aData.category) {
                    result = activityAlertView.renderState(oObj.aData);
                } else {
                    result = '<div class="hp-unset">not set</div>';
                }
                return result;
            };
            
            this.renderOwner = function (oObj) {
                var result;
                var notification = initNotification(oObj.aData);
                if ('alerts' === oObj.aData.category) {
                    result = activityAlertView.renderOwner(oObj.aData);
                } else {
                    if (notification.owner) {
                        result = '<div class="hp-owner">' + notification.owner + '</div>';
                    } else {
                        result = '<div class="hp-owner hp-unset">none</div>';
                    }
                }
                return result;
            };
            
            this.annotateRow = function (row, data) {
                if ('alerts' === data.category) {
                    activityAlertView.annotateRow(row, data);
                } else if ('tasks' === data.category) {
                    activityTaskView.annotateRow(row, data);
                }
            };
            
            this.renderDetails = function (indexResult, oldDetails, handler) {
                var result;
                // pass the table scroll handler so that it can be called when details are rendered
                if ('tasks' === indexResult.category) {                    
                    result = activityTaskView.renderDetails(indexResult, oldDetails, handler);
                } else if ('alerts' === indexResult.category) {
                    result = activityAlertView.renderDetails(indexResult, oldDetails, handler);
                } else {
                    result = $('<div>?</div>');
                }
                return result;
            };
            
            this.detailsCollapsed = function (indexResult) {
                if ('tasks' === indexResult.category) {
                    activityTaskView.collapsed(indexResult);
                } else if ('alerts' === indexResult.category) {
                    activityAlertView.collapsed(indexResult);
                }
            };
        }

        return new ActivityRenderer();
    }());
    
    return ActivityRenderer;
});
