// (C) Copyright 2012-2014 Hewlett-Packard Development Company, L.P.
define(['hp/core/Localizer', 'hp/core/Router',
    'hp/view/DialogView', 'hp/core/Notifications', 'text!hpPages/login/eula-confirmation.html',
    'hp/core/Banner', 'fs/presenter/settings/ApplianceUpdatePresenter',
    'jquery', 'hp/lib/jquery.hpToggle', 'lib/jquery.validate'],

function(localizer, router, DialogView,  notifications, eulaconfirmation,
    banner, updatePresenter) { "use strict";

    var ApplianceUpdateEulaView = (function() {

        var AGREE_BUTTON = "#hp-eula-agree-button",
            OK_BUTTON = "#hp-eula-ok-button",
            DISAGREE_BUTTON = "#hp-eula-disagree-button",
            EULA_HEADER_TITLE_TWO = "#hp-header-eula-type",
            EULA_WRITTEN_OFFER = "#hp-eula-partnercontent-body",
            EULA_CONTENT_BODY = "#hp-eula-contents-body",
            EULA_AGREE_DISAGREE_BODY = '#hp-eula-agree-disagree-message-body';
        var APPLIANCE_NAME = '#hp-header-eula-name';
        var CONFIRMATION_APPLIANCE_NAME = '#hp-eula-confirmation-appliance-name';
        var EULA_IFRAME_MAIN = "#iframe-eula-content";
        var EULA_IFRAME_UPGRADE = "#iframe-eula-upgrade";

        function ApplianceUpdateEulaView() {

            function clear() {
                $(EULA_CONTENT_BODY).empty();
                $(EULA_WRITTEN_OFFER).empty();
            }

            function onApplySuccess(){
                router.go('/settings/update/progress',"appliance update success");
            }

            function onApplyError(errorInfo){
                error(errorInfo);
                router.go('/settings/show/overview', "appliance update error");
            }
            
            function displayError(message) {
                notifications.add({
                    summary: 'Update',
                    details: message,
                    uri: 'appliance_update'+ (new Date()).getTime(),
                    status: 'error'
                }, true /*flash*/);
            }

            function error(errorInfo){
                if(errorInfo) {
                    var failureNotificationDetails = formatError(errorInfo);
                    displayError(failureNotificationDetails);
                }
            }
            
            function formatError(errorInfo) {
                var failureNotificationDetails = errorInfo.message + "  " +
                    (errorInfo.recommendedActions ? errorInfo.recommendedActions.join(' ') : "");
                return failureNotificationDetails;
            }

            function bindDisagreeButton(){
            	$(DISAGREE_BUTTON).text(localizer.getString('fs.settings.eula.config.disagree_button'));
                $(DISAGREE_BUTTON).off('click');
                $(DISAGREE_BUTTON).click(function() {
                    onDisagreeButtonClick();
                });
            }

            function onOkButtonClick() {
                updatePresenter.setUpdateState(1);
                updatePresenter.apply(updatePresenter.getFileName());
            }

            function loadEulaHtml() {
                $(EULA_IFRAME_UPGRADE).show();
                $(EULA_IFRAME_UPGRADE).attr('src', '/ui-js/pages/upgrade/eula_content.html');
            }

            function onLoadSupportSuccess(data, status, xhr) {
                var writtenOfferHtml = $(data).filter('#hp-eula-partner-content');
                var writtenOfferText = $.trim(writtenOfferHtml.text());
                if (writtenOfferText.length == 0) {
                    onOkButtonClick();
                } else {
                    $(EULA_IFRAME_UPGRADE).hide();
                    $(EULA_HEADER_TITLE_TWO).text(localizer.getString
                        ('fs.settings.eula.config.end_user_support_title'));
                    $(EULA_WRITTEN_OFFER).html(writtenOfferHtml);
                    $(AGREE_BUTTON).hide();
                    $(EULA_AGREE_DISAGREE_BODY).hide();

                    $(DISAGREE_BUTTON).off('click');
                    $(DISAGREE_BUTTON).on('click', function(){
                        updatePresenter.removeFile();
                        router.go("/settings/show/overview", "appliance support access success");
                    });

                    $(DISAGREE_BUTTON).text(localizer.getString('core.details.cancel'));
                    $(OK_BUTTON).show();
                    $(OK_BUTTON).attr('value', localizer.getString('fs.settings.appliance.update.startUpdate'));
                }
            }

            function onLoadSupportError(jqXHR, textStats, errorThrown) {
                onOkButtonClick();
            }

            function onAgreeButtonClick(){
                $.ajax({
                    url: '/ui-js/pages/upgrade/support_access_and_written_offer.html',
                    type: 'GET',
                    async: true,
                    dataType: "html",
                    success: onLoadSupportSuccess,
                    error: onLoadSupportError
                });
            }

            function onDisagreeButtonClick(){
                var dialogView = null;
                dialogView = new DialogView({
                contents:eulaconfirmation,
                    ok : function(){
                        updatePresenter.removeFile();
                        updatePresenter.setFileSelection('');
                        router.go('/settings/show/overview','appliance update eula disagree');
                    }
                });
                $(CONFIRMATION_APPLIANCE_NAME).html(banner.getApplicationTitle());
            }

            function registerEvents() {
                updatePresenter.on("applySuccess", onApplySuccess);
                updatePresenter.on("applyError", onApplyError);
            }

            function removeEvents() {
                updatePresenter.off("applySuccess", onApplySuccess);
                updatePresenter.off("applyError", onApplyError);
            }

            this.pause = function(){
                removeEvents();
            };

            this.resume = function(){
                registerEvents();
                $(EULA_IFRAME_MAIN).hide();
                clear();
                bindDisagreeButton();
                loadEulaHtml();
                $(EULA_AGREE_DISAGREE_BODY).show();
                $(EULA_HEADER_TITLE_TWO).text(localizer.getString
                        ('fs.settings.eula.config.end_user_title'));
                $(OK_BUTTON).hide();
                $(DISAGREE_BUTTON).show();
                $(AGREE_BUTTON).show();
            };

            this.init = function() {
                registerEvents();
                $(EULA_IFRAME_MAIN).hide();
                clear();
                bindDisagreeButton();
                loadEulaHtml();
                $(APPLIANCE_NAME).text(banner.getApplicationTitle());
                $(AGREE_BUTTON).click(onAgreeButtonClick);
                $(OK_BUTTON).click(onOkButtonClick);
            };
        }

        return new ApplianceUpdateEulaView();

    }());

    return ApplianceUpdateEulaView;

});