//(C) Copyright 2011-2012 Hewlett-Packard Development Company, L.P.
define(
        [ 'fs/view/settings/authentication/AuthenticationSettingsBaseView', 'fs/presenter/settings/AuthNPresenter',
                'hp/model/Session' ],
        function (baseView, presenter, session) {
            "use strict";

            var AuthenticationShowView = (function() {

                /**
                 * @class View script for the Authentication Settings panel on
                 *        the Overview pane of the Settings page.
                 */
                function AuthenticationShowView() {

                    var EDIT_ACTION = '#cic-settings-authn-edit',
                    ALLOW_LOCAL_LOGIN_VALUE_CONATINER = '#cic-settings-authn-allow-local',
                    DEFAULT_PROVIDER_VALUE_CONTAINER = '#cic-settings-authn-default-provider',
                    PROVIDER_CONFIGS_VALUE_CONTAINER = '#cic-settings-authn-provider-configs-value-container',
                    PROVIDER_CONFIGS_NOT_SET_CONTAINER = '#cic-settings-authn-providers-not-set',
                    PROVIDER_CONFIGS_CONTAINER = '#cic-settings-authn-providers';

                    function onGetGlobalSettingsSuccess() {
                        var displayAllowLocalValue = presenter.getAllowLocalLoginDisplayValue();
                        $(ALLOW_LOCAL_LOGIN_VALUE_CONATINER).text(displayAllowLocalValue);

                        var displayValue = presenter.getDefaultProviderDisplayValue();
                        $(DEFAULT_PROVIDER_VALUE_CONTAINER).text(displayValue);

                        var data = presenter.getProviderInfosDisplayValues();
                        $(PROVIDER_CONFIGS_VALUE_CONTAINER).html("");
                        if (data.providerConfigured) {
                            for (var i = 0; i < data.displayValues.length; i++) {
                                var div = $('<div></div>').html(data.displayValues[i]).addClass('hp-form-content');
                                var listItem = $('<li></li>').append(div);
                                $(PROVIDER_CONFIGS_VALUE_CONTAINER).append(listItem);
                            }
                            $(PROVIDER_CONFIGS_CONTAINER).show();
                            $(PROVIDER_CONFIGS_NOT_SET_CONTAINER).hide();
                        } else {
                            $(PROVIDER_CONFIGS_CONTAINER).hide();
                            $(PROVIDER_CONFIGS_NOT_SET_CONTAINER).show();
                        }
                    }

                    function formatNotificationDetails(errorInfo) {
                        var failureNotificationDetails = "</br>" + errorInfo.errorMessage + "  " +
                                (errorInfo.resolution === null ? "" : errorInfo.resolution);
                        return failureNotificationDetails;
                    }

                    function onError(error) {
                        var failureNotificationDetails = formatNotificationDetails(error.errorInfo);
                        baseView.displayNotifications(error.failureMessage, failureNotificationDetails, 'error');
                    }

                    /**
                     * @public Initialize the view. Makes required REST calls
                     *         and sets up event handlers.
                     */
                    this.init = function() {
                        if (!session.canManageCategory('appliance')) {
                            $(EDIT_ACTION).hide();
                        }
                        $(PROVIDER_CONFIGS_NOT_SET_CONTAINER).hide();
                        $(PROVIDER_CONFIGS_CONTAINER).hide();
                        presenter.on("getGlobalSettingsComplete", onGetGlobalSettingsSuccess);
                        presenter.on("getGlobalSettingsError", onError);
                        presenter.loadSettingsOverview();
                    };

                    this.pause = function() {
                    };

                    this.resume = function() {
                        presenter.loadSettingsOverview();
                    };
                }

                return new AuthenticationShowView();

            }());

            return AuthenticationShowView;

        });
