// (C) Copyright 2013 Hewlett-Packard Development Company, L.P.

define([
    'hp/core/NotificationFormatter',
    'hp/core/LinkTargetBuilder',
    'hp/core/StatusState',
    'hp/core/Localizer',
    'hp/services/Log'], 
function(notificationFormatter, linkTargetBuilder, statusState, localizer, log) {"use strict";

    var BackupTaskIndexNotificationFormatter = ( function() {
      
        /**
         * @constructor
         * @type {BackupTaskIndexNotificationFormatter}
         */
        function BackupTaskIndexNotificationFormatter() {
        
            var taskFormatter = null;
          
            function replaceText(context, text) {
                return taskFormatter.replaceText(context, text);
            }
          
            function formatTask(notification, task) {
                taskFormatter.formatTask(notification, task);
                notification.sourceName = 
                    localizer.getString('fs.settings.backup.backupSourceName');
            }
            
            function formatIndex(notification, indexResource) {
                taskFormatter.formatIndex(notification, indexResource);
                notification.sourceName =
                    localizer.getString('fs.settings.backup.backupSourceName');
            }
            
            function format(notification, item) {
                if ('IndexResource' === item.type) {
                    formatIndex(notification, item);
                } else {
                    formatTask(notification, item);
                }
            }
            
            /**
             * @public
             * Register with the NotificationFormatter for any tasks.
             */
            this.register = function (taskNotificationFormatter) {
                taskFormatter = taskNotificationFormatter;
                notificationFormatter.register({
                    category: 'tasks',
                    associatedResourceCategory: 'backups',
                    index: true,
                    format: format});
            };
            
            /**
             * @public
             * Populate the notification from the task
             * @param notification Object the notification to populate
             * @param task Object the task to populate from
             */
            this.formatTask = formatTask;
            
            /**
             * @public
             * Populate the notification from the index resource
             * @param notification Object the notification to populate
             * @param index Object the index resource to populate from
             */
            this.formatIndex = formatIndex;
            
            /**
             * @public
             * Populate the notification from the task
             * @param notification Object the notification to populate
             * @param task Object the task to populate from
             */
            this.replaceText = replaceText;
        }

        return new BackupTaskIndexNotificationFormatter();
    }());

    return BackupTaskIndexNotificationFormatter;
});
