// (C) Copyright 2013 Hewlett-Packard Development Company, L.P.
define(['fs/presenter/settings/LicensePresenter',
        'hp/view/FormStateView',
        'hp/core/Router',
        'hp/core/UrlFragment',
        'hp/core/Localizer',
        'hp/model/Session',
        'hp/core/Notifications',
        'jquery',
        'lib/jquery.validate'],
    function(presenter,
             FormStateView,
             router,
             urlFragment,
             localizer,
             session,
             notifications) {  "use strict";

    var AddLicenseView = (function() {

        var FORM = '#fs-addLicense-form',
            LICENSEKEY = '#fs-license-licenseKeyValue',
            ADD = '#fs-license-add',
            ADDAGAIN = "#fs-license-add-again",
            CANCEL = '#fs-addLicense-cancel',
            HP_PRIMARY = 'hp-primary';

        var addAgain = false;
        var validator;
        var taskName;
        var formStateView = new FormStateView();

        function AddLicenseView() {

             /**
              * @private
              */
             function resetValidator() {
                 validator.resetForm();
             }

             function onCancel() {
                 formStateView.reset();
                 router.returnToPrevious(router.location());
             }

             function closeDialog() {
                 formStateView.reset();
                 router.go('/settings/show/license/general', 'add license OK');
             }


             /**
              * @private
              */
             function onAddLicenseSuccess(license) {
                 var alertMsg = localizer.getString('fs.settings.license.config.successMsg');
                 var licenseAddSuccess = {
                     summary : alertMsg,
                     uri : taskName,
                     changing : false,
                     status : "ok"
                 };
                 reset();
                 notifications.add(licenseAddSuccess, true);
                 formStateView.setMessage({summary:alertMsg, status:'ok', changing : false});
                 if (!addAgain) {
                     closeDialog();
                 }
             }

             /**
              * @private
              */
             function onAddLicenseError(errorMessage) {
                 var addMsg = localizer.getString('fs.settings.license.config.error.msg');
                 formStateView.setMessage({summary:addMsg,
                     status:'error', errorMessage: errorMessage,
                     changing : false});
             }

             /**
              * @private
              */
             function onAddLicenseClick() {
                if ($(FORM).valid()){
                     var license = $(LICENSEKEY).val();
                     taskName = session.getUser() + '-addLicenseTask-' + (new Date()).getTime();
                     formStateView.setMessage({summary:localizer.getString('fs.settings.license.config.verifying_license'),
                         status:'info', changing : true});
                     presenter.addLicense(license, {
                               success: onAddLicenseSuccess,
                               error: onAddLicenseError
                        });
                }
                return false;
             }

             function initForm() {
                 validator = $(FORM).validate({
                     rules : {
                         licenseKeyValue : {
                             required : true
                         }
                     }
                 });

             }

             /**
              * @private
              */
             function reset() {
                 $(LICENSEKEY).val("");
                 $(ADDAGAIN).removeClass(HP_PRIMARY);
                 $(ADD).addClass(HP_PRIMARY);
                 resetValidator();
                 formStateView.reset();
             }

            this.init = function() {
                 initForm();

                 formStateView.init({form: FORM,
                     autoTrack: false});

                 $(ADDAGAIN).on('click', function() {
                     addAgain = true;
                     onAddLicenseClick();
                     $(ADD).removeClass(HP_PRIMARY);
                     $(ADDAGAIN).addClass(HP_PRIMARY);
                 });
                 $(ADD).on('click', function() {
                     addAgain = false;
                     onAddLicenseClick();
                     $(ADDAGAIN).removeClass(HP_PRIMARY);
                     $(ADD).addClass(HP_PRIMARY);

                 });
                 $(CANCEL).on('click',onCancel);
             };

            /**
             * @public
             */
            this.resume = function() {
                reset();
            };

            this.pause = function () {
                formStateView.reset();
            };
    }

    return new AddLicenseView();

  }());

  return AddLicenseView;

});