// (C) Copyright 2012-2013 Hewlett-Packard Development Company, L.P.
define(['hp/core/Localizer',
    'hp/core/Router','hp/model/Session' ],

    function(localizer, router, session) { "use strict";

        var LicenseWrittenofferView  = (function() {

        var EULA_CONTENT_BODY = "#hp-form-contents-body";
        var CLOSE_BUTTON = "#hp-eulawrittenoffer-close-button";

        function LicenseWrittenofferView  () {

            function onLoadSupportSuccess(data, status, xhr) {
                var writtenOfferHtml = $(data).filter('#hp-eula-partner-content');
                localizer.localizeDom(writtenOfferHtml);
                $(EULA_CONTENT_BODY).empty().append(writtenOfferHtml);
            }
            
            function onLoadSupportError(jqXHR, textStats, errorThrown) {
            }

            function loadEulaWrittenOfferHtml() {

               var url = localizer.getString('fs.settings.eula.config.content_directory') + "/" +
                   localizer.getString('fs.settings.eula.config.support_access_file');
               $.ajax({
                   url: url,
                   type: 'GET',
                   async: true,
                   dataType: "html",
                   success: onLoadSupportSuccess,
                   error: onLoadSupportError
               });
            }

            function onCloseButtonClick() {
                var currentURI = session.getProperty("currentURI");
                session.setProperty("currentURI", null);
                router.go(currentURI, 'on Written Offer Agreement close');
            }

            this.resume = function() {
                loadEulaWrittenOfferHtml();
            };
            
            this.init = function() {
                $(CLOSE_BUTTON).click(function(ev) {
                    onCloseButtonClick();
                    ev.preventDefault();
                });
                this.resume();
            };
        }

        return new LicenseWrittenofferView ();

    }());

    return LicenseWrittenofferView ;

});