//(C) Copyright 2011-2014 Hewlett-Packard Development Company, L.P.

define(['fs/presenter/settings/NetworkSetupPresenter',
        'hp/core/Notifications',
        'hp/view/FormStateView',
        'fs/view/settings/network/NetworkInterfaceTableView',
        'hp/core/Localizer',
        'hp/core/Environment',
        'fs/model/settings/ProductConfig',
        'jquery',
        'lib/jquery.validate',
        'hp/lib/jquery.hpProgressBar',
        'hp/lib/jquery.hpToggle',
        'hp/lib/jquery.hpStackedPanels',
        'lib/jquery.selectBox',
        'hp/lib/jquery.hpTimestamp',
        'hp/lib/jquery.hpSearchCombo','hp/lib/jquery.hpCollapsible'],
function(presenter, notifications, FormStateView, NetworkInterfaceTableView, localizer,environment, ProductConfig ) {"use strict";

    return ( function() {
        var HOSTNAME = '#cic-network-hostname',
            IPV4ADDRSELECT = '#cic-network-ipv4',
            IPV6ADDRSELECT = '#cic-network-ipv6',
            TWO_NODE_IPV6_LABEL = '#cic-network-two-node-ipv6-label',
            DHCP_IPV4_WARNING = '#cic-network-DHCP-ipv4-warning',
            DHCP_IPV6_WARNING = '#cic-network-DHCP-ipv6-warning',
            DHCP_IPV4_DISALLOWED = '#cic-network-DHCP-ipv4-disallowed',
            DHCP_IPV6_DISALLOWED = '#cic-network-DHCP-ipv6-disallowed',
            GATEWAY_IPV4_WARNING = '#cic-network-GATEWAY-ipv4-warning',
            GATEWAY_IPV6_WARNING = '#cic-network-GATEWAY-ipv6-warning',
            IPV4IPADDR = '#cic-network-ip-ipv4',
            IPV4_2_IPADDR = '#cic-network-ip-ipv4-2a',
            IPV4FLOATADDR = '#cic-network-cluster-ipv4',
            IPV6FLOATADDR = '#cic-network-cluster-ipv6',
            IPV6IPADDR = '#cic-network-ip-ipv6',
            IPV6_2_IPADDR = '#cic-network-ip-ipv6-2',
            IPV4MASK = '#cic-network-mask-ipv4',
            IPV6MASK = '#cic-network-mask-ipv6',
            IPV4GATEWAY = '#cic-network-gateway-ipv4',
            IPV6GATEWAY = '#cic-network-gateway-ipv6',
            NODE1_IPV4 = '#cic-network-node1-ipv4',
            NODE1_IPV6 = '#cic-network-node1-ipv6',
            NODE2_IPV4 = '#cic-network-node2-ipv4',
            NODE2_IPV6 = '#cic-network-node2-ipv6',
            DNS1 = '#cic-network-preferred-dns',
            DNS2 = '#cic-network-alternate-dns',
            SPLASH_DIALOG_BASE = '#cic-network-splash-dialog',
            SPLASH_PROGRESS_BASE = '#cic-network-splash-progress',
            SPLASH_ESTIMATE_BASE = '#cic-network-splash-estimate',
            SPLASH_BROWSER_WARNING = '#cic-network-splash-browserwarn',
            FLOATING_IPTYPE_LABEL = '#cic-network-floating-iptype-label',
            SPINNER = '#cic-network-spinner',
            HAS_ERROR = '#cic-network-form input.hp-error',
            NOTIFY_MSG = ".hp-details-notify-message",
            NOTIFICATION_COLOR_PREFIX = "hp-details-notify-",
            IPV6_SWITCH = "#cic-network-ipv6-switch",
            HOSTNAME_LABEL = '#cic-selfsigned-label-comma-list-explain',
            AFFECTS_LAYOUT = '.cic-network-affects-layout',
            IPV4FIELDS = '.cic-network-ipv4',
            IPV6FIELDS = '.cic-network-ipv6',
            DNSFIELDS = '.cic-network-dns',
            IPV6_NONDHCP_FIELDS = ".cic-nonDHCP-ipv6",
            ONE_NODE_LAYOUT = '.cic-one-node-layout',
            TWO_NODE_LAYOUT = '.cic-two-node-layout',
            MULTI_NIC_PANEL = "#fs-fsnetwork-panel-nics",
            PANEL_IPV4 ='#cic-fsnetwork-panel-ipv4',
            PANEL_DNS = '#cic-fsnetwork-panel-dns',
            PANEL_IPV6 = '#cic-fsnetwork-panel-ipv6',
            USAGE = '#cic-network-usage',
            DNS_PREFERRED = '#cic-network-preferred-dns',
            DNS_ALTERNATE =  '#cic-network-alternate-dns',
            DEVICE = '#cic-network-device',
            MAC_ADDR = '#cic-network-macaddress',
            DHCP_IPV6_ASSIGN = '#cic-network-ipv6-dhcp',
            STATIC_IPV6_ASSIGN = '#cic-network-ipv6-static',
            ADDRESS_IPV4_ASSIGNMENT = '#cic-network-address-assignment-fieldset',
            ADDRESS_IPV6_ASSIGNMENT = '#cic-network-address-assignment-fieldset-ipv6',
            NETWORK_ONE_NODE_IPV6 = '#cic-network-one-node-ipv6-fieldset',
            NETWORK_IPV6 = '#cic-network-ipv6',
            NETWORK_ONE_ONE_NODE_IPV4 = "#cic-network-one-node-ipv4-fieldset",
            UNASSIGNIPV4 = "#cic-network-ipv4-unassign",
            UNASSIGNIPV6 = "#cic-network-ipv6-unassign",
            SUBNET_MASK_IPV4_ID = "#cic-network-subnetmask-ipv4",
            SUBNET_MASK_IPV6_ID = "#cic-network-ipv6-subnetmask",
            GATEWAY_IPV6_ID = "#cic-network-ipv6-gateway",
            HOSTNAME_PANEL  = "#fs-fsnetwork-panel-hostname",
            FS_SECONDARY_IPV4_LABEL = '#cic-network-ipv4-2a-label',
            FS_NETWORK_IPV4_LABEL = '#cic-network-ipv4-label',
            SECTION_ERR_GRP = '#hp-form-section-errors',
            SECTION_ERR = '#hp-form-errors',
            TIME_SECTION_ERR_GRP = '#hp-timeandlanguage-errors',
            TIME_SECTION_ERR = '#hp-form-timeandlanguage-errors',
            IPV4TYPE = "#fs-network-ipv4type",
            IPV6TYPE = "#fs-network-ipv6type",
            DUAL_STACK_WARNING = "#cic-network-dualstack-warning",
            SECTION_CERTIFICATE_ERR_GRP = "#hp-certificate-errors",
            SECTION_CERTIFICATE_ERR = "#hp-form-certificate-errors";
        
           // pulsar cert changes
            
        var CLASS_RABBITMQ_LISTNER = ".fs-rabbitmq-listner",
            CLASS_POSTGRESQL_LISTNER = ".fs-postgresql-listner",
            RABBITMQ_LISTNER = "#fs-rabbitmq-listner",
            POSTGRESQL_LISTNER = "#fs-postgresql-listner",
            //APACHE WEBSERVER CERTCHAIN CERT 
            WEBSERVER_SERVER_CERT_TEXT = "#fs-webserver-cert-text",
            //APACHE WEBSERVER SERVERCERT CERT
            WEBSERVER_CERTCHAIN_TEXT = "#fs-webserver-certchain-text",
            //APACHE WEBSERVER PRIVATEKEY CERT
            WEBSERVER_PRIVATEKEY_TEXT = "#fs-webserver-privatekey-text",
            //RABBITMQ SERVERCERT CERT
            RABBITMQ_SERVER_CERT_TEXT = "#fs-rabbitmq-server-cert-text",
            //RABBITMQ PRIVATEKEY CERT
            RABBITMQ_PRIVATEKEY_TEXT = "#fs-rabbitmq-privatekey-text",
            //RABBITMQ ROOTCA CERT CERT
            RABBITMQ_ROOTCA_CERT_TEXT = "#fs-rabbitmq-rootca-cert-text",
            //POSTGRESQL SERVER CERT CERT
            POSTGRESQL_SERVER_CERT_TEXT = "#fs-postgresql-server-cert-text",
            //POSTGRESQL PRIVATEKEY CERT
            POSTGRESQL_PRIVATEKEY_TEXT = "#fs-postgresql-privatekey-text",
            //POSTGRESQL ROOTCA CERT CERT
            POSTGRESQL_ROOTCA_CERT_TEXT = "#fs-postgresql-rootca-text";
        
        var RABBITMQ_SECTION = '#fs-rabbitmq-section',
            RABBITMQ_CACERT_SECTION = '#fs-rabbitmq-cacertificate-section',
            RABBITMQ_SERVERCERT_SECTION = '#fs-rabbitmq-servercertificate-section',
            RABBITMQ_PRIVATEKEY_SECTION = '#fs-rabbitmq-privatekey-section',
            RABBITMQ_SHOW = '.fs-rabbitmq-show',
            POSTGRESQL_SHOW = '.fs-postgresql-show',
            POSTGRESQL_SERVERCERT_SECTION = '#fs-postgresql-servercertificate-section',
            POSTGRESQL_PRIVATEKEY_SECTION = '#fs-postgresql-privatekey-section',
            POSTGRESQL_CACERT_SECTION = '#fs-postgresql-cacertificate-section',
            POSTGRESQL_SECTION = '#fs-postgresql-section',
            WEBSERVER_SERVCERT_SECTION = '#fs-webserver-servercertificate-section',
            WEBSERVER_CACERT_SECTION = '#fs-webserver-cacertificate-section',
            WEBSERVER_PRIVATEKEY_SECTION = '#fs-webserver-privatekey-section',
            DISABLE_NIC_CONFIGURATION_THROUGH_UI_KEY  = 'disableNICConfigurationThroughUI',
            DISABLE_NIC_UNCONFIGURE_THROUGH_UI_KEY = 'disableUnconfigureNICThroughUI',
            DISABLE_UPDATENIC_CONFIGURATION_THROUGH_UI_KEY = 'disableUpdateNICConfigurationThroughUI',
            RABBITMQ_ENABLED_NICS_KEY = 'rabbitmqEnabledNICs',
            USER_ALLOWEDTO_CHANGE_RABBITMQ_CONFG_KEY = 'userAllowedToChangeRabbitMQConf',
            RABBITMQ_CERT_ENABLED_KEY = 'importRabbitmqCertificateEnabled',
            POSTGRES_ENABLED_NICS_KEY = 'postgresEnabledNICs',
            USERALLOWEDTO_CHANGE_POSTGRES_CONF_KEY = 'userAllowedToChangePostgresConf',
            POSTGRES_CERT_ENABLED_KEY = 'importPostgresCertificateEnabled',
            WEBSERVER_CERT_ENABLED_KEY = 'importWebserverCertificateEnabled',
            WEBSERVER_ENABLED_NICS_KEY = 'webserverEnabledNICs',
            certificatepanelshow = '.fs-certificates',
            DISABLE_UNCONFIGURE_NIC_THROUGH_REST_KEY = 'disableUnconfigureNICThroughREST',
            DISABLE_UPDATE_NIC_THROUGH_REST_KEY = 'disableUpdateNICConfigurationThroughREST',
            DISABLE_CONFIGURE_NIC_THROUGH_REST_KEY = 'disableNICConfigurationThroughREST',
            POSTGRES_LISTNER_WARN = '#fs-postgresql-listner-warning',
            RABBITMQ_LISTENER_WARN = '#fs-rabbitmq-listner-warning';
    
        var servicespanel = "#fs-panel-services",
            certificatepanel = "#fs-panel-certificate",
            webservicepanel = "#fs-panel-webservercertificate",
            sericespanelheader = ".fs-services",
            webserviceheader = ".fs-webservercertificate",
            CLASS_READONLY = ".readonly",
            CLASS_DISABLED = ".disabled",
            CLASS_UNCONFIGURE = ".unconfigure";
        
        

        var MAX_NO_OF_NICS_DISPLAYED_KEY='maxNoOfNICsDisplayed',
            MAX_NO_OF_NICS_SUPPORTED_DISABLED_KEY='maxNoOfNICsSupported',
            NIC_USAGE_CONFIGURABLE_DISABLED_KEY='nicUsageEditable',
            ALIAS_SUPPORTED_DISABLED_KEY='aliasSupported',
            ALIAS_SUPPORTED_DISABLED_OLD_KEY='ipaliasHostname',
            DHCP_DISABLED_KEY='dhcpDisabled',
            IPV6_DISABLED_KEY='ipv6Disabled',
            MULTI_NIC_SAMESUBNET_VALDATION_DISABLED_KEY = 'multiNICSameSubnetValidationDisabled',
            MULTI_NIC_DISABLED_KEY = 'multiNICDisabled',
            EDIT_DNS_ADDITIONAL_NIC_DISABLED_KEY = 'editDnsForAdditionalNICsDisabled',
            EDIT_GATEWAY_ADDITIONAL_NIC_DISABLED_KEY = 'editGatewayForAdditionalNICsDisabled',
            GENERATE_CERT_FOR_EACH_NIC_DISABLED_KEY ='generateCertificateForEachNicDisabled',
            NIC_USAGE_LABELS_KEY = 'nicUsageLabels',
            UNASSIGNED = 'Unassigned';

        var   macId = "#cic-network-macaddress",
              deviceId = "#nic-device",
              usageId = "#cic-network-usage";

        var DISABLED = 'disabled',
            REQUIRED = 'required',
            ADD = 'add',
            REMOVE = 'remove',
            FQDN = 'fqdn',
            IPV4 = 'ipv4',
            IPV6 = 'ipv6',
            HOSTNAME_RULE = 'hostname',
            MASKV4 = 'maskv4',
            MASKV6 = 'maskv6',
            SIZE = 'size',
            IPV6_SIZE = '45',
            IPV4_SIZE = '15',
            INVALID_PARAMETER_ERROR_CODE = 'INVALID_PARAMETER',
            HIDDEN = "-hidden";

        // name of setting for nic alias association
        var NIC_ALIAS_ASSOCIATION_SETTING_NAME = 'nic-associated-with-alias';

        var aliasNICMacAddress = null;

        var firstTimeFlag = false,
            notifyResultFlag = true,
            formStateView = new FormStateView(), routePrefix, form,
            fieldValueChangedFlag = false,
            MAX_NTP_SERVERS_CONFIGURABLE = 3;

        var networkInterfaceTableView = new NetworkInterfaceTableView();
        var primaryConfig = null;

        var CLASS_IPV6_DISABLE = '.cic-fsnetwork-ipv6-remove',
            CLASS_IPV4_DHCP_FIELDS = '.fs-network-IPv4-DHCP',
            CLASS_IPV6_DHCP_FIELDS = '.fs-network-IPv6-DHCP',
            CLASS_IPV4_CLUSTER_ADDR_DHCP = '.fs-network-IPv4-cluster-IP-DHCP',
            CLASS_IPV6_CLUSTER_ADDR_DHCP = '.fs-network-IPv6-cluster-IP-DHCP',
            CLASS_IPV4_NON_DHCP_ERRORS = '.ipv4-non-DHCP-errors',
            CLASS_IPV6_NON_DHCP_ERRORS = '.ipv6-non-DHCP-errors',
            CLASS_SECOND_IP = '.cic-second-ip',
            CLASS_DHCP_SELECTOR = '.cic-dhcp-allowed',
            CLASS_IPV6_INPUT_FIELDS = '.cic-ipv6-fields',
            SPLASH_DIALOG, SPLASH_PROGRESS, SPLASH_ESTIMATE,
            CLASS_NETWORK_DNS = '.cic-fsnetwork-dns',
            CLASS_HOSTNAME = '.cic-fsnetwork-hostname',
            CLASS_NICS = ".fs-fsnetwork-nics",
            DNS1_ID = "#fs-network-IPv4-dns1-IP-DHCP",
            DNS2_ID = "#fs-network-IPv4-dns2-IP-DHCP",
            CLASS_IPV4 = ".cic-fsnetwork-ipv4";


         var aliasDisabled = false;
         var aliasVisible = false;

         var DNS_FROM_DHCP='.fs-network-dns-DHCP';

         var AUTOGENERATED_PREFIX='ci-';

         var HOSTNAME_ORIGINAL = '';
         var STATIC_IP_ASSIGN = "#cic-network-ipv4-static",
             DHCP_IP_ASSIGN = "#cic-network-ipv4-dhcp",
             dhcpIPV6AssignId = "#cic-network-ipv6-dhcp";


         var multiNICDisabled = false,
             maxNoOfNICsDisplayed = 8,
             maxNoOfNICsSupported = 8,
             singleNicEnabled = true,
             aliasSupported = false,
             aliasSupportedOld = null,
             postValidationOccuredFS = false;

        var ipV6dhcpmsg = "#fs-network-IPv6-onenode-cluster-IP-DHCP",
             ipV4dhcpmsg = "#fs-network-IPv4-onenode-cluster-IP-DHCP",
            ipV4maskdhcpmsg = "#fs-network-IPv4-mask-DHCP",
            ipV4gatewaymsg = "#fs-network-IPv4-gateway-IP-DHCP",
            ipV6subnetdhcpmsg = "#fs-network-IPv6-subnet-IP-DHCP",
            ipV6gatewaydhcpmsg = "#fs-network-IPv6-gateway-IP-DHCP";

         //Time and place

         var NTP_SERVER_TEXT = '#cic-network-ntpserver',
         CURRENT_DATE_TIME_TEXT = '#cic-network-currentdatetimeText',
         LOCALE = '#cic-network-locale',
         TIME_SYNC_MANUAL='#cic-network-manualdatetime',
         TIME_AND_PLACE_CHOOSER ='timeandplacechooser',
         TIME_AND_PLACE_RADIO_GRP='input[type="radio"][name='+TIME_AND_PLACE_CHOOSER+']:checked';
         var localeList = [];
         var locale_str ="" ;
         var locale_val ="" ;
         var unconfiguredDeployementMac = null;
         var applianceMoreView = false;


         // newly added
         var CLASS_PREFIX = '.fs-settings-appliance',
             CLASS_1NODE = CLASS_PREFIX + '-1node',
             CLASS_2NODE = CLASS_PREFIX + '-2node',
             CLASS_IPV6 = CLASS_PREFIX + '-IPv6',
             CLASS_IPV4_DHCP = CLASS_PREFIX + '-IPv4-DHCP',
             CLASS_IPV6_DHCP = CLASS_PREFIX + '-IPv6-DHCP',
             CLASS_SECOND_IPv6_IP = CLASS_PREFIX + '-Ipv6-secondIP';

         var ID_PREFIX = CLASS_PREFIX.replace('.', '#'),
             IPV4_PREFIX = ID_PREFIX + '-IPv4',
             IPV6_PREFIX = ID_PREFIX + '-IPv6',
             ADDR_1NODE = '-address-1node',
             ADDRTYPE = '-addrtype',
             SUBNET = '-subnet',
             GATEWAY = '-gateway';

         var DNS_PREFIX = ID_PREFIX + '-DNS',
             PREFERRED = DNS_PREFIX + '-preferred',
             ALTERNATE = DNS_PREFIX + '-alternate';

         var FROM_DHCP = '-from-DHCP',
             PANELS = ID_PREFIX + '-panels',
             UNAVAILABLE = 'hp-unavailable';

         var secondIPUsed = false;
         var APPLIANCE_IPV4_PANEL = "#fs-settings-appliance-IPv4",
             APPLIANCE_DNS_PANEL = "#fs-settings-appliance-DNS",
             APPLIANCE_IPV6_PANEL = "#fs-settings-appliance-IPv6";
         var TOTAL_DELAY = 40000;
         var REDIRECT_DELAY = 0;
         var APPLIANCE = 'Appliance';



        function NetworkEditViewBase() {

            // The notification div to display notifications in.
            var notifyElement;

            // The validator for the form.
            var validator;

            // ID of the local node.
            var localNodeID;

            // Flag whether we are showing two-node (vs. one-node) configuration.
            var isTwoNode;


            // original configuration

            var originalConfig;

            //manual DateTime change flag
            var dateTimeChanged = false;


            // Splash dialog timer
            var splashTimer;

            // Is second IP configured

            var secondIPConfigured;

            // switching from manual to DHCP
            var manualToDhcp = false;


            var nicCnt =1;
            var primaryNetworkObj;
            var aliasAssocNICObj;

            var editedPrimaryNetworkObj;

            /**
             * @private Formats error information from a REST request
             * @param errorInfo {object} Rest request error information
             * @returns {String} Formatted error information to display
             */
            function formatNotificationDetails(errorInfo) {

                var resolution = (errorInfo.resolution && errorInfo.resolution !== '?') ? '\n' + errorInfo.resolution : '';
                var message = (errorInfo.message && errorInfo.message !== '?') ? '\n' + errorInfo.message : '';

                // we can't say that we were unable to apply network since most likely the settings were applied but we cannot
                // reach new network settings, hence instead of "Unable to apply netowrk settings" we say that "Appliance is no
                //longer reachable"
                var failureNotificationDetails = ( (errorInfo.errorCode == presenter.REACHABLE_ERROR) ||
                                              (errorInfo.errorCode == presenter.MANUAL_TO_DHCP_ERROR) ) ? '\n' + resolution :
                                               '\n' + message + resolution;
                return failureNotificationDetails;
            }



            /**
             * @private Displays the  warning notification as well as details about the warnings
             * @param {string} message Message containing high level error message
             * @param {string} details Message containing error details
             * @param {string} messageType indicates the type of notification such as error
             */
            function displayTaskNotifications() {
                if (notifyResultFlag) {
                    var notif = {
                      sourceName: localizer.getString('fs.settings.network.notify.sourceName'),
                      summary: localizer.getString('fs.settings.network.notify.set.error'),
                        status : 'error',
                        details : localizer.getString('fs.settings.network.notify.set.parameterError')

                   };
                    formStateView.setMessage(notif);
                    notifyResultFlag = false;

                }
            }
            /**
             * @private Displays an error notification as well as details about the error
             * @param {string} message Message containing high level error message
             * @param {string} details Message containing error details
             * @param {string} messageType indicates the type of notification such as error
             */
            function displayNotifications(message, details, type) {
                if (notifyResultFlag) {
                    var notif = {
                        sourceName: localizer.getString('fs.settings.network.notify.sourceName'),
                        summary : message,
                        status : 'error',
                        details : details
                    };
                    formStateView.setMessage(notif);

                    notifications.add(notif, true);
                    notifyResultFlag = false;
                }
            }


            /**
             * When the setNetworkConfiguration completes successfully,  notify the caller of success.
             * The caller will dismiss the dialog
             * If we're supposed to redirect, give the caller a method to call to do that.
             */
            function onSetConfigSuccess(data, handlers) {

                // data.rechableDelay is the time which has already been spent,
                // so subtract it from the the Total Delay to get the time we need to wait more before redirecting.
                // data.rechableDelay is not set in the scenario where the cerificate has already been generated and
                // the appliance is reachable with the new certificate, so no need to wait more.
                if(data.rechableDelay) {
                    REDIRECT_DELAY = TOTAL_DELAY - data.rechableDelay;
                } else {
                    REDIRECT_DELAY = 0;
                }
                // occasionaly the timeouts are set twice resulting this function being called twice on success
                // this causes duplicate messages in the notificication bar. The flag is to workaround this problem.
                // TODO : when doing two nodes revisit the timeouts resets
                if (notifyResultFlag) {
                    var notif = {
                        sourceName: localizer.getString('fs.settings.network.notify.sourceName'),
                        summary : localizer.getString('fs.settings.network.notify.set.success'),
                        status : 'ok'
                    };
                    notifications.add(notif, true);
                    formStateView.setMessage(notif);
                    notifyResultFlag = false;
                }


                if(data.host) {
                    //If kiosk mode, then no need to wait for certificate generation
                    if(window.location.host === 'localhost' || environment.isKioskMode()){
                        window.location.href = 'http://' + data.host;
                        handlers.success(true);
                    } else {
                        setTimeout(function() {
                            window.location.href = 'https://' + data.host;
                            handlers.success(true);
                        }, REDIRECT_DELAY);
                    }
                } else


                    if(data.state === 'post-validation')
                    {

                            if(firstTimeFlag){
                                setTimeout(function() {
                                    postValidationOccuredFS = true;
                                    handlers.success(null);
                                    return;
                                }, REDIRECT_DELAY);
                            }
                            data.host = window.location.host;
                            //check for localhost also to be foolproof. If kiosk mode, then no need to wait for certificate generation
                            if(data.host === 'localhost' || environment.isKioskMode() ){
                                window.location.href = 'http://'+ data.host+'#/activity';
                                handlers.success(window.location.href);
                            } else {
                                setTimeout(function() {
                                    window.location.href = 'https://'+ data.host+'#/activity';
                                    handlers.success(window.location.href);
                                }, REDIRECT_DELAY);
                            }

                    } else {
                        setTimeout(function() {
                            //In case of alias and independent nic changes for firefox 23 a certificate has
                            //to be generated so we redirect to hostname directly.
                            if(data.certError){
                                data.host = window.location.host;
                                window.location.href = 'https://'+ data.host;
                                handlers.success(window.location.href);
                            }
                            else{
                                handlers.success(null);
                            }
                        }, REDIRECT_DELAY);
                    }

            }

            /**
             * When the setNetworkConfiguration call returns success, indicating that the asynchronous change has started,
             * raise the splash dialog.
             */
            function onSetConfigRunning(timeout) {
                $(SPLASH_ESTIMATE).text(localizer.getString('fs.settings.network.dialog.redirect'));
                if(aliasSupportedOld != null){
                    if(firstTimeFlag){
                        $(SPLASH_BROWSER_WARNING).text(localizer.getString('fs.settings.network.dialog.altairftswarn'));
                    }
                    else {
                        $(SPLASH_BROWSER_WARNING).text(localizer.getString('fs.settings.network.dialog.altaireditappliancewarn'));
                    }
                }
                else {
                    if (presenter.shouldRedirect()){
                        $(SPLASH_BROWSER_WARNING).text(localizer.getString('fs.settings.network.dialog.browserwarn'));
                    }
                }
                $(SPLASH_DIALOG).dialog({
                    modal : true,
                    position : "center",
                    draggable : false,
                    resizable : false,
                    show : 'fade',
                    dialogClass : 'hp-splash-dialog',
                    width : 400
                });

                // update progress
                $(SPLASH_PROGRESS).hpProgressBar(0);
                var done = 0;
                splashTimer = setInterval(function() {
                    done += 1000;
                    $(SPLASH_PROGRESS).hpProgressBar((done * 100) / timeout);
                }, 1000);
            }

           /**
             * Dismiss dialog with teh spiiner
           */
            function dismissDialogWindow() {

                if(splashTimer) {
                    clearTimeout(splashTimer);
                    splashTimer = null;
                    $(SPLASH_DIALOG).dialog('destroy');
                }
            }

            /**
             * Reset the section Errors
             */
            function resetSectionErrors() {
            	$(SECTION_ERR).text('');
                $(SECTION_ERR_GRP).css('visibility','hidden');
                $(SECTION_ERR_GRP).removeClass('hp-section-errors');
                $(SECTION_CERTIFICATE_ERR).text('');
                $(SECTION_CERTIFICATE_ERR_GRP).css('visibility','hidden');
                $(SECTION_CERTIFICATE_ERR_GRP).removeClass('hp-section-errors');
                $(TIME_SECTION_ERR).text('');
                $(TIME_SECTION_ERR_GRP).css('visibility','hidden');
                $(TIME_SECTION_ERR_GRP).removeClass('hp-section-errors');
                if(!singleNicEnabled){
                    var rows = $('#cic-appliance-nics-table').dataTable().fnGetNodes();
                    for(var i = 0; i < rows.length; i++) {
                        var aRowData = $('#cic-appliance-nics-table').dataTable().fnGetData( rows[i] );
                        var cnt = networkInterfaceTableView.getTableRowIndex(aRowData.slno);
                        $(SECTION_ERR+'-'+cnt).text('');
                        $(SECTION_ERR_GRP+'-'+cnt).css('visibility','hidden');
                    }
                }
            }

            /**
             * Show the errors for particular section.
             */
            function showSectionError(singleNicEnabled,cnt,group,sectionErrorsId,errorMessage){
            	var errordetails =
            		'<div class="hp-notification-details hp-sub-details">'+
            		'<div class="hp-details">'+
            		'<p>'+errorMessage+'</p>'+
            		'</div>'+
            		'</div>';

                if(!singleNicEnabled){
                	group = group + '-' + cnt;
                	sectionErrorsId = sectionErrorsId + '-' + cnt;
                }
                $(group).addClass('hp-section-errors');
                $(group).css('visibility','visible');
                $(sectionErrorsId).append(errordetails);
            }

            /**
             * @private Add a server side error to the list of errors that the validator will display
             * @param {object} validatorErrors The list of errors that the validator will display
             * @param {object} errorFromServer The error from a REST response body to add to the list
             */
            function addValidatorError(validatorErrors, errorFromServer) {
                var errorMessage = errorFromServer.message;
                var sourceId = errorFromServer.errorSource;
                var errorCode = errorFromServer.errorCode;
                var handled = true;
                var errorMacAddr = "";
                if ( (errorCode != null) && (errorCode.indexOf("@")!= -1)){
                     errorMacAddr = errorCode.substring(0,errorCode.indexOf("@"));
                }
                else{
                    errorMacAddr = errorCode;
                }

                var cnt = 0;
                var rows = $('#cic-appliance-nics-table').dataTable().fnGetNodes();
                for(var i = 0; i < rows.length; i++) {
                    var row = rows[i];
                    var macAddress = null;
                    var aRowData = $('#cic-appliance-nics-table').dataTable().fnGetData( row );
                    var eth1MacAddress = aRowData.aliasSupport;

                    if (eth1MacAddress != null && eth1MacAddress.indexOf("aliasMacAddr-")>=0){
                        //eth1 configured for alias
                        macAddress = eth1MacAddress.substr(eth1MacAddress.indexOf("-")+1);
                    } else {
                        macAddress = ($(rows[i]).find(".mac-address").html());
                    }

                  if (macAddress == ''){
                       macAddress = unconfiguredDeployementMac;
                  }

                  var slno = aRowData.slno;
                  if(sourceId == 'app1Ipv4Alias') {
                      var ipAddress =($(row).find(".ipAddress").html());
                      if(ipAddress == UNASSIGNED){
                          cnt = networkInterfaceTableView.getTableRowIndex(slno);
                      }
                      if(aRowData.interfaceType != 'Primary'){
                          cnt = networkInterfaceTableView.getTableRowIndex(slno);
                          break;
                      }
                  }
                  else {
                      if(macAddress === errorMacAddr){
                          cnt = networkInterfaceTableView.getTableRowIndex(slno);
                      }
                  }
                }


                var ip_ipv4 =  'ip-ipv4',
                   ip_ipv4_2 = 'ip-ipv4-2a',
                   ip_ipv6 =  'ip-ipv6',
                   ip_ipv6_2 = 'ip-ipv6-2',
                   floating_ip_ipv4 = 'floating-ip-ipv4',
                   floating_ip_ipv6 = 'floating-ip-ipv6',
                   node1_ipv4 = 'node1-ipv4',
                   node1_ipv6 = 'node1-ipv6',
                   node2_ipv4 = 'node2-ipv4',
                   node2_ipv6 = 'node2-ipv6',
                   mask_ipv4 = 'mask-ipv4',
                   mask_ipv6 = 'mask-ipv6',
                   gateway_ipv4 = 'gateway-ipv4',
                   gateway_ipv6 = 'gateway-ipv6',
                   dns1 = 'dns1' ,
                   dns2 = 'dns2',
                   hostname = 'hostname',
                   interfaceName = 'nic-device',
                   webServerCertificate = 'webServerCertificate',
                   webServerCertificateKey = 'webServerCertificateKey',
                   webServerCertificateChain = 'webServerCertificateChain',
                   rabbitMQCertificate = 'rabbitMQCertificate', 
                   rabbitMQCertificateKey = 'rabbitMQCertificateKey',
                   rabbitMQRootCACertificate = 'rabbitMQRootCACertificate',
                   postgresCertificate = 'postgresCertificate',
                   postgresCertificateKey = 'postgresCertificateKey',
                   postgresRootCACertificate = 'postgresRootCACertificate';
                   //macAddressKey = 'macAddress',
                   //serverCertificate = 'serverCertificate';




                if(!singleNicEnabled) {
                    ip_ipv4 =  'ip-ipv4-'+cnt,
                       ip_ipv4_2 = 'ip-ipv4-2-'+cnt,
                       ip_ipv6 =  'ip-ipv6-'+cnt,
                       ip_ipv6_2 = 'ip-ipv6-2' + '-' + cnt,
                       floating_ip_ipv4 = 'floating-ip-ipv4-'+cnt,
                       floating_ip_ipv6 = 'floating-ip-ipv6-'+cnt,
                       node1_ipv4 = 'node1-ipv4-'+cnt,
                       node1_ipv6 = 'node1-ipv6-'+cnt,
                       node2_ipv4 = 'node2-ipv4-'+cnt,
                       node2_ipv6 = 'node2-ipv6-'+cnt,
                       mask_ipv4 = 'mask-ipv4-'+cnt,
                       mask_ipv6 = 'mask-ipv6-'+cnt,
                       gateway_ipv4 = 'gateway-ipv4-'+cnt,
                       gateway_ipv6 = 'gateway-ipv6-'+cnt,
                       dns1 = 'dns1' + '-' + cnt,
                       dns2 = 'dns2' + '-' + cnt,
                       hostname = 'nic-hostname' + '-' + cnt,
                       interfaceName = 'nic-device-' + cnt,
                       webServerCertificate = 'webServerCertificate-' + cnt,
                       webServerCertificateKey = 'webServerCertificateKey-' + cnt,
                       webServerCertificateChain = 'webServerCertificateChain-' + cnt;


                }

                // first check for any sourceIds  containing 'hostname' keyword  as fts added new keywords
                // for possible future multiple hostnames taht are associated with the hostname field
                // TOD: narrow down to the fields only pertinent to GUI ad falg all others as invalid parameters
                // will do it when fts solidifies their design

                if(/hostName/.test(sourceId)) {
                    validatorErrors[hostname] = errorMessage;
                    showSectionError(singleNicEnabled,cnt,SECTION_ERR_GRP,SECTION_ERR,errorMessage);

                    return handled;
                }
                switch (sourceId) {

                    case 'domainName':
                        // fts has change the logic where they return two separate erros : one for the hostname
                        // and one for the domain. Need to concatenate these message to display them next to
                        // hostname field
                        var s1 = validatorErrors[hostname];
                        if(s1 == undefined) {
                            validatorErrors[hostname] = errorMessage;
                        } else {
                            validatorErrors[hostname] = s1 + errorMessage;
                        }
                        break;

                    case 'app1Ipv4Addr' :
                        if(isTwoNode) {
                            validatorErrors[node1_ipv4] = errorMessage;
                        } else if(localNodeID == 1) {
                            validatorErrors[ip_ipv4] = errorMessage;
                        } else {
                            validatorErrors[ip_ipv4] = errorMessage;
                            handled = false;
                        }
                        showSectionError(singleNicEnabled,cnt,SECTION_ERR_GRP,SECTION_ERR,errorMessage);
                        break;
                    case 'app1Ipv6Addr' :
                        if(isTwoNode) {
                            validatorErrors[node1_ipv6] = errorMessage;
                        } else if(localNodeID == 1) {
                            validatorErrors[ip_ipv6] = errorMessage;
                        } else {
                            validatorErrors[ip_ipv6] = errorMessage;
                            handled = false;
                        }
                        showSectionError(singleNicEnabled,cnt,SECTION_ERR_GRP,SECTION_ERR,errorMessage);
                        break;
                    case 'app2Ipv4Addr' :
                        if(isTwoNode) {
                            validatorErrors[node2_ipv4] = errorMessage;
                        } else if(localNodeID == 2) {
                            validatorErrors[ip_ipv4] = errorMessage;
                        } else {
                            handled = false;
                        }
                        showSectionError(singleNicEnabled,cnt,SECTION_ERR_GRP,SECTION_ERR,errorMessage);
                        break;
                    case 'app2Ipv6Addr' :
                        if(isTwoNode) {
                            validatorErrors[node2_ipv6] = errorMessage;
                        } else if(localNodeID == 2) {
                            validatorErrors[ip_ipv6] = errorMessage;
                        } else {
                            handled = false;
                        }
                        showSectionError(singleNicEnabled,cnt,SECTION_ERR_GRP,SECTION_ERR,errorMessage);
                        break;
                    case 'virtIpv4Addr' :
                        if(isTwoNode) {
                            validatorErrors[ip_ipv4] = errorMessage;
                        } else {
                            handled = false;
                        }
                        showSectionError(singleNicEnabled,cnt,SECTION_ERR_GRP,SECTION_ERR,errorMessage);
                        break;
                    case 'virtIpv6Addr' :
                        if(isTwoNode) {
                            validatorErrors[ip_ipv6] = errorMessage;
                        } else {
                            handled = false;
                        }
                        showSectionError(singleNicEnabled,cnt,SECTION_ERR_GRP,SECTION_ERR,errorMessage);
                        break;
                    case 'ipv4Subnet' :
                        validatorErrors[mask_ipv4] = errorMessage;
                        showSectionError(singleNicEnabled,cnt,SECTION_ERR_GRP,SECTION_ERR,errorMessage);
                        break;
                    case 'InterfaceName' :
                        validatorErrors[interfaceName] = errorMessage;
                        showSectionError(singleNicEnabled,cnt,SECTION_ERR_GRP,SECTION_ERR,errorMessage);
                        break;
                    case 'ipv6Subnet' :
                        validatorErrors[mask_ipv6] = errorMessage;
                        showSectionError(singleNicEnabled,cnt,SECTION_ERR_GRP,SECTION_ERR,errorMessage);
                        break;
                    case 'ipv4Gateway' :
                        validatorErrors[gateway_ipv4] = errorMessage;
                        showSectionError(singleNicEnabled,cnt,SECTION_ERR_GRP,SECTION_ERR,errorMessage);
                        break;
                    case 'ipv6Gateway' :
                        validatorErrors[gateway_ipv6] = errorMessage;
                        showSectionError(singleNicEnabled,cnt,SECTION_ERR_GRP,SECTION_ERR,errorMessage);
                        break;
                    case 'nameServer1' :
                        if($(DNS1).val()) {
                            validatorErrors[dns1] = errorMessage;
                        } else {
                            validatorErrors[dns2] = errorMessage;
                        }
                        showSectionError(singleNicEnabled,cnt,SECTION_ERR_GRP,SECTION_ERR,errorMessage);
                        break;
                    case 'nameServer2' :
                        validatorErrors[dns2] = errorMessage;
                        showSectionError(singleNicEnabled,cnt,SECTION_ERR_GRP,SECTION_ERR,errorMessage);
                        break;
                    case 'app1Ipv4Alias' :
                        var aliasVisible = true;
                        if(!singleNicEnabled) {
                            aliasVisible = $('#cic-alias-fieldset-'+cnt).is(':visible');
                            if(aliasVisible){
                                validatorErrors[ip_ipv4] = errorMessage;
                            } else {
                                validatorErrors['ip-ipv4-100'] = errorMessage;
                            }

                        }else {
                            validatorErrors[ip_ipv4_2] = errorMessage;
                        }
                        if(aliasVisible){
                            showSectionError(singleNicEnabled,cnt,SECTION_ERR_GRP,SECTION_ERR,errorMessage);
                        } else {
                            showSectionError(singleNicEnabled,100,SECTION_ERR_GRP,SECTION_ERR,errorMessage);
                        }
                        break;
                    case 'app1Ipv6Alias' :
                        validatorErrors[ip_ipv6_2] = errorMessage;
                        showSectionError(singleNicEnabled,cnt,SECTION_ERR_GRP,SECTION_ERR,errorMessage);
                        break;
                    case 'ntpServer1':
                        $.extend(validatorErrors, {
                            'ntpserver1': errorMessage
                        });
                        showSectionError(true,cnt,TIME_SECTION_ERR_GRP,TIME_SECTION_ERR,errorMessage);
                        break;
                    case 'ntpServer2':
                        $.extend(validatorErrors, {
                            'ntpserver2': errorMessage
                        });
                        showSectionError(true,cnt,TIME_SECTION_ERR_GRP,TIME_SECTION_ERR,errorMessage);
                        break;
                    case 'ntpServer3':
                        $.extend(validatorErrors, {
                            'ntpserver3': errorMessage
                        });
                        showSectionError(true,cnt,TIME_SECTION_ERR_GRP,TIME_SECTION_ERR,errorMessage);
                        break;
                    case 'setNTP':
                        $.extend(validatorErrors, {
                          'currentdatetime' : errorMessage
                        });
                        errorFromServer.recommendedActions =
                           localizer.getString('fs.settings.network.validator.currentdatetime.datetime_format_resolution');
                        showSectionError(true,cnt,TIME_SECTION_ERR_GRP,TIME_SECTION_ERR,errorMessage);
                        break;
                    case 'validateTimeZone':
                      /// add time zone specific
                        $.extend(validatorErrors, {
                          'timezone_input' : errorMessage
                        });
                        showSectionError(true,cnt,TIME_SECTION_ERR_GRP,TIME_SECTION_ERR,errorMessage);
                        break;
                    case 'setApplianceDefaultLocale':
                        /// add locale specific
                          $.extend(validatorErrors, {
                            'locale_input' : errorMessage
                          });
                          showSectionError(true,cnt,TIME_SECTION_ERR_GRP,TIME_SECTION_ERR,errorMessage);
                          break;
                    case 'webServerCertificate' :
                        validatorErrors[webServerCertificate] = errorMessage;
                        showSectionError(singleNicEnabled,cnt,SECTION_ERR_GRP,SECTION_ERR,errorMessage);
                        break;
                    case 'webServerCertificateKey' :
                        validatorErrors[webServerCertificateKey] = errorMessage;
                        showSectionError(singleNicEnabled,cnt,SECTION_ERR_GRP,SECTION_ERR,errorMessage);
                        break;
                    case 'webServerCertificateChain' :
                        validatorErrors[webServerCertificateChain] = errorMessage;
                        showSectionError(singleNicEnabled,cnt,SECTION_ERR_GRP,SECTION_ERR,errorMessage);
                        break;
                    case 'rabbitMQCertificate' :
                        validatorErrors[rabbitMQCertificate] = errorMessage;
                        showSectionError(true,cnt,SECTION_CERTIFICATE_ERR_GRP,SECTION_CERTIFICATE_ERR,errorMessage);
                        break;
                    case 'rabbitMQCertificateKey' :
                        validatorErrors[rabbitMQCertificateKey] = errorMessage;
                        showSectionError(true,cnt,SECTION_CERTIFICATE_ERR_GRP,SECTION_CERTIFICATE_ERR,errorMessage);
                        break;
                    case 'rabbitMQRootCACertificate' :
                        validatorErrors[rabbitMQRootCACertificate] = errorMessage;
                        showSectionError(true,cnt,SECTION_CERTIFICATE_ERR_GRP,SECTION_CERTIFICATE_ERR,errorMessage);
                        break;
                    case 'postgresCertificate' :
                        validatorErrors[postgresCertificate] = errorMessage;
                        showSectionError(true,cnt,SECTION_CERTIFICATE_ERR_GRP,SECTION_CERTIFICATE_ERR,errorMessage);
                        break;
                    case 'postgresCertificateKey' :
                        validatorErrors[postgresCertificateKey] = errorMessage;
                        showSectionError(true,cnt,SECTION_CERTIFICATE_ERR_GRP,SECTION_CERTIFICATE_ERR,errorMessage);
                        break;
                    case 'postgresRootCACertificate' :
                        validatorErrors[postgresRootCACertificate] = errorMessage;
                        showSectionError(true,cnt,SECTION_CERTIFICATE_ERR_GRP,SECTION_CERTIFICATE_ERR,errorMessage);
                        break;
                    case 'macAddress' :
                        //validatorErrors[macAddressKey] = errorMessage;
                        showSectionError(singleNicEnabled,cnt,SECTION_ERR_GRP,SECTION_ERR,errorMessage);
                        break;
                    case 'serverCertificate' :
                        //validatorErrors[serverCertificate] = errorMessage;
                        showSectionError(singleNicEnabled,cnt,SECTION_ERR_GRP,SECTION_ERR,errorMessage);
                        break;
                    default:
                        handled = false;
                        break;
                }
                return handled;
            }



            /**
             * @private Display invalid parameter errors from the server
             * @param {object} errorInfo The response body generated by a server exception
             */
            function handleParameterErrorsFromServer(errorInfo) {
                var validatorErrors = {};
                var serverErrorList = errorInfo.nestedErrors;
                var serverError;
                var handled = true;
                for(serverError in serverErrorList) {
                    if(!addValidatorError(validatorErrors, serverErrorList[serverError])) {
                        handled = false;
                    }
                }
                validator.showErrors(validatorErrors);

                return handled;
            }
            /**
             * @private Display invalid parameter warnings from the server
             * @param {object} errorInfo The response body generated by a server exception
             */
            function handleTaskErrors(errorInfo) {
                var validatorErrors = {};
                var serverErrorList = errorInfo;
                var serverError;
                var handled = true;
				
                for(serverError in serverErrorList) {
                    if(!addValidatorError(validatorErrors, serverErrorList[serverError])) {
                        handled = false;
                    }
                }
                validator.showErrors(validatorErrors);
                return handled;
            }



            /**
             * @public Handle failed validation by printing error messages
             * @param {object} errorInfo The response body generated by a server exception
             */
            function onSetConfigError(errorInfo) {

                dismissDialogWindow();
                resetSectionErrors();
                // handle the Backend warnings returned from taskt
                if(errorInfo instanceof Array ){
                    handleTaskErrors(errorInfo);
                    displayTaskNotifications();
                  }else{
                      if(errorInfo.errorCode == INVALID_PARAMETER_ERROR_CODE) {
                          handleParameterErrorsFromServer(errorInfo);
                      }
                      var applyErrorMsg = ( (errorInfo.errorCode == presenter.MANUAL_TO_DHCP_ERROR) ||
                              (errorInfo.errorCode == presenter.REACHABLE_ERROR) ) ? errorInfo.message :
                              localizer.getString('fs.settings.network.notify.set.error');
                          var failureNotificationDetails = formatNotificationDetails(errorInfo);
                          displayNotifications(applyErrorMsg, failureNotificationDetails, 'error');
                  }
            }

             /*
              * set dnsFromDHCP reflecting how user specified DNS servers
              *
              */
             function getDnsFromDHCPFlag(addressAssignmentValue, dns1Val, dns2Val, originalConfig) {

                 // if a user selects static address , set the flag to false
            	 if(addressAssignmentValue == presenter.STATIC){
            	     return false;
                 }

                 // if a user specified DHCP and no DNS servers , return true
            	 if(addressAssignmentValue== presenter.DHCP && ((!dns1Val) && (!dns2Val)) ){
            	     return true;
            	 }

                 //if a user specified  DHCP and DNS servers , return false
                 if  ( dns1Val  ||  dns2Val ) {
                     // DHCP -> DHCP case
                     if (originalConfig != null && (originalConfig.priDns ==  dns1Val ) &&
                          (originalConfig.altDns ==  dns2Val ) ) {
                              // if the values did not change
                              return true;
                     } else {
                         // a user typed in new vlaues
                         return false;
                     }
                 } else {
                     return false;
                 }
                 // otherwise leave the flag untouched
                 return(originalConfig.overrideIpv4DhcpDnsServers);
             }


            function createSingleNicObject(){
                var networkDataList = [];

                var	  ipv4addr = null,
                        ipv4Subnet = null,
                        ipv4Gateway = null,
                        ipv6Addr = null,
                        ipv6Subnet = null,
                     ipv6Gateway = null,
                     unconfigure = false,
                     aliasDisabled = true,
                     ipv4_2_Addr = null,
                     ipv4Type = $('input[type="radio"][name=addressAssignment]:checked').val(),
                     ipv6Type = $('input[type="radio"][name=addressAssignmentforv6]:checked').val();

                if (ipv4Type == presenter.STATIC){
                    ipv4addr = $(IPV4IPADDR).val();
                    ipv4Subnet = $(IPV4MASK).val();
                    ipv4Gateway = $(IPV4GATEWAY).val();

                }
                if (ipv4Type == presenter.UNCONFIGURE){
                    unconfigure = true;
                }

                if (ipv6Type == presenter.STATIC){
                    ipv6Addr = $(IPV6IPADDR).val();
                    ipv6Subnet = $(IPV6MASK).val();
                    ipv6Gateway = $(IPV6GATEWAY).val();
                }
                if(aliasSupported == 'true' || aliasSupportedOld != null){

                    ipv4_2_Addr  = $(IPV4_2_IPADDR).val();
                    aliasDisabled = false;
                    ipv4Type='STATIC';
                    ipv4addr = $(IPV4IPADDR).val();
                    ipv4Subnet = $(IPV4MASK).val();
                    ipv4Gateway = $(IPV4GATEWAY).val();
                }
                var configureRabbitMQSSLListener = $(RABBITMQ_LISTNER).is(":checked");
                var configurePostgresSSLListener = $(POSTGRESQL_LISTNER).is(":checked");
                
                var overrideDhcpDnsFlag = getDnsFromDHCPFlag(ipv4Type, $(DNS1).val(), $(DNS2).val(), originalConfig);
                var webServerCertificate = null,
                    webServerCertificateChain =null,
                    webServerCertificateKey = null;

                    if (!$(WEBSERVER_SERVCERT_SECTION).hasClass( "hp-collapsed")){
                        webServerCertificate = $(WEBSERVER_SERVER_CERT_TEXT).val();
                    }
                    if (!$(WEBSERVER_CACERT_SECTION).hasClass( "hp-collapsed")){
                        webServerCertificateChain = $(WEBSERVER_CERTCHAIN_TEXT).val();
                    }
                    if (!$(WEBSERVER_PRIVATEKEY_SECTION).hasClass( "hp-collapsed")){
                        webServerCertificateKey = $(WEBSERVER_PRIVATEKEY_TEXT).val();
                    }

                var networkObject = {

                        activeNode : 1,
                        unconfigure : unconfigure,
                        app1Ipv4Addr: ipv4addr,
                        app1Ipv6Addr: ipv6Addr,
                        app2Ipv4Addr:null,
                        app2Ipv6Addr:null,
                        virtIpv4Addr:null,
                        virtIpv6Addr:null,
                        app1Ipv4Alias:ipv4_2_Addr,
                        app1Ipv6Alias:null,
                        app2Ipv4Alias:null,
                        app2Ipv6Alias:null,
                        hostname:$(HOSTNAME).val(),
                        confOneNode:true,
                        interfaceName:$(usageId).val(),
                        macAddress:$(macId).val(),
                        ipv4Type:ipv4Type,
                        ipv6Type:ipv6Type,
                        // pulsar changes for import cert
                        overrideIpv4DhcpDnsServers:overrideDhcpDnsFlag,
                        ipv4Subnet:ipv4Subnet,
                        ipv4Gateway:ipv4Gateway,
                        ipv6Subnet:ipv6Subnet,
                        ipv6Gateway:ipv6Gateway,
                        domainName:presenter.getDomainName($(HOSTNAME).val(), $(DNS1).val(), $(DNS2).val()),
                        searchDomains:[
                        ],
                        // pulsar changes for import cert
                        ipv4NameServers:[
                           $(DNS1).val(),
                           $(DNS2).val()
                        ],
                        ipv6NameServers:[
                           $(DNS1).val(),
                           $(DNS2).val()
                        ],
                        bondedTo:null,
                        aliasDisabled:aliasDisabled,
                        configureRabbitMqSslListener:configureRabbitMQSSLListener,
                        configurePostgresSslListener:configurePostgresSSLListener,
                        webServerCertificate:webServerCertificate,
                        webServerCertificateChain:webServerCertificateChain,
                        webServerCertificateKey:webServerCertificateKey

                   };

                editedPrimaryNetworkObj = networkObject;
                networkDataList.push(networkObject);
                return networkDataList;
            }

            /**
             * When primary nic is expanded, populate primary config object with
             * the form field values of primary nic
             */
            function setPrimaryConfigFromForm(expandedRowIndex) {

                primaryConfig.hostname = $(HOSTNAME+"-"+expandedRowIndex).val();
                primaryConfig.app1Ipv4Addr = $('#cic-network-ip-ipv4-'+expandedRowIndex).val();
                primaryConfig.ipv4Subnet = $('#cic-network-mask-ipv4-'+expandedRowIndex).val();
                primaryConfig.ipv4Gateway = $('#cic-network-gateway-ipv4-'+expandedRowIndex).val();
                primaryConfig.unconfigure = false;
                primaryConfig.confOneNode=true;
                primaryConfig.interfaceName=APPLIANCE;

                var eth0Dns1Id = "#cic-network-preferred-dns-"+expandedRowIndex;
                var eth0Dns2Id = "#cic-network-alternate-dns-"+expandedRowIndex;

                if(aliasSupported || aliasSupportedOld != null){
                    primaryConfig.ipv4Type = presenter.STATIC;
                    primaryConfig.overrideIpv4DhcpDnsServers = false;
                }
                else {
                    primaryConfig.ipv4Type=$('input[type="radio"][name=addressAssignment-'+expandedRowIndex+']:checked').val();
                    primaryConfig.overrideIpv4DhcpDnsServers = getDnsFromDHCPFlag(primaryConfig.ipv4Type, $(eth0Dns1Id).val(), $(eth0Dns2Id).val(), primaryConfig);
                }
                if(networkInterfaceTableView.getIpv6Disabled()){
                    primaryConfig.ipv6Type = presenter.UNCONFIGURE;
                } else {
                    primaryConfig.ipv6Type = $('input[type="radio"][name=addressAssignmentforv6-'+expandedRowIndex+']:checked').val();
                }
                if (primaryConfig.ipv6Type == presenter.STATIC){
                    primaryConfig.app1Ipv6Addr = $('#cic-network-ip-ipv6-'+expandedRowIndex).val();
                    primaryConfig.ipv6Subnet = $('#cic-network-mask-ipv6-'+expandedRowIndex).val();
                    primaryConfig.ipv6Gateway = $('#cic-network-gateway-ipv6-'+expandedRowIndex).val();
                }
                primaryConfig.domainName=presenter.getDomainName(primaryConfig.hostname, $(eth0Dns1Id).val(), $(eth0Dns2Id).val());
                primaryConfig.ipv4NameServers[0] = $(eth0Dns1Id).val();
                primaryConfig.ipv4NameServers[1] = $(eth0Dns2Id).val();

                networkInterfaceTableView.setPrimaryNetworkObj(primaryConfig);

            }

            /**
             * @private Read the form data into an object understood by the presenter.
             * @return {Object} the network data
             */
            function createNetworkObject(macAddress, i){

                var	 ipv4addr = null,
                     ipv4Subnet = null,
                     ipv4Gateway = null,
                     ipv6Addr = null,
                     ipv6Subnet = null,
                     ipv6Gateway = null,
                     unconfigure = false,
                     ipv4Type = null,
                     ipv6Type = null,
                     dns1Id = null,
                     dns2Id = null,
                     ipv4Alias = null,
                     hostName = null,
                     usage = null,
                     configureRabbitMQSSLListener = false,
                     configurePostgresSSLListener = false,
                     webServerCertificate = null,  // this will be web server certificate text
                     webServerCertificateChain = null, // this is web server certificate chain text if any exists/required
                     webServerCertificateKey = null; // this is web server certificate key, used for certificate/chain validation.
                if(singleNicEnabled) {
                    //var addressAssignmentIPV4Visible = $(ADDRESS_IPV4_ASSIGNMENT).is(':visible');
                    var addressAssignmentforIPV6Visible = $(ADDRESS_IPV6_ASSIGNMENT).is(':visible');
                    if (aliasSupported == 'true' || aliasSupportedOld != null ){
                        ipv4Type = presenter.STATIC;
                    }else{
                        ipv4Type = $('input[type="radio"][name=addressAssignment]:checked').val();
                    }
                    if(addressAssignmentforIPV6Visible){
                     ipv6Type = $('input[type="radio"][name=addressAssignmentforv6]:checked').val();
                    }else {
                        ipv6Type = presenter.UNCONFIGURE;
                    }
                     dns1Id = "#cic-network-preferred-dns";
                     dns2Id = "#cic-network-alternate-dns";

                    if (ipv4Type == presenter.STATIC){
                        ipv4addr = $('#cic-network-ip-ipv4').val();
                        ipv4Subnet = $('#cic-network-mask-ipv4').val();
                        ipv4Gateway = $('#cic-network-gateway-ipv4').val();
                    }
                    if (ipv4Type == presenter.UNCONFIGURE){
                        unconfigure = true;
                    }

                    if (ipv6Type == presenter.STATIC){
                            ipv6Addr = $('#cic-network-ip-ipv6').val();
                            ipv6Subnet = $('#cic-network-mask-ipv6').val();
                            ipv6Gateway = $('#cic-network-gateway-ipv6').val();
                    }

                    hostName = $(HOSTNAME).val();
                    usage = $(usageId).val();
                    
                    configureRabbitMQSSLListener = $(RABBITMQ_LISTNER).is(":checked");
                    configurePostgresSSLListener = $(POSTGRESQL_LISTNER).is(":checked");
                    
                    //check if certificate is collpsed or not
                    if (!$(WEBSERVER_SERVCERT_SECTION).hasClass( "hp-collapsed")){
                        webServerCertificate = $(WEBSERVER_SERVER_CERT_TEXT).val();
                    }
                    if (!$(WEBSERVER_CACERT_SECTION).hasClass( "hp-collapsed")){
                        webServerCertificateChain = $(WEBSERVER_CERTCHAIN_TEXT).val();
                    }
                    if (!$(WEBSERVER_PRIVATEKEY_SECTION).hasClass( "hp-collapsed")){
                        webServerCertificateKey = $(WEBSERVER_PRIVATEKEY_TEXT).val();
                    }
                    
                }
                else {
                    //check if certificate is collpsed or not
                    if (!$(WEBSERVER_SERVCERT_SECTION+"-"+i).hasClass( "hp-collapsed")){
                        webServerCertificate = $(WEBSERVER_SERVER_CERT_TEXT+"-"+i).val();
                    }
                    if (!$(WEBSERVER_CACERT_SECTION+"-"+i).hasClass( "hp-collapsed")){
                        webServerCertificateChain = $(WEBSERVER_CERTCHAIN_TEXT+"-"+i).val();
                    }
                    if (!$(WEBSERVER_PRIVATEKEY_SECTION+"-"+i).hasClass( "hp-collapsed")){
                        webServerCertificateKey = $(WEBSERVER_PRIVATEKEY_TEXT+"-"+i).val();
                    }
                    
                    configureRabbitMQSSLListener = $(RABBITMQ_LISTNER+'-'+i).is(":checked");
                    configurePostgresSSLListener = $(POSTGRESQL_LISTNER+'-'+i).is(":checked");
                    
                     ipv4Type = $('input[type="radio"][name=addressAssignment-'+i+']:checked').val();
                     if(networkInterfaceTableView.getIpv6Disabled()){
                         ipv6Type = presenter.UNCONFIGURE;
                     } else {
                         ipv6Type = $('input[type="radio"][name=addressAssignmentforv6-'+i+']:checked').val();
                     }
                     dns1Id = "#cic-network-preferred-dns-"+i;
                     dns2Id = "#cic-network-alternate-dns-"+i;

                    if (ipv4Type == presenter.STATIC){
                        ipv4addr = $('#cic-network-ip-ipv4-'+i).val();
                        ipv4Subnet = $('#cic-network-mask-ipv4-'+i).val();
                        ipv4Gateway = $('#cic-network-gateway-ipv4-'+i).val();
                    }
                    if (ipv4Type == presenter.UNCONFIGURE){
                        unconfigure = true;
                    }

                    if (ipv6Type == presenter.STATIC){
                            ipv6Addr = $('#cic-network-ip-ipv6-'+i).val();
                            ipv6Subnet = $('#cic-network-mask-ipv6-'+i).val();
                            ipv6Gateway = $('#cic-network-gateway-ipv6-'+i).val();
                    }

                    hostName = $(HOSTNAME+"-"+i).val();


                    if ($(usageId+"-"+i+"-input").val() != null)
                       {
                           usage = $(usageId+"-"+i+"-input").val();
                        } else {
                            usage = $(usageId+"-"+i).val();
                       }

                    var rows = $('#cic-appliance-nics-table').dataTable().fnGetNodes();
                    for(var m=0;m<rows.length;m++) {
                        var row = rows[m];

                        var aRowData = $('#cic-appliance-nics-table').dataTable().fnGetData( row );
                        var device = aRowData.device;
                        var slno = aRowData.slno;

                        if(device === 'eth0'){
                            var isEth0RowExpanded = $('#cic-appliance-nics-table').dataTable().fnIsOpen(row);
                            if(isEth0RowExpanded){
                                var expandedRowIndex = networkInterfaceTableView.getTableRowIndex(slno);

                                setPrimaryConfigFromForm(expandedRowIndex);
                            }
                        }
                    }

                    if((aliasSupported || aliasSupportedOld != null) && primaryConfig != null){
                        aliasVisible = $('#cic-alias-fieldset-'+i).is(':visible');
                        if(aliasVisible){

                            if($('#cic-network-ipv4-alias-'+i).is(':checked')){

                                ipv4Type = presenter.STATIC;
                                ipv4addr = primaryConfig.app1Ipv4Addr;
                                ipv4Alias = $('#cic-network-ip-ipv4-'+i).val();
                                ipv4Subnet = primaryConfig.ipv4Subnet;
                                ipv4Gateway = primaryConfig.ipv4Gateway;
                                hostName = primaryConfig.hostname;
                                usage = localizer.getString("fs.settings.network.fields.deployment");
                                macAddress = primaryConfig.macAddress;
                                ipv6Type = presenter.UNCONFIGURE;
                                ipv6Addr = null;
                                ipv6Subnet = null;
                                ipv6Gateway = null;
                                aliasDisabled = false;
                            }

                            if($('#cic-network-ipv4-independent-'+i).is(':checked')){
                                ipv4Type = presenter.STATIC;
                                ipv4addr = $('#cic-network-ip-ipv4-'+i).val();
                                ipv4Subnet = $('#cic-network-mask-ipv4-'+i).val();
                                ipv4Gateway = $('#cic-network-gateway-ipv4-'+i).val();
                                //As hostname field is not provided for independent nic, filling with
                                //primary nic hostname
                                hostName = aliasSupportedOld+1;
                                usage = localizer.getString("fs.settings.network.fields.deployment");
                                macAddress = macAddress;
                                ipv6Type = presenter.UNCONFIGURE;
                                ipv6Addr = null;
                                ipv6Subnet = null;
                                ipv6Gateway = null;
                                aliasDisabled = true;

                                presenter.getSetting(NIC_ALIAS_ASSOCIATION_SETTING_NAME, {
                                    success: function(setting) {
                                        if(setting == null){
                                            var settingObj =
                                            {
                                                    "name":NIC_ALIAS_ASSOCIATION_SETTING_NAME,
                                                    "value":macAddress,
                                                    "type":"Setting"
                                            }

                                            presenter.setSetting(settingObj, {
                                                success : function(data) {
                                                    //don't do anything
                                                },
                                                error : function(errorInfo) {
                                                }

                                            });

                                        }
                                        else {
                                            aliasNICMacAddress = setting.value;
                                        }

                                    }
                                });
                            }
                        }
                        else{
                            aliasDisabled = true;
                        }
                    }
                    else{
                        aliasVisible = false;
                    }
                }

                // overrideDhcpDnsServersFlag is only set for eth0 (in multi nic scenario)
                var overrideDhcpDnsServersFlag = false;
                if(usage == localizer.getString("fs.settings.network.fields.appliance")){
                    overrideDhcpDnsServersFlag = getDnsFromDHCPFlag(ipv4Type, $(dns1Id).val(), $(dns2Id).val(), primaryConfig);
                }


                   var networkObject = {

                        activeNode : 1,
                        unconfigure : unconfigure,
                        app1Ipv4Addr: ipv4addr,
                        app1Ipv6Addr: ipv6Addr,
                        app2Ipv4Addr:null,
                        app2Ipv6Addr:null,
                        virtIpv4Addr:null,
                        virtIpv6Addr:null,
                        app1Ipv4Alias:ipv4Alias,
                        app1Ipv6Alias:null,
                        app2Ipv4Alias:null,
                        app2Ipv6Alias:null,
                        hostname:hostName,
                        confOneNode:true,
                        interfaceName:usage,
                        macAddress: macAddress,
                        ipv4Type:ipv4Type,
                        ipv6Type:ipv6Type,
                        // pulsar changes
                        overrideIpv4DhcpDnsServers:overrideDhcpDnsServersFlag,
                        ipv4Subnet:ipv4Subnet,
                        ipv4Gateway:ipv4Gateway,
                        ipv6Subnet:ipv6Subnet,
                        ipv6Gateway:ipv6Gateway,
                        domainName:presenter.getDomainName(hostName, $(dns1Id).val(), $(dns2Id).val()),
                        searchDomains:[
                        ],
                        ipv4NameServers:[
                           $(dns1Id).val(),
                           $(dns2Id).val()
                        ],
                        ipv6NameServers:[
                           $(dns1Id).val(),
                           $(dns2Id).val()
                        ],
                        bondedTo:null,
                        aliasDisabled:aliasDisabled,
                        configureRabbitMqSslListener :configureRabbitMQSSLListener,
                        configurePostgresSslListener:configurePostgresSSLListener,
                        webServerCertificate:webServerCertificate,
                        webServerCertificateChain:webServerCertificateChain,
                        webServerCertificateKey:webServerCertificateKey
                   };

                return networkObject;
            }

            function marshalMultiNicFormData() {
                // Fill in the basic fields.

                var networkDataList= [];

                var rows = $('#cic-appliance-nics-table').dataTable().fnGetNodes();

                for(var i=0;i<rows.length;i++) {
                  var row = rows[i];
                  var isRowExpanded = $('#cic-appliance-nics-table').dataTable().fnIsOpen(row);

                  if(isRowExpanded){
                      var aRowData = $('#cic-appliance-nics-table').dataTable().fnGetData( row );
                      var slno = aRowData.slno;
                      var expandedRowIndex = networkInterfaceTableView.getTableRowIndex(slno);

                      var macAddress = null;
                      var eth1MacAddress = aRowData.aliasSupport;

                      if (eth1MacAddress != null && eth1MacAddress.indexOf("aliasMacAddr-")>=0){
                          //eth1 configured for alias
                          macAddress = eth1MacAddress.substr(eth1MacAddress.indexOf("-")+1);
                      } else {
                          macAddress = ($(row).find(".mac-address").html());
                      }

                      if (macAddress == ''){
                          macAddress = unconfiguredDeployementMac;
                      }
                      var networkObject =  createNetworkObject(macAddress, expandedRowIndex);


                      if($(row).find(".interfaceType").html() === 'Primary')
                      {
                          editedPrimaryNetworkObj = networkObject;
                      }

                      // if network object has alias info in it and if networkDataList already has eth0 object,
                      // remove eth0 object from networkDataList and add this network object that has alias
                      // info too
                      if(networkObject.app1Ipv4Alias != null){

                          var tempNetworkObjList = [];
                          var primaryNicObj = null;
                          for(var j=0;j<networkDataList.length;j++) {
                              var nicObj = networkDataList[j];
                              if(nicObj.app1Ipv4Addr === networkObject.app1Ipv4Addr){
                                  primaryNicObj = nicObj;
                              }
                              else {
                                  tempNetworkObjList.push(nicObj);
                              }
                          }
                          if(primaryNicObj != null){
                              networkDataList = [];
                              $.merge( networkDataList, tempNetworkObjList );

                              primaryNicObj.app1Ipv4Alias = networkObject.app1Ipv4Alias;
                              primaryNicObj.aliasDisabled = networkObject.aliasDisabled;

                              networkDataList.push(primaryNicObj);
                          }
                          else{
                              if(primaryConfig != null){
                                  networkObject.ipv4NameServers[0]=primaryConfig.ipv4NameServers[0];
                                  networkObject.ipv4NameServers[1]=primaryConfig.ipv4NameServers[1];
                              }
                              networkDataList.push(networkObject);
                          }


                      }
                      else {
                          networkDataList.push(networkObject);
                      }
                      if(aRowData.device != 'eth0')
                      {
                          networkObject.ipv4NameServers=[];
                          networkObject.ipv6NameServers=[];
                      }


                  }
                }
                  return networkDataList;
             }


            function createTimeDTO(){


                var timeDto = {
                     dateTime : null,
                     timezone : "UTC" ,
                     ntpServers : [],
                     pollingInterval : null
                 };


                if(($(TIME_AND_PLACE_RADIO_GRP).attr('id') ==
                    $(TIME_SYNC_MANUAL).attr('id')) &&
                    $(CURRENT_DATE_TIME_TEXT).val()){
                    var dateTime = presenter.parseDateTime($(CURRENT_DATE_TIME_TEXT).val().replace(" ","T")).toISOString().slice(0,-5);
                    if(dateTimeChanged){
                        // if manual set Date Time value is changed
                        timeDto.dateTime = dateTime;
                    }
                    timeDto.ntpServers = null;
                }else{
                    if($(NTP_SERVER_TEXT+'1').val()){
                        for(var index = 1;index <= MAX_NTP_SERVERS_CONFIGURABLE;index = index+1){
                            timeDto.ntpServers.push($(NTP_SERVER_TEXT+index).val());
                        }
                    }
                }
               return timeDto;

            }

             function createLocaleDTO(){

                 //Set the defeatul locale as English. In case of Altair there will be no UI for selecting locale
                 locale_str = "en_US.UTF-8";
                 if($(LOCALE).text() != ""){
                     //set locale , time zone then Date Time OR NTP on success of TIMEZONE
                     locale_val = $(LOCALE).val();
                     var locale = localeList[locale_val];
                     // To handle if user is enter the locale which is not presnt in the list.
                     if(typeof locale !== 'undefined'){
                         locale_str = locale.localeName ;
                       }else{
                         locale_str = locale_val;
                       }

                   }
                 var localeDto = {
                         locale : locale_str,
                         displayName : null
                     };
                 return localeDto;
             }
             //newly added DTO for Version 100 serverCertificate
             function createServerCertificateDTO(){
             
             var rabbitMQCertificate = null,
                 rabbitMQRootCACertificate = null,
                 rabbitMQCertificateKey = null,
                 postgresCertificate = null,
                 postgresRootCACertificate = null,
                 postgresCertificateKey = null;
             
             // check if certificate is collpsed or not
             if(!$(RABBITMQ_SECTION).hasClass("hp-collapsed")){
                if (!$(RABBITMQ_CACERT_SECTION).hasClass( "hp-collapsed")){
                    rabbitMQRootCACertificate = $(RABBITMQ_ROOTCA_CERT_TEXT).val();
                }
                if (!$(RABBITMQ_SERVERCERT_SECTION).hasClass( "hp-collapsed")){
                    rabbitMQCertificate = $(RABBITMQ_SERVER_CERT_TEXT).val();
                }
                if (!$(RABBITMQ_PRIVATEKEY_SECTION).hasClass( "hp-collapsed")){
                    rabbitMQCertificateKey = $(RABBITMQ_PRIVATEKEY_TEXT).val();
                }
             }
             if(!$(POSTGRESQL_SECTION).hasClass("hp-collapsed")){    
                if (!$(POSTGRESQL_SERVERCERT_SECTION).hasClass( "hp-collapsed")){
                    postgresCertificate = $(POSTGRESQL_SERVER_CERT_TEXT).val();
                }
                if (!$(POSTGRESQL_CACERT_SECTION).hasClass( "hp-collapsed")){
                    postgresRootCACertificate = $(POSTGRESQL_ROOTCA_CERT_TEXT).val();
                }
                if (!$(POSTGRESQL_PRIVATEKEY_SECTION).hasClass( "hp-collapsed")){
                    postgresCertificateKey = $(POSTGRESQL_PRIVATEKEY_TEXT).val();
                }
             }
             
             var serverCertificateDto = {
             
                     rabbitMQCertificate : rabbitMQCertificate, //Rabbit MQ Server certificate text
                     rabbitMQRootCACertificate : rabbitMQRootCACertificate, //Root CA certificate for Rabbit MQ Server
                     rabbitMQCertificateKey : rabbitMQCertificateKey, //Rabbit MQ Server certificate Key
                     postgresCertificate : postgresCertificate, //Postgre SQL Server certificate text
                     postgresRootCACertificate : postgresRootCACertificate, //Root CA certificate for Postgre SQL Server
                     postgresCertificateKey : postgresCertificateKey //Postgre SQL Server certificate key
             };
             
             return serverCertificateDto;
            }
             
             function createAliasAssocNICObj(aliasAssocNICObj){
             
                      var networkObject = {

                             activeNode : 1,
                             unconfigure : true,
                             app1Ipv4Addr : aliasAssocNICObj.app1Ipv4Addr,
                             app1Ipv6Addr: aliasAssocNICObj.app1Ipv6Addr,
                             app2Ipv4Addr:null,
                             app2Ipv6Addr:null,
                             virtIpv4Addr:null,
                             virtIpv6Addr:null,
                             app1Ipv4Alias: aliasAssocNICObj.app1Ipv4Alias,
                             app1Ipv6Alias:null,
                             app2Ipv4Alias:null,
                             app2Ipv6Alias:null,
                             hostname: aliasAssocNICObj.hostname,
                             confOneNode:true,
                             interfaceName : aliasAssocNICObj.interfaceName,
                             macAddress: aliasAssocNICObj.macAddress,
                             ipv4Type: aliasAssocNICObj.ipv4Type,
                             ipv6Type: aliasAssocNICObj.ipv6Type,
                             // pulsar changes
                             overrideIpv4DhcpDnsServers : aliasAssocNICObj.overrideIpv6DhcpDnsServers,
                             ipv4Subnet: aliasAssocNICObj.ipv4Subnet,
                             ipv6Subnet: aliasAssocNICObj.ipv6Subnet,
                             ipv6Gateway: aliasAssocNICObj.ipv6Gateway,
                             domainName : aliasAssocNICObj.domainName,
                             searchDomains:[
                                           ],
                             ipv4NameServers: [ aliasAssocNICObj.ipv4NameServers[0],
                                                aliasAssocNICObj.ipv4NameServers[1]
                                                                 ],
                             ipv6NameServers: [ aliasAssocNICObj.ipv6NameServers[0],
                                                aliasAssocNICObj.ipv6NameServers[1]
                                              ],
                             bondedTo:null,
                             aliasDisabled:aliasAssocNICObj.aliasDisabled
                             
                        };
                     return networkObject;
             }



            /**
             * @private Revise the validation rules on the hostname field.
             * @param {Object} networkData The current network data.
             */
             function updateHostname(networkData, cnt) {
                 var hostNameId = HOSTNAME;
                 if(!singleNicEnabled) {
                     if(cnt >= 0) {
                         hostNameId = hostNameId + "-" + cnt;
                     }
                 }
                 if(hostNameId.length > 0){
                     $(hostNameId).rules(REMOVE);

                 if(presenter.fqdnRequired(networkData)) {
                     var message = localizer.getString('fs.settings.network.validator.hostname.fqdn_required');

                     $(hostNameId).rules(ADD, {
                       readCert : [],
                         hostAddress : FQDN,
                         required : true,
                         messages : {
                             hostAddress : message,
                             required : message
                         }
                     });
                 } else {
                     $(hostNameId).rules(ADD, {
                       readCert : [],
                         hostAddress : ['hostname', FQDN],
                         required : true,
                         messages : {
                           hostAddress : localizer.getString('fs.settings.network.validator.hostname.fqdn_optional')

                         }
                     });
                 }
              }
             }


            /**
             * Rule for HOSTNAME field
             */
            $.validator.addMethod("readCert", function(
                value, element, param) {

              // field is not required
                if (!value) {
                    return true;
                }
                presenter.getCertificate({

                  success: function(certObject) {
                        var cn = certObject.commonName;
                        var issuer = certObject.issuer;
                        var message;
                        /*
                         * check if certificate is self signed or CA signed and display warning message based on that
                         */
                        if (cn === HOSTNAME_ORIGINAL)
                        {
                            if (issuer === cn)
                            {
                                //self signed
                                message=localizer.getString('fs.settings.certificate.hostname_regen_cert_warn');
                            }
                            else
                            {
                                // ca signed
                              message=localizer.getString('fs.settings.certificate.hostname_regen_cert_warn_csr');
                            }
                         }
                         else
                         {
                           /*
                            * if hostname doesn't match the cn, display warning message appropriately
                            */
                             if (issuer === cn)
                             {
                                 //self signed
                               message=localizer.getString('fs.settings.certificate.hostname_cn_mistmatch');
                             }
                             else
                             {
                                 // ca signed
                               message=localizer.getString('fs.settings.certificate.hostname_cn_mistmatch_csr');
                             }
                         }
                        $(HOSTNAME_LABEL).text(message);
                    },

                    error: function onGetCertError(errorInfo) {
                      //show common warning
                        $(HOSTNAME_LABEL).text(localizer.getString('fs.settings.certificate.hostname_regen_cert_warn'));

                    }

                });
                return true;

            }, '');

            /**
             * Rule for IPV4 field
             */
            $.validator.addMethod("readCertIP", function(
                value, element, param) {
                // field is not required
                if (!value) {
                    return true;
                }

                return true;

            }, '');

            // Time and Place validator
            //Remove this once UIcore updates FQDN validator regex
            $.validator.addMethod(
                    'hpTimeandlanguageNtpAddress',
                    presenter.validateNTPField,//Remove this too
                    localizer.getString('fs.settings.network.validator.ntpserver.ntp_fqdn_required')
                 );

            /**
             * @private Show or hide the DHCP warning based on whether DHCP is selected.
             * @param {Object} networkData The current network data.
             */
            function updateDHCPWarning(networkData, cnt) {

                var dhcpIPv4Warning = DHCP_IPV4_WARNING;
                var ipv6Switch = IPV6_SWITCH;
                var dhcpIPv6Warning = DHCP_IPV6_WARNING;

                if(!singleNicEnabled) {
                    if(cnt >= 0) {
                        dhcpIPv4Warning = dhcpIPv4Warning + "-" + cnt;
                        ipv6Switch = ipv6Switch + "-" + cnt;
                        dhcpIPv6Warning = dhcpIPv6Warning + "-" + cnt;
                    }
                }

                if(presenter.dhcpIPv4Used(networkData)) {
                    $(dhcpIPv4Warning).show();
                } else {
                    $(dhcpIPv4Warning).hide();
                }

                if(presenter.dhcpIPv6Used(networkData)) {
                    $(dhcpIPv6Warning).show();
                } else {
                    $(dhcpIPv6Warning).hide();
                }

                if(networkData.ipv6Type != "UNCONFIGURE"){
                	$(DUAL_STACK_WARNING).show();
                }
            }


            /**
             * @private Show or hide the Gateway warning based on whether updated network of appliance
             *  is different from previous one.
             * @param {Object} networkData The current network data.
             */
            function updateGatewayWarning(networkData, cnt){

                var gatewayIPv4Warning = GATEWAY_IPV4_WARNING;
                var ipv6Switch = IPV6_SWITCH;
                var gatewayIPv6Warning = GATEWAY_IPV6_WARNING;
                if(!singleNicEnabled) {
                    if(cnt >= 0) {
                        gatewayIPv4Warning = gatewayIPv4Warning + "-" + cnt;
                        ipv6Switch = ipv6Switch + "-" + cnt;
                        gatewayIPv6Warning = gatewayIPv6Warning + "-" + cnt;
                    }
                }



                if($(ipv6Switch).is(':checked') === true) {
                    if(!presenter.dhcpIPv6Used(networkData)) {
                        $(gatewayIPv6Warning).css('visibility','visible');
                    } else {
                        $(gatewayIPv6Warning).css('visibility', 'hidden');
                    }
                } else {
                        $(gatewayIPv6Warning).css('visibility', 'hidden');
                }
            }

            /**
             * @private Save IPv4 fields values when a user switches to DHCP .
             */
            function saveIPV4fields() {

                if(isTwoNode) {
                    $(NODE1_IPV4 + HIDDEN).val($(NODE1_IPV4).val());
                    $(NODE2_IPV4 + HIDDEN).val($(NODE2_IPV4).val());

                } else {
                    $(IPV4IPADDR + HIDDEN).val($(IPV4IPADDR).val());
                }

                $(IPV4MASK + HIDDEN).val($(IPV4MASK).val());
                $(IPV4GATEWAY + HIDDEN).val($(IPV4GATEWAY).val());
                $(DNS1 + HIDDEN).val($(DNS1).val());
                $(DNS2 + HIDDEN).val($(DNS2).val());

            }

            /**
             * @private Restore previously saved  IPv4 fields values when a user switches back
             * from DHCP to Manual .
             */
            function restoreIPV4fields() {

                if(isTwoNode) {
                    $(NODE1_IPV4).val($(NODE1_IPV4 + HIDDEN).val());
                    $(NODE2_IPV4).val($(NODE2_IPV4 + HIDDEN).val());

                } else {
                    $(IPV4IPADDR).val($(IPV4IPADDR + HIDDEN).val());
                }

                $(IPV4MASK).val($(IPV4MASK + HIDDEN).val());
                $(IPV4GATEWAY).val($(IPV4GATEWAY + HIDDEN).val());
                $(DNS1).val($(DNS1 + HIDDEN).val());
                $(DNS2).val($(DNS2 + HIDDEN).val());


            }

            /**
             * @private Save IPv6 fields values when a user switches to DHCP .
             */
            function saveIPV6fields() {

                if(isTwoNode) {
                    $(NODE1_IPV6 + HIDDEN).val($(NODE1_IPV6).val());
                    $(NODE2_IPV6 + HIDDEN).val($(NODE2_IPV6).val());

                } else {
                    $(IPV6IPADDR + HIDDEN).val($(IPV6IPADDR).val());
                }

                $(IPV6MASK + HIDDEN).val($(IPV6MASK).val());
                $(IPV6GATEWAY + HIDDEN).val($(IPV6GATEWAY).val());

            }

            /**
             * @private Restore previously saved IPv6 fields values when a user switches back
             * from DHCP to Manual .
             */
            function restoreIPV6fields() {

                if(isTwoNode) {
                    $(NODE1_IPV6).val($(NODE1_IPV6 + HIDDEN).val());
                    $(NODE2_IPV6).val($(NODE2_IPV6 + HIDDEN).val());

                } else {
                    $(IPV6IPADDR).val($(IPV6IPADDR + HIDDEN).val());
                }

                $(IPV6MASK).val($(IPV6MASK + HIDDEN).val());
                $(IPV6GATEWAY).val($(IPV6GATEWAY + HIDDEN).val());

            }

            /**
             * @private Revise the validation rules and enabled state of the IPv4 address fields.
             * @param {Object} networkData The current network data.
             */
            function updateIPv4Fields(networkData, cnt) {

                var ipv4Mask = IPV4MASK;
                var ipv4FloatAddr = IPV4FLOATADDR;
                var node1IPv4 = NODE1_IPV4;
                var node2IPv4 = NODE2_IPV4;
                var ipv4Addr = IPV4IPADDR;

                if(!singleNicEnabled) {
                    if(cnt >= 0) {
                        ipv4Mask = ipv4Mask + "-" + cnt;
                        ipv4FloatAddr = ipv4FloatAddr + "-" + cnt;
                        node1IPv4 = node1IPv4 + "-" + cnt;
                        node2IPv4 = node2IPv4 + "-" + cnt;
                        ipv4Addr = ipv4Addr + "-" + cnt;
                    }
                }

                if(presenter.ipv4DataRequired(networkData)) {// static

                    $(CLASS_IPV4_CLUSTER_ADDR_DHCP+ "-" + cnt).css('visibility','hidden');
                    $(CLASS_IPV4_DHCP_FIELDS+ "-" + cnt).css('visibility','hidden');
                    $(CLASS_IPV4_NON_DHCP_ERRORS+ "-" + cnt).css('visibility','visible');
                    if($(ipv4Mask).length > 0){
                        $(ipv4Mask).rules(ADD, REQUIRED);
                    }
                    if(isTwoNode) {
                        $(ipv4FloatAddr).rules(ADD, REQUIRED);
                        $(node1IPv4).rules(ADD, REQUIRED);
                        $(node2IPv4).rules(ADD, REQUIRED);
                    } else {
                        if($(ipv4Addr).length > 0){
                        $(ipv4Addr).rules(ADD, REQUIRED);
                        $(ipv4Addr).rules(ADD, {
                          readCertIP : []
                        });
                       }
                    }
                    $(IPV4FIELDS+ "-" + cnt).removeAttr(DISABLED);

                } else {//DHCP
                    if($(ipv4Mask).length > 0){
                    $(ipv4Mask).rules(REMOVE, REQUIRED);
                    }
                    $(IPV4FIELDS+ "-" + cnt).attr(DISABLED, DISABLED);
                    // if we switched from manual to DHCP , blank out the fields
                    if (manualToDhcp) {
                      $(IPV4FIELDS+ "-" + cnt).val('');
                    }
                    $(CLASS_IPV4_DHCP_FIELDS+ "-" + cnt).css('visibility','visible');
                    $(CLASS_IPV4_CLUSTER_ADDR_DHCP+ "-" + cnt).css('visibility','visible');
                    $(CLASS_IPV4_NON_DHCP_ERRORS+ "-" + cnt).css('visibility','hidden');

                    if(isTwoNode) {// DHCP, two-node
                        $(ipv4Addr).rules(ADD, REQUIRED);
                        $(ipv4FloatAddr).rules(ADD, REQUIRED);
                        $(ipv4Addr).removeAttr(DISABLED);
                        $(node1IPv4).rules(REMOVE, REQUIRED);
                        $(node2IPv4).rules(REMOVE, REQUIRED);
                        $(ipv4Mask).rules(REMOVE, REQUIRED);
                        $(CLASS_IPV4_DHCP_FIELDS+ "-" + cnt).show();
                    } else {// DHCP, one-node
                       if($(ipv4Addr).length > 0){
                           $(ipv4Addr).rules(REMOVE, REQUIRED);
                       }
                    }
                }
            }

            /**
             * @private Revise the validation rules, visibility, and enabled state of the IPv6 address fields.
             * @param {Object} networkData The current network data.
             */
            function updateIPv6Fields(networkData, cnt) {

                var ipv6AddrSelect = IPV6ADDRSELECT;
                var ipv6IPAddr = IPV6IPADDR;
                var ipv6Mask = IPV6MASK;
                var twoNodeIPv6Label = TWO_NODE_IPV6_LABEL;
                var node1IPv6 = NODE1_IPV6;
                var node2IPv6 = NODE2_IPV6;

                if(!singleNicEnabled) {
                    if(cnt >= 0) {
                        ipv6AddrSelect = ipv6AddrSelect + "-" + cnt;
                        ipv6IPAddr =ipv6IPAddr + "-" + cnt;
                        ipv6Mask = ipv6Mask + "-" + cnt;
                        twoNodeIPv6Label = twoNodeIPv6Label + "-" + cnt;
                        node1IPv6 = node1IPv6 + "-" + cnt;
                        node2IPv6 = node2IPv6 + "-" + cnt;
                    }
                }

                $(ipv6AddrSelect).parent().show();

                if(presenter.ipv6DataRequired(networkData)) {// static
                    $(CLASS_IPV6_DHCP_FIELDS+ "-" + cnt).css('visibility','hidden');
                    $(CLASS_IPV6_NON_DHCP_ERRORS+ "-" + cnt).css('visibility','visible');
                    $(CLASS_IPV6_CLUSTER_ADDR_DHCP+ "-" + cnt).css('visibility','hidden');
                    if(ipv6IPAddr.length > 0){
                    $(ipv6IPAddr).rules(ADD, REQUIRED);
                    }
                    if($(ipv6Mask).length > 0){
                    $(ipv6Mask).rules(ADD, REQUIRED);
                    }
                    $(IPV6_NONDHCP_FIELDS+ "-" + cnt).removeAttr(DISABLED);
                } else {
                    $(CLASS_IPV6_NON_DHCP_ERRORS+ "-" + cnt).css('visibility','hidden');
                    $(CLASS_IPV6_DHCP_FIELDS+ "-" + cnt).css('visibility','visible');
                    if(!firstTimeFlag) {
                        $(CLASS_IPV6_CLUSTER_ADDR_DHCP+ "-" + cnt).css('visibility','visible');
                    }
                    $(IPV6_NONDHCP_FIELDS+ "-" + cnt).attr(DISABLED, DISABLED);
                    if($(ipv6Mask).length > 0){
                       $(ipv6Mask).rules(REMOVE, REQUIRED);
                    }

                    if(isTwoNode) {// DHCP, two-node
                        $(twoNodeIPv6Label).show();
                        $(node1IPv6).rules(REMOVE, REQUIRED);
                        $(node2IPv6).rules(REMOVE, REQUIRED);
                        $(ipv6Mask).rules(REMOVE, REQUIRED);
                    } else {// DHCP, one-node
                         if($(ipv6IPAddr).length > 0){
                             $(ipv6IPAddr).rules(REMOVE, REQUIRED);
                        }
                    }
                }
            }

            /**
             * @private Revise the validation rules and size of the DNS fields.
             * @param {Object} networkData The current network data.
             */
            function updateDNSFields(networkData, cnt) {

                var dns1 = DNS1;
                var dns2 = DNS2;
                if(!singleNicEnabled) {
                    if (cnt >= 0) {
                        dns1 = dns1 + "-" + cnt;
                        dns2 = dns2 + "-" + cnt;
                    }
                }

                var message;
                if(presenter.ipv6Used(networkData)) {
                    message = localizer.getString('fs.settings.network.validator.dns.ipv4_ipv6');
                    if(dns1.length > 0){
                    $(dns1).rules(ADD, {
                        hostAddress : [IPV4, IPV6],
                        messages : {
                            hostAddress : message
                        }
                    })};
                    if(dns2.length > 0){
                    $(dns2).rules(ADD, {
                        hostAddress : [IPV4, IPV6],
                        messages : {
                            hostAddress : message
                        }
                    })};
                } else {
                    message = localizer.getString('fs.settings.network.validator.dns.ipv4_only');
                    if(dns1.length > 0){
                    $(dns1).rules(ADD, {
                        hostAddress : IPV4,
                        messages : {
                            hostAddress : message
                        }
                    })};
                    if(dns2.length > 0){
                    $(dns2).rules(ADD, {
                        hostAddress : IPV4,
                        messages : {
                            hostAddress : message
                        }
                    })};
                }
                if(presenter.ipv6DNS(networkData)) {
                    $(DNSFIELDS).attr(SIZE, IPV6_SIZE);
                } else {
                    $(DNSFIELDS).attr(SIZE, IPV4_SIZE);
                }


            }

            /**
             * @private Revise the validation rules and size of NTP fields.
             * @param {Object} networkData The current network data.
             * @param {Object} cnt The NIC count indicator for view.
             */
            function updateNTPFieldRules(networkData, cnt){
                //We will update this once we find out ways to handle initial load data unavailability for multi NIC
                if(singleNicEnabled){// SingleNIC scenario
                    var dnsSupport = false,
                        ipv6Support = false,
                        errorMessage = "",
                        hostAddressRules = [IPV4];
                    if(presenter.fqdnRequired(networkData)){
                        dnsSupport = true;
                        hostAddressRules.push(HOSTNAME_RULE, FQDN);
                    }
                    if( presenter.ipv6Used(networkData) ){
                        ipv6Support = true;
                        hostAddressRules.push(IPV6);
                    }
                    if(!dnsSupport){
                        if(!ipv6Support){
                            errorMessage = localizer.getString('fs.settings.network.validator.ntpserver.ipv4');
                        }
                        else{
                            errorMessage = localizer.getString('fs.settings.network.validator.ntpserver.ipv4_v6');
                        }
                    }else{
                        if(!ipv6Support){
                            errorMessage = localizer.getString('fs.settings.network.validator.ntpserver.ipv4_dns');
                        }
                        else{
                            errorMessage = localizer.getString('fs.settings.network.validator.ntpserver.ntp_fqdn_required');
                        }
                    }
                }else{
                    hostAddressRules = [IPV4, IPV6, HOSTNAME_RULE, FQDN];
                    errorMessage = localizer.getString('fs.settings.network.validator.ntpserver.ntp_fqdn_required');
                }
                var isSyncWithNTP = true;
                if($(TIME_AND_PLACE_RADIO_GRP).attr('id') ==
                    $(TIME_SYNC_MANUAL).attr('id')){
                	//Add required rule only when Syn with time server is selected
                	isSyncWithNTP = false;
                }
		                $(NTP_SERVER_TEXT+1).rules(ADD, {
		                	required : isSyncWithNTP,
		                    hostAddress : hostAddressRules,
		                    messages : {
		                        hostAddress : errorMessage
		                    }
		                });
		                $(NTP_SERVER_TEXT+2).rules(ADD, {
		                    hostAddress : hostAddressRules,
		                    messages : {
		                        hostAddress : errorMessage
		                    }
		                });
		                $(NTP_SERVER_TEXT+3).rules(ADD, {
		                    hostAddress : hostAddressRules,
		                    messages : {
		                        hostAddress : errorMessage
		                    }
		                });


            }

            /**
             * @private Re-validate the fields that are showing errors; leave the fields without errors alone (so that we don't
             * display errors in them prematurely).
             */
            function resetFailures() {
                $(HAS_ERROR).each(function() {
                    validator.element(this);
                });
            }
             /**
             * @public Reset the dynamic aspects of the form based on the current data in it.
             */
            function updateForm(macAddress, cnt) {

                var networkData = createNetworkObject(macAddress, cnt);
                updateHostname(networkData, cnt);
                updateDHCPWarning(networkData, cnt);
                updateGatewayWarning(networkData, cnt);
                updateIPv4Fields(networkData, cnt);
               if(!presenter.iPv6Disabled() && !(aliasSupported == 'true' || aliasSupportedOld != null)) {
                   updateIPv6Fields(networkData, cnt);
                }
                updateDNSFields(networkData, cnt);
                updateNTPFieldRules(networkData, cnt);
                resetFailures();
            }


            function setInitialHostname (configuration, cnt) {

              var hostname = configuration.hostname;

               // check to see whether we have an intitial  non-FQDN hostname
              // and it is not autogenerated one, i.e. it does not start with "ci-"
              if (firstTimeFlag && (hostname.indexOf('.') == -1) && (hostname.indexOf(AUTOGENERATED_PREFIX) != 0) &&
                  (configuration.domainName || configuration.searchDomainName ))  {
                var suffix =  (configuration.domainName) ?  configuration.domainName : configuration.searchDomainName ;
                hostname = hostname + '.' + suffix;
              }

             var hostnameId = HOSTNAME + "-" + cnt;
             $(hostnameId).val(hostname);
             HOSTNAME_ORIGINAL = hostname;

            }

            /**
             * Displays IPv4 configuration settings
             * @param {object} configuration Configuration returned by first time setup
             */
            function setInitialIpv4Info(configuration, cnt) {

                manualToDhcp = false; // rest the flag on entering the page
                if(config.interfaceName != null){
                    $(usageId + "-" + cnt).val(config.interfaceName);
                }
                else{
                    $(usageId + "-" + cnt).val("Management Network");
                }

                $(deviceId + "-" + cnt).val(config.device);
                $(macId + "-" + cnt).val(config.macAddress);
                $(HOSTNAME + "-" + cnt).val(config.hostname);
                $(IPV4IPADDR + "-" + cnt).val(config.app1Ipv4Addr);
                  $(IPV4MASK + "-" + cnt).val(config.ipv4Subnet);
                  $(IPV4GATEWAY + "-" + cnt).val(config.ipv4Gateway);
                $(DNS1 + "-" + cnt).val(config.ipv4NameServers[0]);
                $(DNS2 + "-" + cnt).val(config.ipv4NameServers[1]);

                if(configuration.ipv4Type == 'STATIC'){
                    $(STATIC_IP_ASSIGN + "-" + cnt).attr('checked',true);
                    $(DHCP_IPV4_WARNING + "-" + cnt).hide();
                  }
                  else{
                      $(DHCP_IP_ASSIGN + "-" + cnt).attr('checked',true);
                      $(IPV4IPADDR + "-" + cnt).attr("disabled", true);
                      $(IPV4MASK + "-" + cnt).attr("disabled", true);
                      $(IPV4GATEWAY + "-" + cnt).attr("disabled", true);
                      $(CLASS_IPV4_DHCP_FIELDS).show();
                      $(CLASS_IPV4_CLUSTER_ADDR_DHCP).show();
                      $(DHCP_IPV4_WARNING + "-" + cnt).show();
                  }

                $(DHCP_IP_ASSIGN + "-" + cnt).change(function(){
                      if($(DHCP_IP_ASSIGN + "-" + cnt).attr('checked')){
                          $(IPV4IPADDR + "-" + cnt).attr("disabled", true);
                          $(IPV4MASK + "-" + cnt).attr("disabled", true);
                          $(IPV4GATEWAY + "-" + cnt).attr("disabled", true);
                          $(CLASS_IPV4_DHCP_FIELDS).show();
                            $(CLASS_IPV4_CLUSTER_ADDR_DHCP).show();
                            $(DHCP_IPV4_WARNING + "-" + cnt).show();
                      }
                  });
                  $(STATIC_IP_ASSIGN + "-" + cnt).change(function(){
                        if($(STATIC_IP_ASSIGN + "-" + cnt).attr('checked')){
                            $(IPV4IPADDR + "-" + cnt).attr("disabled", false);
                            $(IPV4MASK + "-" + cnt).attr("disabled", false);
                            $(IPV4GATEWAY + "-" + cnt).attr("disabled", false);
                            $(IPV4IPADDR + "-" + cnt).val('');
                          $(IPV4MASK + "-" + cnt).val('');
                          $(IPV4GATEWAY + "-" + cnt).val('');
                          $(CLASS_IPV4_DHCP_FIELDS).hide();
                          $(CLASS_IPV4_CLUSTER_ADDR_DHCP).hide();
                          $(DHCP_IPV4_WARNING + "-" + cnt).hide();
                        }
                    });

                 $(dhcpIPV6AssignId + "-" + cnt).change(function(){
                        if($(dhcpIPV6AssignId + "-" + cnt).attr('checked')){
                            $(ipV6Id + "-" + cnt).attr("disabled", true);
                            $(maskV6Id + "-" + cnt).attr("disabled", true);
                            $(gatewayV6Id + "-" + cnt).attr("disabled", true);
                        }
                    });
                    $(STATIC_IPV6_ASSIGN + "-" + cnt).change(function(){
                          if($(STATIC_IPV6_ASSIGN + "-" + cnt).attr('checked')){
                              $(ipV6Id + "-" + cnt).attr("disabled", false);
                              $(maskV6Id + "-" + cnt).attr("disabled", false);
                              $(gatewayV6Id + "-" + cnt).attr("disabled", false);
                          }
                      });
                  $(IPV6FIELDS).show();
                  if (secondIPConfigured) {
                      $(DHCP_IPV6_DISALLOWED + "-" + cnt).show();
                  }
                  if(isTwoNode) {
                      $(ONE_NODE_LAYOUT).hide();
                      $(TWO_NODE_LAYOUT).show();
                  } else {
                      $(TWO_NODE_LAYOUT).hide();
                      $(ONE_NODE_LAYOUT).show();
                  }
                  $(IPV6ADDRSELECT + "-" + cnt).parent().show();

                if(firstTimeFlag ) {
                    if (!secondIPConfigured) {
                        $(IPV4ADDRSELECT + "-" + cnt).selectBox('value', presenter.STATIC);
                    }
                    if(isTwoNode) {
                        $(IPV4FLOATADDR + "-" + cnt).val('');
                    } else {
                        $(IPV4IPADDR + "-" + cnt).val('');
                    }
                } else {
                     if (!secondIPConfigured) {
                        $(IPV4ADDRSELECT + "-" + cnt).selectBox('value', configuration.ipv4Type);
                    }
                }

                if (!manualToDhcp) { // display DHCP values unless we are going from manual -> DHCP
                    if(isTwoNode) {
                        if (firstTimeFlag &&(configuration.ipv4Type != presenter.STATIC))
                        {
                            $(IPV4FLOATADDR + "-" + cnt).val('');
                        } else {
                            $(IPV4FLOATADDR + "-" + cnt).val(configuration.addrs.cluster.ipv4);
                        }
                        $(NODE1_IPV4 + "-" + cnt).val(configuration.addrs.node1.ipv4);
                        $(NODE2_IPV4 + "-" + cnt).val(configuration.addrs.node2.ipv4);
                    } else {
                        if (firstTimeFlag && (configuration.ipv4Type != presenter.STATIC))
                        {
                            $(IPV4IPADDR + "-" + cnt).val('');
                        } else {
                            $(IPV4IPADDR + "-" + cnt).val(configuration.addrs.node1.ipv4);
                            $(IPV4_2_IPADDR + "-" + cnt).val(configuration.addrs.node1.ipv4_2);
                        }
                    }
                    $(IPV4MASK + "-" + cnt).val(configuration.ipv4Subnet);
                    $(IPV4GATEWAY + "-" + cnt).val(configuration.ipv4Gateway);
                    if (configuration.ipv4Type == presenter.DHCP) {
                       $(CLASS_IPV4_DHCP_FIELDS).show();  // the values are from DHCP
                    } else {
                       $(CLASS_IPV4_DHCP_FIELDS).hide();
                       $(CLASS_IPV4_CLUSTER_ADDR_DHCP).hide();
                    }
                } else {
                    $(CLASS_IPV4_DHCP_FIELDS).show();
                    $(CLASS_IPV4_CLUSTER_ADDR_DHCP).show();
                }

            }

            /**
             * Displays IPv6 configuration settings
             * @param {object} configuration Configuration returned by first time setup
             */
            function setInitialIpv6Info(configuration, cnt) {

                if (presenter.iPv6Disabled()) {
                    return;
                }
                $(IPV6IPADDR + "-" + cnt).val(config.app1Ipv6Addr);
                  $(IPV6MASK + "-" + cnt).val(config.ipv6Subnet);
                  $(IPV6GATEWAY + "-" + cnt).val(config.ipv6Gateway);


                if(configuration.ipv6Type == 'STATIC')
                  {
                      $(STATIC_IPV6_ASSIGN + "-" + cnt).attr('checked',true);
                      $(DHCP_IPV6_WARNING + "-" + cnt).hide();
                  }
                  else
                  {
                      $(dhcpIPV6AssignId + "-" + cnt).attr('checked',true);
                      $(IPV6IPADDR + "-" + cnt).attr("disabled", true);
                        $(IPV6MASK + "-" + cnt).attr("disabled", true);
                        $(IPV6GATEWAY + "-" + cnt).attr("disabled", true);
                        $(CLASS_IPV6_DHCP_FIELDS).show();
                      $(CLASS_IPV6_CLUSTER_ADDR_DHCP).show();
                      $(DHCP_IPV6_WARNING + "-" + cnt).show();
                  }

                  $(dhcpIPV6AssignId + "-" + cnt).change(function(){
                        if($(dhcpIPV6AssignId + "-" + cnt).attr('checked')){
                            $(IPV6IPADDR + "-" + cnt).attr("disabled", true);
                            $(IPV6MASK + "-" + cnt).attr("disabled", true);
                            $(IPV6GATEWAY + "-" + cnt).attr("disabled", true);
                            $(CLASS_IPV6_DHCP_FIELDS).show();
                            $(CLASS_IPV6_CLUSTER_ADDR_DHCP).show();
                            $(DHCP_IPV6_WARNING + "-" + cnt).show();
                        }
                    });
                    $(STATIC_IPV6_ASSIGN + "-" + cnt).change(function(){
                          if($(STATIC_IPV6_ASSIGN + "-" + cnt).attr('checked')){
                              $(IPV6IPADDR + "-" + cnt).attr("disabled", false);
                              $(IPV6MASK + "-" + cnt).attr("disabled", false);
                              $(IPV6GATEWAY + "-" + cnt).attr("disabled", false);
                              $(IPV6IPADDR + "-" + cnt).val('');
                                $(IPV6MASK + "-" + cnt).val('');
                                $(IPV6GATEWAY + "-" + cnt).val('');
                                $(CLASS_IPV6_DHCP_FIELDS).hide();
                                $(CLASS_IPV6_CLUSTER_ADDR_DHCP).hide();
                                $(DHCP_IPV6_WARNING + "-" + cnt).hide();
                          }
                      });

                   $(dhcpIPV6AssignId + "-" + cnt).change(function(){
                          if($(dhcpIPV6AssignId + "-" + cnt).attr('checked')){
                              $(ipV6Id + "-" + cnt).attr("disabled", true);
                              $(maskV6Id + "-" + cnt).attr("disabled", true);
                              $(gatewayV6Id + "-" + cnt).attr("disabled", true);
                          }
                      });
                      $(STATIC_IPV6_ASSIGN + "-" + cnt).change(function(){
                            if($(STATIC_IPV6_ASSIGN + "-" + cnt).attr('checked')){
                                $(ipV6Id + "-" + cnt).attr("disabled", false);
                                $(maskV6Id + "-" + cnt).attr("disabled", false);
                                $(gatewayV6Id + "-" + cnt).attr("disabled", false);
                            }
                        });

                if(configuration.ipv6Type == presenter.UNCONFIGURE) {
                    // clear the IPv6 fields in case we re-enter the page from previous cancellation
                    $(IPV6_SWITCH + "-" + cnt).attr('checked', false).trigger('change');
                    $(IPV6ADDRSELECT + "-" + cnt).selectBox('value', presenter.STATIC);
                    $(CLASS_IPV6_INPUT_FIELDS).val('');
                    return;
                }
                $(IPV6_SWITCH + "-" + cnt).attr('checked', true).trigger('change');
                if(firstTimeFlag) {
                    $(IPV6ADDRSELECT + "-" + cnt).selectBox('value', presenter.STATIC);
                    if(isTwoNode) {
                        $(IPV6FLOATADDR + "-" + cnt).val('');
                    } else {
                        $(IPV6IPADDR + "-" + cnt).val('');
                    }
                } else {
                    $(IPV6ADDRSELECT + "-" + cnt).selectBox('value', configuration.ipv6Type);
                }
                if(firstTimeFlag || (configuration.ipv6Type == presenter.STATIC)) {
                    if(isTwoNode) {
                        $(IPV6FLOATADDR + "-" + cnt).val(configuration.addrs.cluster.ipv6);
                        $(NODE1_IPV6 + "-" + cnt).val(configuration.addrs.node1.ipv6);
                        $(NODE2_IPV6 + "-" + cnt).val(configuration.addrs.node2.ipv6);
                    } else {
                        $(IPV6IPADDR + "-" + cnt).val(configuration.addrs.node1.ipv6);
                        if (secondIPConfigured) {
                           $(IPV6_2_IPADDR + "-" + cnt).val(configuration.addrs.node1.ipv6_2);
                        }
                    }
                    $(IPV6MASK + "-" + cnt).val(configuration.ipv6Subnet);
                    $(IPV6GATEWAY + "-" + cnt).val(configuration.ipv6Gateway);
                    if (configuration.ipv6Type == presenter.DHCP) {
                       $(CLASS_IPV6_DHCP_FIELDS).show();  // the values are from DHCP
                    }
                } else {
                    $(CLASS_IPV6_DHCP_FIELDS).show();
                }

            }


            /**
             * Displays name server configuration settings
             * @param {object} configuration Configuration returned by first time setup
             */
            function setInitialNameServerInfo(configuration, cnt) {
                $(DNS1 + "-" + cnt).val(configuration.priDns);
                $(DNS2 + "-" + cnt).val(configuration.altDns);
                if (originalConfig.dnsFromDHCP && !firstTimeFlag) {
                   $(DNS1 + "-" + cnt).val('');
                   $(DNS2 + "-" + cnt).val('');
                   $(DNS_FROM_DHCP).css('visibility','visible');
                }
            }

            /**
             * Set the form for either single node or two node.
             *
             * @param {boolean} isTwoNode Flag whether the appliance is two-node capable.
             * @param {string} message (optional) Warning message why the appliance is not two-node capable.
             */
            function onShowTwoNode(isTwoNodeArg, message) {
                isTwoNode = isTwoNodeArg;
                if(message) {
                    $(NOTIFY_MSG, notifyElement).append(message);
                    notifyElement.addClass(NOTIFICATION_COLOR_PREFIX + 'warning');
                    notifyElement.slideDown('slow');
                }
                if(isTwoNode) {

                    $(ONE_NODE_LAYOUT).hide();
                    $(TWO_NODE_LAYOUT).show();
                } else {
                    $(FLOATING_IPTYPE_LABEL).text(localizer.getString('fs.settings.network.fields.iptype.one-node'));
                    $(TWO_NODE_LAYOUT).hide();
                    $(ONE_NODE_LAYOUT).show();

                    $(IPV4ADDRSELECT + ' [value="DHCP"]').show();
                    $(IPV6ADDRSELECT + ' [value="DHCP"]').show();
                    $(IPV4ADDRSELECT).selectBox('reset');
                    $(IPV6ADDRSELECT).selectBox('reset');
                }
                //              updateForm();
                $(SPINNER).hide();
                $(form).show();
            }

            function setIPV6Display() {
                if(presenter.iPv6Disabled()) {
                    $(CLASS_IPV6_DISABLE).remove();
                }
            }
            
            function removeEth0fromInput(productVarValue){
                var disabledNics = productVarValue;
                if (productVarValue.indexOf('eth0')>=0) {
                     //eth0 we are not supporting for this feature
                     var index = productVarValue.toString().indexOf('eth0');
                     var disabledNics1 = productVarValue.toString().substring(0,index);
                     var disablednics2 = productVarValue.toString().substring(index+4);
                     disabledNics =disabledNics1 + disablednics2;
                 }
                return disabledNics;
            }

            function setNICDisplay(base, pageReadyHandlers) {
                var productVarValue;
                ProductConfig.getproductConfigMembers({
                    success: function(productConfigMembers) {
                        productVarValue = productConfigMembers[MULTI_NIC_DISABLED_KEY];
                        if(productVarValue === 'true' || productVarValue == true)
                        {
                            multiNICDisabled = true;
                        }
                        productVarValue = productConfigMembers[EDIT_GATEWAY_ADDITIONAL_NIC_DISABLED_KEY];
                        if(productVarValue === 'true' || productVarValue == true)
                        {
                            networkInterfaceTableView.setEditGatewayForAdditionalNICsDisabled(true);
                        }
                        productVarValue = productConfigMembers[EDIT_DNS_ADDITIONAL_NIC_DISABLED_KEY];
                        if(productVarValue === 'true' || productVarValue == true)
                        {
                            networkInterfaceTableView.setEditDnsForAdditionalNICsDisabled(true);
                        }
                        productVarValue = productConfigMembers[IPV6_DISABLED_KEY];
                        if(productVarValue === 'true' || productVarValue == true)
                        {
                            networkInterfaceTableView.setIpv6Disabled(true);
                        }
                        productVarValue = productConfigMembers[DHCP_DISABLED_KEY];
                        if(productVarValue === 'true' || productVarValue == true)
                        {
                            networkInterfaceTableView.setDhcpDisabled(true);
                        }
                        productVarValue = productConfigMembers[MAX_NO_OF_NICS_DISPLAYED_KEY];
                        if(productVarValue < maxNoOfNICsDisplayed)
                        {
                            maxNoOfNICsDisplayed = productVarValue;
                        }
                        productVarValue = productConfigMembers[MAX_NO_OF_NICS_SUPPORTED_DISABLED_KEY];
                        if(productVarValue < maxNoOfNICsSupported)
                        {
                            maxNoOfNICsSupported = productVarValue;
                        }
                        productVarValue = productConfigMembers[NIC_USAGE_CONFIGURABLE_DISABLED_KEY];
                        if(productVarValue === 'true' || productVarValue == true)
                        {
                            networkInterfaceTableView.setNicUsageEditable(true);

                        }else if(productVarValue === 'false' || productVarValue == false)
                        {
                            networkInterfaceTableView.setNicUsageEditable(false);

                        }
                        productVarValue = productConfigMembers[ALIAS_SUPPORTED_DISABLED_KEY];
                        if(productVarValue)
                        {
                            aliasSupported = productVarValue;
                            if(aliasSupported === 'true'){
                                networkInterfaceTableView.setAliasSupported(true);
                            }
                        }
                        productVarValue = productConfigMembers[ALIAS_SUPPORTED_DISABLED_OLD_KEY];
                        if(productVarValue)
                        {
                            aliasSupportedOld = productVarValue;
                            if(aliasSupportedOld != null){
                                networkInterfaceTableView.setAliasSupported(true);
                            }
                        }
                        productVarValue = productConfigMembers[MULTI_NIC_SAMESUBNET_VALDATION_DISABLED_KEY];
                        if(productVarValue === 'true' || productVarValue == true)
                        {
                            networkInterfaceTableView.setMultiNICSameSubnetValidationDisabled(true);
                        }
                        productVarValue = productConfigMembers[GENERATE_CERT_FOR_EACH_NIC_DISABLED_KEY];
                        if(productVarValue === 'true' || productVarValue == true)
                        {
                            networkInterfaceTableView.setGenerateCertificateForEachNicDisabled(true);
                        }
                        productVarValue = productConfigMembers[NIC_USAGE_LABELS_KEY];
                        if (productVarValue){
                            var nicUsageValue = productVarValue.split(":");
                            networkInterfaceTableView.setNicUsageLabels(nicUsageValue);
                        }
                        // newly added for pulsar  cert product config's
                        productVarValue = productConfigMembers[DISABLE_NIC_CONFIGURATION_THROUGH_UI_KEY];
                        if (productVarValue){
                            var disabledNics = removeEth0fromInput(productVarValue);
                            if (disabledNics != null){
                                networkInterfaceTableView.setDisableNICConfigurationThroughUI(disabledNics);
                            }
                        }
                        productVarValue = productConfigMembers[DISABLE_NIC_UNCONFIGURE_THROUGH_UI_KEY];
                        if (productVarValue) {
                            var disabledNics = removeEth0fromInput(productVarValue);
                            if (disabledNics != null){
                                networkInterfaceTableView.setDisableUnconfigureNICThroughUI(disabledNics);
                            }
                        }
                        productVarValue = productConfigMembers[DISABLE_UPDATENIC_CONFIGURATION_THROUGH_UI_KEY];
                        if (productVarValue){
                            networkInterfaceTableView.setDisableUpdateNICConfigurationThroughUI(productVarValue);
                        }
                        productVarValue = productConfigMembers[DISABLE_UPDATENIC_CONFIGURATION_THROUGH_UI_KEY];    
                        if (productVarValue){
                                    networkInterfaceTableView.setDisableUpdateNICConfigurationThroughUI(productVarValue);
                        }
                        productVarValue = productConfigMembers[RABBITMQ_ENABLED_NICS_KEY];
                        if (productVarValue){
                            networkInterfaceTableView.setRabbitmqEnabledNICs(productVarValue);
                        }
                        productVarValue = productConfigMembers[USER_ALLOWEDTO_CHANGE_RABBITMQ_CONFG_KEY];
                        if(productVarValue === 'true' || productVarValue == true){
                            networkInterfaceTableView.setUserAllowedToChangeRabbitMQConf(true);
                        }
                        productVarValue = productConfigMembers[RABBITMQ_CERT_ENABLED_KEY];
                        if(productVarValue === 'true' || productVarValue == true){
                            networkInterfaceTableView.setImportRabbitmqCertificateEnabled(true);
                        }
                        productVarValue = productConfigMembers[POSTGRES_ENABLED_NICS_KEY];
                        if (productVarValue){
                            networkInterfaceTableView.setPostgresEnabledNICs(productVarValue);
                        }
                        productVarValue = productConfigMembers[USERALLOWEDTO_CHANGE_POSTGRES_CONF_KEY];
                        if(productVarValue === 'true' || productVarValue == true){
                            networkInterfaceTableView.setUserAllowedToChangePostgresConf(true);
                        }
                        productVarValue = productConfigMembers[POSTGRES_CERT_ENABLED_KEY];
                        if(productVarValue === 'true' || productVarValue == true){
                            networkInterfaceTableView.setImportPostgresCertificateEnabled(true);
                        }
                        productVarValue = productConfigMembers[WEBSERVER_CERT_ENABLED_KEY];
                        if(productVarValue === 'true' || productVarValue == true){
                            networkInterfaceTableView.setImportWebserverCertificateEnabled(true);
                        }
                        productVarValue = productConfigMembers[WEBSERVER_ENABLED_NICS_KEY];
                        if (productVarValue){
                            networkInterfaceTableView.setWebserverEnabledNICs(productVarValue);
                        }
                        productVarValue = productConfigMembers[DISABLE_UNCONFIGURE_NIC_THROUGH_REST_KEY];
                        if (productVarValue){
                            networkInterfaceTableView.setDisableUnconfigureNICThroughREST(productVarValue);
                        }
                        productVarValue = productConfigMembers[DISABLE_UPDATE_NIC_THROUGH_REST_KEY];
                        if (productVarValue){
                            networkInterfaceTableView.setDisableUpdateNICConfigurationThroughREST(productVarValue);
                        }
                        productVarValue = productConfigMembers[DISABLE_CONFIGURE_NIC_THROUGH_REST_KEY];
                        if (productVarValue){
                            var restDisabledNics = removeEth0fromInput(productVarValue);
                            if (restDisabledNics != null){
                                networkInterfaceTableView.setDisableNICConfigurationThroughREST(restDisabledNics);
                            }
                        }
                        


                        if(!multiNICDisabled){

                            var data = [];
                            networkInterfaceTableView.init(presenter, base, {
                                table: $('#cic-appliance-nics-table'),
                                resource: data,
                                multiSelect: true,
                                dataTableOptions:  {
                                    aoColumns : [
                                        {mRender: function ( data, type, full) {
                                            return '<div class="hp-collapser"></div>';
                                        },
                                        sWidth: 20, sClass: "hp-icon", sDefaultContent: ''},
                                        {mDataProp: 'slno', sClass:"sl-no", sWidth: 5},
                                        {mDataProp: 'usage', sClass:"usage"},
                                        {mDataProp: 'hostname'},
                                        {mDataProp: 'ipAddress', sClass:"ipAddress"},
                                        {mDataProp: 'macAddress', sClass:"mac-address", sWidth: 30},
                                        {mDataProp: 'interfaceType', sClass:"interfaceType", sWidth: 20, sDefaultContent: ''},
                                        {mDataProp: 'device',sClass:"device", bVisible:false},
                                        {mDataProp: 'aliasSupport',sClass:"aliasSupport", bVisible:false}],
                                        aaSorting: [[ 8, "asc" ]],
                                        fnRowCallback : function( nRow, aData, iDisplayIndex, iDisplayIndexFull ) {
                                        $(nRow).attr('id', 'cic-appliance-nics-table-row-'+aData.slno);
                                        return nRow;
                                    }
                                }
                            });

                            var nics = [];
                            var deviceStr = '';
                            var cnt = 1;
                            if(applianceMoreView === false){
                                resetSectionErrors();
                            }
                            presenter.getConfiguredNICs({
                                success: function(multiNicDTO) {
                                    nics = $.merge( nics, multiNicDTO.applianceNetworks );

                                    presenter.getUnconfiguredNICs({
                                        success: function(networkObjectUnconfList) {
                                            nics = $.merge( nics, networkObjectUnconfList );

                                            nics = nics.sort(function(a, b) {
                                                var deviceA = a.device.toLowerCase();
                                                var deviceB = b.device.toLowerCase();
                                                if (deviceA < deviceB){
                                                    return -1
                                                }
                                                if (deviceA > deviceB){
                                                    return 1
                                                }

                                                return 0 //default return value (no sorting)

                                            });
                                            networkInterfaceTableView.setAllNICs(nics);
                                            var app1Ipv4Alias = null;
                                            var eth0MacAddress = null;
                                            $.each( nics, function( key, value ) {
                                                if (cnt <= maxNoOfNICsDisplayed){
                                                    deviceStr = value.device;
                                                    var interfaceTypeVal = '';
                                                    var interfaceName = value.interfaceName;
                                                    var aliasSupport = null;

                                                    if(value.device == 'eth0'){
                                                        primaryConfig = this;
                                                        if(networkInterfaceTableView.getIpv6Disabled()){
                                                        	primaryConfig.ipv6Type = "UNCONFIGURE";
                                                        }
                                                        networkInterfaceTableView.setPrimaryNetworkObj(primaryConfig);
                                                        interfaceTypeVal = 'Primary';
                                                        interfaceName = localizer.getString("fs.settings.network.fields.appliance");
                                                        app1Ipv4Alias = value.app1Ipv4Alias;
                                                        eth0MacAddress = value.macAddress;

                                                    }
                                                    if(value.app1Ipv4Addr != null){
                                                        if (networkInterfaceTableView.getAliasSupported() && (cnt == 2))
                                                        {
                                                            //eth1 configured for independent on MacAddr
                                                            aliasSupport = 'independentMacAddr'; // configured eth1
                                                        }
                                                        var hostnameValue = value.hostname;
                                                            // check to see whether we have an intitial  non-FQDN hostname
                                                            // and it is not autogenerated one, i.e. it does not start with "ci-"
                                                        if (firstTimeFlag && (hostnameValue != null && hostnameValue.indexOf('.') == -1) && (hostnameValue.indexOf(AUTOGENERATED_PREFIX) != 0) &&
                                                        (value.domainName || value.searchDomains[0] ))  {
                                                            var suffix =  (value.domainName) ?  value.domainName : value.searchDomains[0] ;
                                                            hostnameValue = hostnameValue + '.' + suffix;
                                                        }
                                                        data.push({'slno':cnt, 'usage':interfaceName, 'hostname':hostnameValue, 'ipAddress':value.app1Ipv4Addr, 'macAddress': value.macAddress, 'interfaceType': interfaceTypeVal,'device':value.device,'aliasSupport':aliasSupport});
                                                    }
                                                    else{
                                                        var usage = '';
                                                        var ipAddress = UNASSIGNED;
                                                        var macAddress = value.macAddress;

                                                        if (interfaceName === localizer.getString("fs.settings.network.fields.appliance")){
                                                            usage = interfaceName;
                                                        }
                                                        if (networkInterfaceTableView.getAliasSupported() && (cnt == 2))
                                                        {
                                                            //eth1 not configured for alias
                                                            usage = localizer.getString("fs.settings.network.fields.deployment");
                                                            aliasSupport = value.macAddress;
                                                            macAddress = '';//empty string check needed in table view
                                                            unconfiguredDeployementMac = value.macAddress;
                                                            if (app1Ipv4Alias != null) {
                                                                //eth1 configured for alias
                                                                ipAddress = app1Ipv4Alias;
                                                                macAddress = eth0MacAddress;// alias configured for eth1
                                                                //value.macAddress;
                                                                aliasSupport = "aliasMacAddr-"+value.macAddress;

                                                         }
                                                    }


                                                        data.push({'slno':cnt,'usage':usage, 'hostname':'', 'ipAddress':ipAddress, 'macAddress': macAddress, 'interfaceType': interfaceTypeVal,'device':value.device,'aliasSupport':aliasSupport});

                                                    }
                                                    cnt++;
                                                }
                                               });


                                            $('#cic-appliance-nics-table').dataTable().fnAddData(data);

                                            if(cnt > 2){
                                                singleNicEnabled = false;
                                                if (applianceMoreView) {
                                                    $(APPLIANCE_IPV4_PANEL).hide();
                                                    $(APPLIANCE_DNS_PANEL).hide();
                                                    $(APPLIANCE_IPV6_PANEL).hide();
                                                    networkInterfaceTableView.setApplianceMoreView(true);
                                                }else {
                                                    networkInterfaceTableView.setApplianceMoreView(false);
                                                }
                                                $(MULTI_NIC_PANEL).show();
                                                $(PANEL_IPV4).hide();
                                                $(PANEL_DNS).hide();
                                                $(PANEL_IPV6).hide();
                                                $(HOSTNAME_PANEL).hide();
                                                $(CLASS_HOSTNAME).remove();
                                                $(CLASS_NICS).show();
                                                $(CLASS_IPV6_DISABLE).remove();
                                                $(CLASS_NETWORK_DNS).remove();
                                                $(CLASS_IPV4).remove();
                                                $(SECTION_ERR_GRP).hide();
                                                $(servicespanel).remove();
                                                $(webservicepanel).remove();
                                                $(sericespanelheader).remove();
                                                $(webserviceheader).remove();
                                                  if(networkInterfaceTableView.getNicUsageLabels().length == 0){
                                                      var nicUsageValue = [localizer.getString("fs.settings.network.fields.deployment"),localizer.getString("fs.settings.network.fields.management")];
                                                      networkInterfaceTableView.setNicUsageLabels(nicUsageValue);
                                                  }
                                            }
                                            nicCnt = cnt;
                                            pageReadyHandlers.success();
                                        },
                                        error: function(){
                                            pageReadyHandlers.success();
                                            base.onError();
                                        }
                                        
                                    });
                                },
                                error: function(){
                                    pageReadyHandlers.success();
                                    base.onError();
                                }
                            });
                        } else {
                            $(CLASS_NICS).remove();
                            pageReadyHandlers.success();
                        }
                    },
                    error: function(){
                        pageReadyHandlers.success();
                    }
                });
            }
            function setSecondIPDisplay(config) {

                secondIPConfigured = false;
//                if(aliasSupported == 'true' && aliasSupported != null  ){
                if(aliasSupported == 'true' || aliasSupportedOld != null){
                    secondIPConfigured = true;
                }

                if (secondIPConfigured) {
                    // remove DHCP box selectors
                    $(CLASS_DHCP_SELECTOR).remove();
                    //only show the warning if the curent configruation is DHCP
                    if (config.ipv4Type != presenter.STATIC) {
                        $(DHCP_IPV4_DISALLOWED).show();
                     }
                    // alias enabled then ip and second ip address labels are changing to ApplianceIp and DeploymentIP
                    $(FS_SECONDARY_IPV4_LABEL).text(localizer.getString('fs.settings.network.fields.ipaddr2.deploymentip'));
                    $(FS_NETWORK_IPV4_LABEL).text(localizer.getString('fs.settings.network.fields.ipaddr.applianceip'));
                    $(CLASS_SECOND_IP).show();
                } else {  // remove all the elements associated with the second IP
                    $(CLASS_SECOND_IP).remove();
                }
            }
            function removeHphashelp() {
                $(ipV4dhcpmsg).removeClass('hp-has-help');
                $(ipV4gatewaymsg).removeClass('hp-has-help');
            }

            function addHphashelp(){
                $(ipV4dhcpmsg).addClass('hp-has-help');
                $(ipV4gatewaymsg).addClass('hp-has-help');
            }

            function removeipv6Hphashelp() {
                $(ipV6dhcpmsg).removeClass('hp-has-help');
                $(ipV6gatewaydhcpmsg).removeClass('hp-has-help');
            }

            function addipv6Hphashelp() {
                $(ipV6dhcpmsg).addClass('hp-has-help');
                $(ipV6gatewaydhcpmsg).addClass('hp-has-help');
            }

            function resetErrors(){
                $('.fs-manual-validator-errors label').remove('.hp-error');
                $('.fs-manual-validator-errors input').removeClass('.hp-error');
                $('.fs-manual-validator-errors').removeClass('hp-has-error');
            }

            function resetipv6Errors(){
                $('.fs-manual-validator-IPV6-errors label').remove('.hp-error');
                $('.fs-manual-validator-IPV6-errors').removeClass('hp-has-error');
            }

            /**
             * Reset the errors and notifications
             */
            this.resetForm = function(form) {
                validator.resetForm();
                formStateView.reset();

            };

            this.resume = function(pageReadyHandlers) {
                $(RABBITMQ_SECTION).hpCollapsible('collapse');
                $(RABBITMQ_CACERT_SECTION).hpCollapsible('collapse');
                $(RABBITMQ_SERVERCERT_SECTION).hpCollapsible('collapse');
                $(RABBITMQ_PRIVATEKEY_SECTION).hpCollapsible('collapse');
                $(POSTGRESQL_SECTION).hpCollapsible('collapse');
                $(POSTGRESQL_CACERT_SECTION).hpCollapsible('collapse');
                $(POSTGRESQL_SERVERCERT_SECTION).hpCollapsible('collapse');
                $(POSTGRESQL_PRIVATEKEY_SECTION).hpCollapsible('collapse');
                $(WEBSERVER_SERVCERT_SECTION).hpCollapsible('collapse');
                $(WEBSERVER_CACERT_SECTION).hpCollapsible('collapse');
                $(WEBSERVER_PRIVATEKEY_SECTION).hpCollapsible('collapse');
                setNICDisplay(this, pageReadyHandlers);
                dateTimeChanged = false;
                
            };

            this.displayParameterError = function() {
                formStateView.setMessage({
                    status : 'error',
                    summary : localizer.getString('fs.settings.network.notify.set.parameterError')
                });
            };
            
            
            /**
             * Apply the network configuration.  (Validate should be called first. and then the backend validatiion will be checked
             * after applying the network)
             */
            this.apply = function(handlers) {

                var networkObjectList ;
                notifyResultFlag = true;
                if( singleNicEnabled )
                {
                    networkObjectList = createSingleNicObject();
                }else{
                    networkObjectList = marshalMultiNicFormData();

                    if(aliasVisible){

                        // if networkObjectList already has eth0 object and if alias is disabled,
                        // remove eth0 object and add the updated eth0 object
                        var tempNetworkObjList1 = [];
                        var primaryNicObj = null;
                        for(var i=0;i<networkObjectList.length;i++) {
                            var nicObj1 = networkObjectList[i];
                            if(nicObj1.app1Ipv4Addr === primaryConfig.app1Ipv4Addr && nicObj1.interfaceName === APPLIANCE){
                                primaryNicObj = nicObj1;
                            }
                            else {
                                tempNetworkObjList1.push(nicObj1);
                            }
                        }
                        if(aliasDisabled){
                            if(primaryNicObj != null){
                                networkObjectList = [];
                                $.merge( networkObjectList, tempNetworkObjList1 );
                            }
                            // If primaryNicObj is not null or if primary nic has alias associated with it
                            // then unconfigure alias from primary nic object and add it to networkObjectList
                            if(primaryNicObj != null || (primaryNicObj == null && primaryConfig.app1Ipv4Alias != null && primaryConfig.app1Ipv4Alias != '')){
                                var tempPrimaryConfig = jQuery.extend(true, {}, primaryConfig);
                                tempPrimaryConfig.app1Ipv4Alias = null;
                                tempPrimaryConfig.aliasDisabled = true;
                                networkObjectList.push(tempPrimaryConfig);
                            }
                        }
                        else {
                            //If alias is enabled, unconfigure the deployment nic
                            if(aliasAssocNICObj != null){
                                networkObjectList.push(createAliasAssocNICObj(aliasAssocNICObj));
                            }
                        }
                    }
                    else {
                        // If alias row is collapsed and primary nic row is expanded,
                        // alias should not be unconfigured
                        var tempNetworkObjList2 = [];
                        for(var n=0;n<networkObjectList.length;n++) {
                            var nicObj2 = networkObjectList[n];
                            if(nicObj2.app1Ipv4Addr === primaryConfig.app1Ipv4Addr && primaryConfig.app1Ipv4Alias != null && primaryConfig.app1Ipv4Alias != ''){
                                nicObj2.app1Ipv4Alias = primaryConfig.app1Ipv4Alias;
                                nicObj2.aliasDisabled = false;
                            }
                            tempNetworkObjList2.push(nicObj2);
                        }
                        networkObjectList = [];
                        $.merge( networkObjectList, tempNetworkObjList2 );
                    }
                }


                var timeDTO = createTimeDTO();
                var localeDTO = createLocaleDTO();
                var serverCertificateDTO = createServerCertificateDTO();

                postValidationOccuredFS = false;

                // Note: This is an Altair requirement (QXCR1001305078: Altair requires the Deployment NIC to be assigned an IP address in FTS)
                // If deployment nic is not configured during FTS, we are displaying it as pre validation error.
                // TODO: This needs to be done in back end code too
                var errorFlag = false;
                if(aliasSupportedOld != null && firstTimeFlag && networkObjectList.length < 2){
                    // During FTS if the user does not expand primary nic and just expands the deployment nic
                    // and provides alias data then throw pre-validation exception.
                    var isPrimaryRowExpanded = true;
                    if( !singleNicEnabled ){
                        var rows = $('#cic-appliance-nics-table').dataTable().fnGetNodes();
                        isPrimaryRowExpanded = $('#cic-appliance-nics-table').dataTable().fnIsOpen(rows[0]);
                    }

                    if(networkObjectList.length === 1 && networkObjectList[0].app1Ipv4Alias != null && networkObjectList[0].app1Ipv4Alias != '' && isPrimaryRowExpanded){
                        errorFlag = false;
                    }
                    else {
                        errorFlag = true;
                    }
                }

                if(errorFlag){

                    if (notifyResultFlag) {
                        var notif = {
                            sourceName: localizer.getString('fs.settings.network.notify.sourceName'),
                            summary: localizer.getString('fs.settings.network.notify.set.error'),
                            status : 'error',
                            details : localizer.getString('fs.settings.network.notify.set.multi_nic_fts_error')

                       };
                        formStateView.setMessage(notif);
                        notifyResultFlag = false;

                    }
                    handlers.error('error');

                }
                else {
                    presenter.postNetwork(primaryNetworkObj,editedPrimaryNetworkObj,
                            networkObjectList, timeDTO, localeDTO , serverCertificateDTO,{
                        running : onSetConfigRunning,
                        success : function(data) {
                            formStateView.reset();
                            onSetConfigSuccess(data, handlers);
                        },
                        error : function(errorInfo) {
                            formStateView.reset();
                            onSetConfigError(errorInfo);
                            handlers.error(errorInfo);
                        }
                    });

                }

            };

            this.addNicsValidatorOptions = function(options, index){
                   if(singleNicEnabled){
                    $.extend(true, options, {
                        ignore : ":hidden",
                        rules : {
                            'ip-ipv4' : {
                            hostAddress : IPV4
                            },
                             'ip-ipv4-2a' : {

                                hostAddress : IPV4
                            },
                            'ip-ipv6' : {
                                hostAddress : IPV6
                            },
                            'floating-ip-ipv4' : {
                                hostAddress : IPV4
                            },
                            'floating-ip-ipv6' : {
                                hostAddress : IPV6
                            },
                            'node1-ipv4' : {
                                hostAddress : IPV4
                            },
                            'node1-ipv6' : {
                                hostAddress : IPV6
                            },
                            'node2-ipv4' : {
                                hostAddress : IPV4
                            },
                            'node2-ipv6' : {
                                hostAddress : IPV6
                            },
                            'mask-ipv4' : {
                                hostAddress : MASKV4
                            },
                            'mask-ipv6' : {
                                hostAddress : MASKV6
                            },
                            'gateway-ipv4' : {
                                hostAddress : IPV4
                            },
                            'gateway-ipv6' : {
                                hostAddress : IPV6
                            },
                            //Time and Place
                            'ntpserver1' : {
                                required : true,
                                hostAddress : [IPV4, IPV6, HOSTNAME_RULE, FQDN ]
                            },
                            'ntpserver2' : {
                                hostAddress : [IPV4, IPV6, HOSTNAME_RULE, FQDN ]
                            },
                            'ntpserver3' : {
                                hostAddress : [IPV4, IPV6, HOSTNAME_RULE, FQDN ]
                            },
                            'currentdatetime' : {
                                required : true
                            },
                            'timezone_input' : {
                                required : true
                            },
                            'locale_input' : {
                                required : true
                            }

                            // The other fields, and the required flag for the above
                            // fields, are handled in updateForm().
                        },
                        messages : {
                            'ip-ipv4' : localizer.getString('fs.settings.network.validator.ipv4'),
                            'ip-ipv4-2a' : localizer.getString('fs.settings.network.validator.ipv4'),
                            'ip-ipv6' : localizer.getString('fs.settings.network.validator.ipv6'),
                            'node1-ipv4' : localizer.getString('fs.settings.network.validator.ipv4'),
                            'node1-ipv6' : localizer.getString('fs.settings.network.validator.ipv6'),
                            'node2-ipv4' : localizer.getString('fs.settings.network.validator.ipv4'),
                            'node2-ipv6' : localizer.getString('fs.settings.network.validator.ipv6'),
                            'mask-ipv4' : localizer.getString('fs.settings.network.validator.mask-ipv4'),
                            'mask-ipv6' : localizer.getString('fs.settings.network.validator.mask-ipv6'),
                            'gateway-ipv4' : localizer.getString('fs.settings.network.validator.gateway-ipv4'),
                            'gateway-ipv6' : localizer.getString('fs.settings.network.validator.gateway-ipv6'),
                            // The messages for the other validators are set in
                            // updateForm() since they vary.
                            // Time and Place
                            'ntpserver' : localizer.getString('fs.settings.network.validator.ntpserver.ntp_fqdn_required'),
                            'currentdatetime' : localizer.getString('fs.settings.network.validator.currentdatetime.datetime_required'),
                            'timezone_input' : localizer.getString('fs.settings.network.validator.timezone.timezone_required'),
                            'locale_input' : localizer.getString('fs.settings.network.validator.locale.locale_required')
                        },
                        errorClass : 'hp-error'
                    });

                   }
                return options;
            };



            /**
             * Set the form layout based on the network configuration.
             */
            this.setFormLayout = function(config) {
                localNodeID = config.localNodeID;
                setSecondIPDisplay(config);
            };
            /*
             * Indicates we are on the initial network set-up page
             */
            this.setFirstTime = function(firstTime) {
                firstTimeFlag = firstTime;
                var suffix;
                if (firstTime) {
                   suffix='-init';
                 } else {
                   suffix='-edit';
                 }
                 SPLASH_DIALOG = SPLASH_DIALOG_BASE + suffix;
                 SPLASH_PROGRESS = SPLASH_PROGRESS_BASE + suffix;
                 SPLASH_ESTIMATE = SPLASH_ESTIMATE_BASE + suffix;

            };
         // Show the contents of a field, with handling of "not set".
            function setField(field, value) {
                if (value) {
                    $(field).text(value).removeClass(UNAVAILABLE);
                } else {
                    $(field).text(localizer.getString('core.common.notset')).removeClass(UNAVAILABLE);
                    $(field + FROM_DHCP).hide();
                }
            }

            // Display the network data (called when it is received from the server).
            function showNetworkData(networkObject) {
                // Set the field visibilities based on the configuration.
                if (networkObject.ipv4Type == 'DHCP') {
                    $(CLASS_IPV4_DHCP).show();
                }
                if (networkObject.ipv6Type == 'DHCP') {
                    $(CLASS_IPV6_DHCP).show();
                }
                if (networkObject.ipv6Type != 'UNCONFIGURE') {
                    $(CLASS_IPV6).show();
                    if (secondIPUsed) { // the IP has to be configured
                        $(CLASS_SECOND_IPv6_IP).show();
                    }
                }
                if (!networkObject.confOneNode) {
                    $(CLASS_2NODE).show();
                    $(CLASS_1NODE).hide();
                } else {
                    $(CLASS_2NODE).hide(); // some 2 node fields may have been shown by CLASS_IPV6 above.
                }

                // Set the field contents.
                setField(HOSTNAME, networkObject.hostname);
                setField(IPV4_PREFIX + ADDR_1NODE, networkObject.app1Ipv4Addr);
                setField(IPV6_PREFIX + ADDR_1NODE, networkObject.app1Ipv6Addr);
                setField(IPV4_PREFIX + SUBNET, networkObject.ipv4Subnet);
                setField(IPV6_PREFIX + SUBNET, networkObject.ipv6Subnet);
                setField(IPV4_PREFIX + GATEWAY, networkObject.ipv4Gateway);
                setField(IPV6_PREFIX + GATEWAY, networkObject.ipv6Gateway);
                setField(IPV4_PREFIX + ADDRTYPE, localizer.getString('fs.settings.appliance.addrType.' + networkObject.ipv4Type));
                setField(IPV6_PREFIX + ADDRTYPE, localizer.getString('fs.settings.appliance.addrType.' + networkObject.ipv6Type));
                setField(PREFERRED, networkObject.ipv4NameServers[0]);
                setField(ALTERNATE, networkObject.ipv4NameServers[1]);
                if(aliasSupported == 'true' || aliasSupportedOld != null){
                    setField(IPV4_2_IPADDR,networkObject.app1Ipv4Alias);
                }
                $(PANELS).hpStackedPanels('reset');
            }
            
            this.setServerCertificate = function (serverCertificate) {
                if(networkInterfaceTableView.getImportRabbitmqCertificateEnabled() === false) {
                    $(RABBITMQ_SHOW).hide();
                }else {
                    $(RABBITMQ_SERVER_CERT_TEXT).val(serverCertificate.rabbitMQCertificate);
                    $(RABBITMQ_PRIVATEKEY_TEXT).val(serverCertificate.rabbitMQCertificateKey);
                    $(RABBITMQ_ROOTCA_CERT_TEXT).val(serverCertificate.rabbitMQRootCACertificate);
                }
                if(networkInterfaceTableView.getImportPostgresCertificateEnabled() === false) {
                    $(POSTGRESQL_SHOW).hide();
                }else {
                    $(POSTGRESQL_SERVER_CERT_TEXT).val(serverCertificate.postgresCertificate);
                    $(POSTGRESQL_PRIVATEKEY_TEXT).val(serverCertificate.postgresCertificateKey);
                    $(POSTGRESQL_ROOTCA_CERT_TEXT).val(serverCertificate.postgresRootCACertificate);
                }
            }

            this.fillFields = function(config, cnt) {
                originalConfig = config;

                if (applianceMoreView && singleNicEnabled){
                    showNetworkData(config);
                    setSecondIPDisplay(config);
                } else {

              var usageId = USAGE;
              var usageInput = usageId;
              var dns1Id = DNS_PREFERRED;
              var dns2Id = DNS_ALTERNATE ;
              var deviceId = DEVICE;
              var macId = MAC_ADDR;
              var ipV6Id = IPV6IPADDR;
              var dhcpIPV6AssignId = DHCP_IPV6_ASSIGN;
              var maskV6Id = IPV6MASK ;
              var gatewayV6Id = IPV6GATEWAY;
              var addressAssignment = ADDRESS_IPV4_ASSIGNMENT;
              var addressipV6Assignment = ADDRESS_IPV6_ASSIGNMENT;
              var networkoneonenodeipv6 = NETWORK_ONE_NODE_IPV6;
              var cicnetworkipv6 = NETWORK_IPV6;
              var hostname = HOSTNAME;
              var ipv4Addr = IPV4IPADDR;
              var ipv4mask = IPV4MASK;
              var ipv4gateway = IPV4GATEWAY;
              var staticIpAssignId = STATIC_IP_ASSIGN;
              var dhcpIpAssign = DHCP_IP_ASSIGN;
              var staticIPv6Assign = STATIC_IPV6_ASSIGN;
              var panel_ipv6 = PANEL_IPV6;
              var panel_dns = PANEL_DNS;
              var panel_ipv4 = PANEL_IPV4;
              var networkoneonenodeipv4 = NETWORK_ONE_ONE_NODE_IPV4;
              var unassignipv4 = UNASSIGNIPV4;
              var unassignipv6 = UNASSIGNIPV6;
              var subnetmaskipv4= SUBNET_MASK_IPV4_ID;
              var subnetmaskipv6 = SUBNET_MASK_IPV6_ID;
              var gatewayipv6 = GATEWAY_IPV6_ID;
              var dhcpipv4warning = DHCP_IPV4_WARNING;
              var dhcpIPv6Warning = DHCP_IPV6_WARNING;
              var ipv6DualStackWarning = DUAL_STACK_WARNING;
              var dns1dhcpmsg = DNS1_ID;
              var dns2dhcpmsg = DNS2_ID;
              var ipv4_2_Addr = IPV4_2_IPADDR;
              var ipV4dhcpHelp = ipV4dhcpmsg;
              var ipV4maskdhcpHelp = ipV4maskdhcpmsg;
              var ipV4gatewayHelp = ipV4gatewaymsg;
              var ipV6dhcpHelp = ipV6dhcpmsg;
              var ipV6subnetdhcpHelp = ipV6subnetdhcpmsg;
              var ipV6gatewaydhcpHelp = ipV6gatewaydhcpmsg;
              var classIpv4NonDhcpErrors = CLASS_IPV4_NON_DHCP_ERRORS;
              var classIpv6NonDhcpErrors = CLASS_IPV6_NON_DHCP_ERRORS;
              var ipv4type = IPV4TYPE;
              var ipv6type = IPV6TYPE;
              
              var webServerCertificate = WEBSERVER_SERVER_CERT_TEXT;
              var webServerCertificateChain = WEBSERVER_CERTCHAIN_TEXT;
              var webServerCertificateKey = WEBSERVER_PRIVATEKEY_TEXT;
              var postgresListner  = POSTGRESQL_LISTNER;
              var rabbitmqListner  = RABBITMQ_LISTNER;
              var readonly = CLASS_READONLY;
              var disabled = CLASS_DISABLED;
              var unconfigure = CLASS_UNCONFIGURE;
              
              if (cnt >= 0){

                  usageId = USAGE + "-" + cnt;
                  usageInput = usageId + "-input";
                    dns1Id = DNS_PREFERRED + "-" + cnt;
                    dns2Id = DNS_ALTERNATE + "-" + cnt;
                    deviceId = DEVICE + "-" + cnt;
                    macId = MAC_ADDR + "-" + cnt;
                    ipV6Id = IPV6IPADDR + "-" + cnt;
                    dhcpIPV6AssignId = DHCP_IPV6_ASSIGN + "-" + cnt;
                    maskV6Id = IPV6MASK + "-" + cnt;
                    gatewayV6Id = IPV6GATEWAY + "-" + cnt;
                    addressAssignment = ADDRESS_IPV4_ASSIGNMENT + "-" + cnt;
                    addressipV6Assignment = ADDRESS_IPV6_ASSIGNMENT + "-" + cnt;
                    networkoneonenodeipv6 = NETWORK_ONE_NODE_IPV6 + "-" + cnt;
                    cicnetworkipv6 = NETWORK_IPV6 + "-" + cnt;
                    hostname = HOSTNAME + "-" + cnt;
                    ipv4Addr = IPV4IPADDR + "-" + cnt;
                  ipv4mask = IPV4MASK + "-" + cnt;
                  ipv4gateway = IPV4GATEWAY + "-" + cnt;
                  staticIpAssignId = STATIC_IP_ASSIGN + "-" + cnt;
                  dhcpIpAssign = DHCP_IP_ASSIGN + "-" + cnt;
                  staticIPv6Assign = STATIC_IPV6_ASSIGN + "-" + cnt;
                  panel_ipv6 = PANEL_IPV6 + "-" + cnt;
                  panel_dns = PANEL_DNS + "-" + cnt;
                  panel_ipv4 = PANEL_IPV4 + "-" + cnt;
                  networkoneonenodeipv4 = NETWORK_ONE_ONE_NODE_IPV4 + "-" + cnt;
                  unassignipv4 = UNASSIGNIPV4 + "-" + cnt;
                  unassignipv6 = UNASSIGNIPV6 + "-" + cnt;
                  subnetmaskipv4= SUBNET_MASK_IPV4_ID + "-" + cnt;
                  subnetmaskipv6= SUBNET_MASK_IPV6_ID + "-" + cnt;
                  gatewayipv6= GATEWAY_IPV6_ID + "-" + cnt;
                  dhcpipv4warning = DHCP_IPV4_WARNING + "-" + cnt;
                  dhcpIPv6Warning = DHCP_IPV6_WARNING + "-" + cnt;
                  ipv6DualStackWarning = DUAL_STACK_WARNING + "-" + cnt;
                  dns1dhcpmsg  = DNS1_ID + "-" + cnt;
                  dns2dhcpmsg  = DNS2_ID + "-" + cnt;
                  ipV4dhcpHelp =ipV4dhcpmsg + "-" +cnt;
                  ipV4maskdhcpHelp =ipV4maskdhcpmsg + "-" +cnt;
                  ipV4gatewayHelp =ipV4gatewaymsg + "-" +cnt;
                  ipV6dhcpHelp = ipV6dhcpmsg + "-" +cnt;
                  ipV6subnetdhcpHelp = ipV6subnetdhcpmsg + "-" +cnt;
                  ipV6gatewaydhcpHelp = ipV6gatewaydhcpmsg + "-" +cnt;
                  classIpv4NonDhcpErrors = ".ipv4-non-DHCP-errors-"+cnt;
                  classIpv6NonDhcpErrors = ".ipv6-non-DHCP-errors-"+cnt;
                  ipv4type = IPV4TYPE+ "-" + cnt;
                  ipv6type = IPV6TYPE+ "-" + cnt;
                  webServerCertificate = WEBSERVER_SERVER_CERT_TEXT+"-"+cnt;
                  webServerCertificateChain = WEBSERVER_CERTCHAIN_TEXT+"-"+cnt;
                  webServerCertificateKey = WEBSERVER_PRIVATEKEY_TEXT+"-"+cnt;
                  postgresListner  = POSTGRESQL_LISTNER+"-"+cnt;
                  rabbitmqListner  = RABBITMQ_LISTNER+"-"+cnt;
                  readonly = CLASS_READONLY+"-"+cnt;
                  disabled = CLASS_DISABLED+"-"+cnt;
                  unconfigure = CLASS_UNCONFIGURE+"-"+cnt;
              }

              if(!singleNicEnabled) {
                  $(HOSTNAME_PANEL).hide();
                  $(hostname).val(config.hostname);
                  $(CLASS_HOSTNAME).hide();
                  $(CLASS_NICS).show();
              }
              var hostnameValue = config.hostname;

                  // check to see whether we have an intitial  non-FQDN hostname
                 // and it is not autogenerated one, i.e. it does not start with "ci-"
                 if (firstTimeFlag && (hostnameValue.indexOf('.') == -1) && (hostnameValue.indexOf(AUTOGENERATED_PREFIX) != 0) &&
                     (config.domainName || config.searchDomains[0] ))  {
                   var suffix =  (config.domainName) ?  config.domainName : config.searchDomains[0] ;
                   hostnameValue = hostnameValue + '.' + suffix;
                 }

                $(hostname).val(hostnameValue);
                HOSTNAME_ORIGINAL = hostnameValue;

                if( applianceMoreView ){
                    setField(hostname, hostnameValue);
                    setField(deviceId, config.device);
                    setField(ipv4Addr, config.app1Ipv4Addr);
                    setField(ipv4mask, config.ipv4Subnet);
                    setField(ipv4gateway, config.ipv4Gateway);
                    setField(dns1Id, config.ipv4NameServers[0]);
                    setField(dns2Id, config.ipv4NameServers[1]);
                    setField(ipV6Id, config.app1Ipv6Addr);
                    setField(maskV6Id, config.ipv6Subnet);
                    setField(gatewayV6Id, config.ipv6Gateway);
                    setField(macId, config.macAddress);
                    setField(usageId, config.interfaceName);
                    setField(ipv4type, localizer.getString('fs.settings.appliance.addrType.' + config.ipv4Type));
                    setField(ipv6type, localizer.getString('fs.settings.appliance.addrType.' + config.ipv6Type));

                } else {

                // IPV4 value settings


                if(singleNicEnabled)
                {
                   $(usageId).hide();
                   $(usageInput).hide();
                   setSecondIPDisplay(config);
                }else {

                  if(config.device == 'eth0') {
                      $(usageInput).hide();
                      $(usageId).val(localizer.getString("fs.settings.network.fields.appliance"));
                      $(usageId).attr("disabled", true);

                 }else if (networkInterfaceTableView.getNicUsageEditable()){
                      $(usageId).hpSearchCombo({results: networkInterfaceTableView.getNicUsageLabels(), maxResults: networkInterfaceTableView.getNicUsageLabels().length});
                      // Set the current Usage to combo box.
                      $(usageId).hpSearchCombo('set', {id: config.interfaceName, name: config.interfaceName});
                  }else {
                      $(usageId).selectBox('value', config.interfaceName);
                      $(usageId).attr('selected',true);
                      $(usageId).selectBox({autoWidth: false});
                      $(usageInput).hide();
                  }
                }


                $(deviceId).val(config.device);
                if(config.macAddress!=null){
                    $(macId).val(config.macAddress);
                }
                $(ipv4Addr).val(config.app1Ipv4Addr);
                $(ipv4mask).val(config.ipv4Subnet);
                $(ipv4gateway).val(config.ipv4Gateway);
                $(dns1Id).val(config.ipv4NameServers[0]);
                $(dns2Id).val(config.ipv4NameServers[1]);
                $(ipv4_2_Addr).val(config.app1Ipv4Alias);


              if(config.ipv4Type == presenter.DHCP)
                {
                  $(dhcpipv4warning).show();
                  $(classIpv4NonDhcpErrors).css('visibility','hidden');

                  $(ipV4dhcpHelp).removeClass('hp-has-help');
                  $(ipV4gatewayHelp).removeClass('hp-has-help');
                  if(firstTimeFlag){
                      $(staticIpAssignId).attr('checked',true);
                      $(ipV4dhcpHelp).addClass('hp-has-help');
                      $(ipV4gatewayHelp).addClass('hp-has-help');
                      $(dhcpipv4warning).hide();
                      $(classIpv4NonDhcpErrors).css('visibility','visible');
                      $(ipv4Addr).val('');
                  } else if(singleNicEnabled && (aliasSupported == 'true' || aliasSupportedOld != null)){
                      $(IPV4IPADDR).attr("disabled", false);
                      $(IPV4MASK).attr("disabled", false);
                      $(IPV4GATEWAY).attr("disabled", false);

                      $(ipV4dhcpHelp).css('visibility', 'hidden');
                      $(ipV4maskdhcpHelp).css('visibility', 'hidden');
                      $(ipV4gatewayHelp).css('visibility', 'hidden');
                      $(DNS1_ID).css('visibility', 'hidden');
                      $(DNS2_ID).css('visibility', 'hidden');
                  }
                  else {
                      $(dhcpIpAssign).attr('checked',true);
                      $(ipv4Addr).attr("disabled", true);
                      $(ipv4mask).attr("disabled", true);
                      $(ipv4gateway).attr("disabled", true);

                      $(ipV4dhcpHelp).css('visibility','visible');
                      $(ipV4maskdhcpHelp).css('visibility','visible');
                      $(ipV4gatewayHelp).css('visibility','visible');
                      $(dns1dhcpmsg).css('visibility','visible');
                      $(dns2dhcpmsg).css('visibility','visible');
                  }
                }
              else {
                  $(ipV4dhcpHelp).addClass('hp-has-help');
                  $(ipV4gatewayHelp).addClass('hp-has-help');
                  $(staticIpAssignId).attr('checked',true);
                  $(dhcpipv4warning).show();
                  $(classIpv4NonDhcpErrors).css('visibility','visible');
              }

                // IPV6 value settings
                $(ipV6Id).val(config.app1Ipv6Addr);
                $(maskV6Id).val(config.ipv6Subnet);
                $(gatewayV6Id).val(config.ipv6Gateway);

              if(config.ipv6Type == presenter.STATIC)
                {
                  $(staticIPv6Assign).attr('checked',true);
                  $(dhcpIPv6Warning).hide();
                  $(ipv6DualStackWarning).show();
                  $(ipV6dhcpHelp).css('visibility','hidden');
                  $(ipV6subnetdhcpHelp).css('visibility','hidden');
                  $(ipV6gatewaydhcpHelp).css('visibility','hidden');
                  $(classIpv6NonDhcpErrors).css('visibility','visible');
                  $(ipV6dhcpHelp).addClass('hp-has-help');
                  $(ipV6gatewaydhcpHelp).addClass('hp-has-help');
                }
                else if(config.ipv6Type == presenter.DHCP)
                {
                    $(ipV6dhcpHelp).removeClass('hp-has-help');
                    $(ipV6gatewaydhcpHelp).removeClass('hp-has-help');
                    $(dhcpIPv6Warning).show();
                    $(ipv6DualStackWarning).show();
                    $(dhcpIPV6AssignId).attr('checked',true);
                    $(ipV6Id).attr("disabled", true);
                    $(maskV6Id).attr("disabled", true);
                    $(gatewayV6Id).attr("disabled", true);
                    $(ipV6dhcpHelp).css('visibility','visible');
                    $(ipV6subnetdhcpHelp).css('visibility','visible');
                    $(ipV6gatewaydhcpHelp).css('visibility','visible');
                    $(classIpv6NonDhcpErrors).css('visibility','hidden');
                }  else if(config.ipv6Type == presenter.UNCONFIGURE)
                {
                      $(unassignipv6).attr('checked',true);
                      $(panel_ipv6).show();
                      $(cicnetworkipv6).hide();
                      $(networkoneonenodeipv6).hide();
                      $(subnetmaskipv6).hide();
                      $(gatewayipv6).hide();
                      $(dhcpIPv6Warning).hide();
                      $(ipv6DualStackWarning).hide();
                }
                if(singleNicEnabled && (aliasSupported == 'true' || aliasSupportedOld != null || networkInterfaceTableView.getIpv6Disabled())){
                    $(panel_ipv6).hide();
                    $(CLASS_IPV6_DISABLE).remove();
                }
                // pulsar cert import checks
                if(networkInterfaceTableView.getImportWebserverCertificateEnabled() === false) {
                    $(webservicepanel).hide();
                    $(webserviceheader).hide();
                    
                }else {
                    $(webServerCertificate).val(config.webServerCertificate);
                    $(webServerCertificateChain).val(config.webServerCertificateChain);
                    $(webServerCertificateKey).val(config.webServerCertificateKey);
                }
                if((networkInterfaceTableView.getImportRabbitmqCertificateEnabled() === false ) && (networkInterfaceTableView.getImportPostgresCertificateEnabled() === false)){
                    $(certificatepanelshow).hide();
                    $(certificatepanel).hide();
                }
                if (networkInterfaceTableView.getUserAllowedToChangePostgresConf()  ){
                    if (config.configurePostgresSslListener){
                        $(postgresListner).attr('checked',true);
                    }else{
                    $(postgresListner).attr('checked',false);
                    }
                }else {
                      $(CLASS_POSTGRESQL_LISTNER).hide();
                      $(POSTGRES_LISTNER_WARN).hide();
                }
                if (networkInterfaceTableView.getUserAllowedToChangeRabbitMQConf()  ){
                    if (config.configureRabbitMqSslListener){
                        $(rabbitmqListner).attr('checked',true);
                    }else {
                        $(rabbitmqListner).attr('checked',false);
                    }
                }else {
                      $(CLASS_RABBITMQ_LISTNER).hide();
                      $(RABBITMQ_LISTENER_WARN).hide(); 
                }
                if(networkInterfaceTableView.getUserAllowedToChangePostgresConf() === false && networkInterfaceTableView.getUserAllowedToChangeRabbitMQConf() === false) {
                    $(servicespanel).hide();
                    $(sericespanelheader).hide();
                }
                
                if ((networkInterfaceTableView.getDisableUpdateNICConfigurationThroughUI().indexOf(config.device) >= 0) || 
                    (networkInterfaceTableView.getDisableUpdateNICConfigurationThroughREST().indexOf(config.device)>= 0))
                {
                    $(readonly).attr('readonly', 'readonly');
                    $(disabled).attr('disabled',true);
                }
                if ((networkInterfaceTableView.getDisableUnconfigureNICThroughUI().indexOf(config.device)>= 0) || 
                    (networkInterfaceTableView.getDisableUnconfigureNICThroughREST().indexOf(config.device)>= 0))
                {
                    $(unconfigure).attr('disabled',true);
                }
                
                if(applianceMoreView === false){
                    updateForm(config.macAddress, cnt);	
                }
                 
                formStateView.reset();
                 }
                }
            };

            this.dismissDialog = function() {
                dismissDialogWindow();
            };
            /**
             * Update NTP field validation rules based on current
             * configuration/ form state
             * @param macAddress MAC address of NIC
             * @param count NIC identifier
             */
            this.updateNTPFieldRules = function(macAddress, count){
                var networkData = createNetworkObject(macAddress, count);
                updateNTPFieldRules(networkData, count);
            }
            
            /**
             * Initialize the view.
             */
            this.init = function(route_prefix, edit_form, handlers) {
                form = edit_form;
                routePrefix = route_prefix;
                setIPV6Display();
                setNICDisplay(this, handlers);

                $(AFFECTS_LAYOUT).change(updateForm);
                $(SPLASH_PROGRESS).hpProgressBar();
                $(SPLASH_PROGRESS).hpProgressBar(0);
                
                $(RABBITMQ_SECTION).hpCollapsible();
                $(RABBITMQ_CACERT_SECTION).hpCollapsible();
                $(RABBITMQ_SERVERCERT_SECTION).hpCollapsible();
                $(RABBITMQ_PRIVATEKEY_SECTION).hpCollapsible();
                
                $(POSTGRESQL_SECTION).hpCollapsible();
                $(POSTGRESQL_CACERT_SECTION).hpCollapsible();
                $(POSTGRESQL_SERVERCERT_SECTION).hpCollapsible();
                $(POSTGRESQL_PRIVATEKEY_SECTION).hpCollapsible();
                $(WEBSERVER_SERVCERT_SECTION).hpCollapsible();
                $(WEBSERVER_CACERT_SECTION).hpCollapsible();
                $(WEBSERVER_PRIVATEKEY_SECTION).hpCollapsible();
                
                $(WEBSERVER_PRIVATEKEY_SECTION).click(function() {
                if (!$(WEBSERVER_PRIVATEKEY_SECTION).hasClass("hp-collapsed")){
                    $(WEBSERVER_PRIVATEKEY_WARN).hide();
                } else{
                    $(WEBSERVER_PRIVATEKEY_WARN).show();
                }
                });
                //required field validation rules for rabbitMQ section.server certificate and CA certificate is mandatory only when any of the field
                //in RabbitMQ section is provided and it is expanded.same is the case with postgreSQL section.
                $(RABBITMQ_PRIVATEKEY_SECTION).click(function() {
                    if (!$(RABBITMQ_PRIVATEKEY_SECTION).hasClass("hp-collapsed")){
                        $(RABBITMQ_SERVER_CERT_TEXT).rules(ADD, REQUIRED);
                        $(RABBITMQ_ROOTCA_CERT_TEXT).rules(ADD, REQUIRED);
                    } else{
                        if($(RABBITMQ_CACERT_SECTION).hasClass("hp-collapsed") &&$(RABBITMQ_SERVERCERT_SECTION).hasClass("hp-collapsed")){
                            $(RABBITMQ_SERVER_CERT_TEXT).rules(REMOVE, REQUIRED);
                            $(RABBITMQ_ROOTCA_CERT_TEXT).rules(REMOVE, REQUIRED);
                        }
                    }
                });

                $(POSTGRESQL_PRIVATEKEY_SECTION).click(function() {
                    if (!$(POSTGRESQL_PRIVATEKEY_SECTION).hasClass("hp-collapsed")){
                        $(POSTGRESQL_SERVER_CERT_TEXT).rules(ADD, REQUIRED);
                        $(POSTGRESQL_ROOTCA_CERT_TEXT).rules(ADD, REQUIRED);
                    } else{
                        if ($(POSTGRESQL_SERVERCERT_SECTION).hasClass("hp-collapsed") && $(POSTGRESQL_CACERT_SECTION).hasClass("hp-collapsed")){
                            $(POSTGRESQL_SERVER_CERT_TEXT).rules(REMOVE, REQUIRED);
                            $(POSTGRESQL_ROOTCA_CERT_TEXT).rules(REMOVE, REQUIRED);
                        } 
                    }
                });

                $(POSTGRESQL_SERVERCERT_SECTION).click(function() {
                    if (!$(POSTGRESQL_SERVERCERT_SECTION).hasClass("hp-collapsed")){
                        $(POSTGRESQL_SERVER_CERT_TEXT).rules(ADD, REQUIRED);
                        $(POSTGRESQL_ROOTCA_CERT_TEXT).rules(ADD, REQUIRED);
                    } else{
                        if ($(POSTGRESQL_PRIVATEKEY_SECTION).hasClass("hp-collapsed") && $(POSTGRESQL_CACERT_SECTION).hasClass("hp-collapsed")){
                            $(POSTGRESQL_SERVER_CERT_TEXT).rules(REMOVE, REQUIRED);
                            $(POSTGRESQL_ROOTCA_CERT_TEXT).rules(REMOVE, REQUIRED);
                        }
                    }
                });

                $(POSTGRESQL_CACERT_SECTION).click(function() {
                    if (!$(POSTGRESQL_CACERT_SECTION).hasClass("hp-collapsed")){
                        $(POSTGRESQL_SERVER_CERT_TEXT).rules(ADD, REQUIRED);
                        $(POSTGRESQL_ROOTCA_CERT_TEXT).rules(ADD, REQUIRED);
                    } else{
                        if ($(POSTGRESQL_PRIVATEKEY_SECTION).hasClass("hp-collapsed") && $(POSTGRESQL_SERVERCERT_SECTION).hasClass("hp-collapsed")){
                            $(POSTGRESQL_SERVER_CERT_TEXT).rules(REMOVE, REQUIRED);
                            $(POSTGRESQL_ROOTCA_CERT_TEXT).rules(REMOVE, REQUIRED);
                        }
                    }
                });

                $(POSTGRESQL_SECTION).click(function() {
                    if ($(POSTGRESQL_SECTION).hasClass("hp-collapsed")){
                        $(POSTGRESQL_SERVER_CERT_TEXT).rules(REMOVE, REQUIRED);
                        $(POSTGRESQL_ROOTCA_CERT_TEXT).rules(REMOVE, REQUIRED);
                    } 
                });

                $(RABBITMQ_SERVERCERT_SECTION).click(function() {
                    if (!$(RABBITMQ_SERVERCERT_SECTION).hasClass("hp-collapsed")){
                        $(RABBITMQ_SERVER_CERT_TEXT).rules(ADD, REQUIRED);
                        $(RABBITMQ_ROOTCA_CERT_TEXT).rules(ADD, REQUIRED);
                    } else{
                        if($(RABBITMQ_PRIVATEKEY_SECTION).hasClass("hp-collapsed") &&$(RABBITMQ_CACERT_SECTION).hasClass("hp-collapsed")){
                            $(RABBITMQ_SERVER_CERT_TEXT).rules(REMOVE, REQUIRED);
                            $(RABBITMQ_ROOTCA_CERT_TEXT).rules(REMOVE, REQUIRED);
                        }
                     }
                });

                $(RABBITMQ_CACERT_SECTION).click(function() {
                    if (!$(RABBITMQ_CACERT_SECTION).hasClass("hp-collapsed")){
                        $(RABBITMQ_SERVER_CERT_TEXT).rules(ADD, REQUIRED);
                        $(RABBITMQ_ROOTCA_CERT_TEXT).rules(ADD, REQUIRED);
                    } else{
                        if($(RABBITMQ_PRIVATEKEY_SECTION).hasClass("hp-collapsed") &&$(RABBITMQ_SERVERCERT_SECTION).hasClass("hp-collapsed")){
                            $(RABBITMQ_SERVER_CERT_TEXT).rules(REMOVE, REQUIRED);
                            $(RABBITMQ_ROOTCA_CERT_TEXT).rules(REMOVE, REQUIRED);
                        }
                     }
                });

                $(RABBITMQ_SECTION).click(function() {
                    if ($(RABBITMQ_SECTION).hasClass("hp-collapsed")){
                        $(RABBITMQ_SERVER_CERT_TEXT).rules(REMOVE, REQUIRED);
                        $(RABBITMQ_ROOTCA_CERT_TEXT).rules(REMOVE, REQUIRED);
                    }
                });

                $(DHCP_IP_ASSIGN).change(function(){
                      if($('input[type="radio"][name=addressAssignment]:checked').val()== presenter.DHCP){
                          if(IPV4IPADDR.length > 0){
                              $(IPV4IPADDR).rules(REMOVE, REQUIRED);
                          }
                          if(IPV4MASK.length > 0){
                              $(IPV4MASK).rules(REMOVE, REQUIRED);
                          }
                          saveIPV4fields();
                          $(SUBNET_MASK_IPV4_ID).show();
                          $(NETWORK_ONE_ONE_NODE_IPV4).show();
                          $(IPV4IPADDR).attr("disabled", true);
                          $(IPV4MASK).attr("disabled", true);
                          $(IPV4GATEWAY).attr("disabled", true);
                          $(ipV4dhcpmsg).css('visibility','visible');
                          $(ipV4maskdhcpmsg).css('visibility','visible');
                          $(ipV4gatewaymsg).css('visibility','visible');
                          $(DNS1_ID).css('visibility','visible');
                          $(DNS2_ID).css('visibility','visible');
                          $(DHCP_IPV4_WARNING).show();
                          $(IPV4IPADDR).val('');
                          $(IPV4MASK).val('');
                          $(IPV4GATEWAY).val('');
                          $(DNS1).val('');
                          $(DNS2).val('');
                          $(CLASS_IPV4_NON_DHCP_ERRORS).css('visibility', 'hidden');
                          removeHphashelp();
                          resetErrors();
                          validator.element(DNS1);
                          validator.element(DNS2);
                      }
                  });
                  $(STATIC_IP_ASSIGN).change(function(){
                      if($('input[type="radio"][name=addressAssignment]:checked').val()== presenter.STATIC){
                          restoreIPV4fields();
                          validator.element(IPV4IPADDR);
                          validator.element(IPV4MASK);
                          validator.element(IPV4GATEWAY);
                          validator.element(DNS1);
                          validator.element(DNS2);
                          $(SUBNET_MASK_IPV4_ID).show();
                          $(NETWORK_ONE_ONE_NODE_IPV4).show();
                          $(IPV4IPADDR).attr("disabled", false);
                          $(IPV4MASK).attr("disabled", false);
                          $(IPV4GATEWAY).attr("disabled", false);
                          $(ipV4dhcpmsg).css('visibility', 'hidden');
                          $(ipV4maskdhcpmsg).css('visibility', 'hidden');
                          $(ipV4gatewaymsg).css('visibility', 'hidden');
                          $(DNS1_ID).css('visibility', 'hidden');
                          $(DNS2_ID).css('visibility', 'hidden');
                          $(DHCP_IPV4_WARNING).hide();
                          $(CLASS_IPV4_NON_DHCP_ERRORS).css('visibility','visible');
                          addHphashelp();
                          if(IPV4IPADDR.length > 0){
                              $(IPV4IPADDR).rules(ADD, REQUIRED);
                          }
                          if(IPV4MASK.length > 0){
                              $(IPV4MASK).rules(ADD, REQUIRED);
                          }
                        }
                    });
                  $(UNASSIGNIPV4).change(function(){
                        if($('input[type="radio"][name=addressAssignment]:checked').val()== presenter.UNCONFIGURE){
                              $(SUBNET_MASK_IPV4_ID).hide();
                              $(NETWORK_ONE_ONE_NODE_IPV4).hide();
                              $(PANEL_DNS).hide();
                              $(ipV4dhcpmsg).css('visibility', 'hidden');
                              $(ipV4maskdhcpmsg).css('visibility', 'hidden');
                              $(ipV4gatewaymsg).css('visibility', 'hidden');
                              $(CLASS_NETWORK_DNS).hide();
                              $(DHCP_IPV4_WARNING).hide();
                         }
                  });

                  $(DHCP_IPV6_ASSIGN).change(function(){
                      if($('input[type="radio"][name=addressAssignmentforv6]:checked').val()== presenter.DHCP){
                         if(IPV6IPADDR.length > 0){
                              $(IPV6IPADDR).rules(REMOVE, REQUIRED);
                          }
                          if(IPV6MASK.length > 0){
                              $(IPV6MASK).rules(REMOVE, REQUIRED);
                          }
                          saveIPV6fields();
                          $(SUBNET_MASK_IPV6_ID).show();
                          $(NETWORK_ONE_NODE_IPV6).show();
                          $(GATEWAY_IPV6_ID).show();
                          $(IPV6IPADDR).attr("disabled", true);
                          $(IPV6MASK).attr("disabled", true);
                          $(IPV6GATEWAY).attr("disabled", true);
                          $(ipV6dhcpmsg).css('visibility','visible');
                          $(ipV6subnetdhcpmsg).css('visibility','visible');
                          $(ipV6gatewaydhcpmsg).css('visibility','visible');
                          $(IPV6IPADDR).val('');
                          $(IPV6MASK).val('');
                          $(IPV6GATEWAY).val('');
                          $(DHCP_IPV6_WARNING).show();
                          $(DUAL_STACK_WARNING).show();
                          $(CLASS_IPV6_NON_DHCP_ERRORS).css('visibility','hidden');
                          removeipv6Hphashelp();
                          resetipv6Errors();
                        }
                    });
                    $(STATIC_IPV6_ASSIGN).change(function(){
                        if($('input[type="radio"][name=addressAssignmentforv6]:checked').val()== presenter.STATIC){
                              restoreIPV6fields();
                              $(SUBNET_MASK_IPV6_ID).show();
                              $(GATEWAY_IPV6_ID).show();
                              $(NETWORK_ONE_NODE_IPV6).show();
                              validator.element(IPV6IPADDR);
                              validator.element(IPV6MASK);
                              validator.element(IPV6GATEWAY);
                              $(IPV6IPADDR).attr("disabled", false);
                              $(IPV6MASK).attr("disabled", false);
                              $(IPV6GATEWAY).attr("disabled", false);
                              $(ipV6dhcpmsg).css('visibility','hidden');
                              $(ipV6subnetdhcpmsg).css('visibility','hidden');
                              $(ipV6gatewaydhcpmsg).css('visibility','hidden');
                              $(DHCP_IPV6_WARNING).hide();
                              $(DUAL_STACK_WARNING).show();
                              $(CLASS_IPV6_NON_DHCP_ERRORS).css('visibility','visible');
                              addipv6Hphashelp();
                              if(IPV6IPADDR.length > 0){
                                  $(IPV6IPADDR).rules(ADD, REQUIRED);
                              }
                              if(IPV6MASK.length > 0){
                                  $(IPV6MASK).rules(ADD, REQUIRED);
                              }

                          }
                      });

                    $(UNASSIGNIPV6).change(function(){
                        if($('input[type="radio"][name=addressAssignmentforv6]:checked').val()== presenter.UNCONFIGURE){
                              $(SUBNET_MASK_IPV6_ID).hide();
                              $(GATEWAY_IPV6_ID).hide();
                              $(NETWORK_ONE_NODE_IPV6).hide();
                              $(DHCP_IPV6_DISALLOWED).hide();
                              $(DHCP_IPV6_WARNING).hide();
                              $(DUAL_STACK_WARNING).hide();
                         }
                    });

                formStateView.init({
                    form : form,
                    routePattern : routePrefix + '.*',
                    autoTrack : true
                });

            };
            formStateView.on('change', function (idElem,labelElem,valueElem) {
                fieldValueChangedFlag=true;
              });
           /*
            * Set the notification div.
            */
           this.setNotifyElement = function(elm) {
               notifyElement = elm;
           };
           /**
            * Set the validator for the view.
            */
           this.setValidator = function(v) {
               validator = v;
           };

           this.getValidator = function(){
               return validator;
           };


           this.onError = function() {
               $(SPINNER).hide();
               notifyResultFlag = true;
               displayNotifications(localizer.getString('fs.settings.network.error.get.msg'),
                                    localizer.getString('fs.settings.network.error.get.res'));
           };
           /**
            * get the  instance of formstate view initialised here.
            */
           this.getFormStateViewInstance = function() {
               return formStateView;
           };
           /**
            *
            * Flag to check if any field value has changed. Used with formstateview change event
            */
           this.isFieldValueChanged = function(){
               return fieldValueChangedFlag;
           };

           this.setTotalNicCount= function(n){
               nicCnt = n ;
           };

           this.setPrimaryNetworkObj= function(e){
               primaryNetworkObj = e ;
           };
           //Set the deployment nic
           this.setAliasAssociatedNIC = function(networkObj){
               aliasAssocNICObj = networkObj ;
           };
           // check Single Nic Enabled or not
           this.setSingleNicEnabled  = function(e){
               singleNicEnabled = e;
           };

           this.getSingleNicEnabled = function() {
               return singleNicEnabled;
           };

           this.hasPostValidationsOccuredForFirstTime = function(){
               return postValidationOccuredFS;
           };

           this.getFirstTime = function(){
               return firstTimeFlag;
           };

           this.setDateTimeChangeFlag = function(flag){
               dateTimeChanged = flag;
           };
           this.setApplianceMoreView = function(obj){
               applianceMoreView = obj ;
           };

        };
        return NetworkEditViewBase;
    }());
});
