// (C) Copyright 2013 Hewlett-Packard Development Company, L.P.

define(['fs/view/settings/restore/UploadRestoreCommonView',
        'hp/view/FormStateView',
        'fs/presenter/settings/RestorePresenter',
        'fs/presenter/settings/DateTimeSetupPresenter',
        'hp/core/LinkTargetBuilder',
        'fs/view/settings/restore/FsRestoreUploadViewCustomizations',
        'jquery',
        'hp/lib/jquery.hpFileChooser',
        'hp/lib/jquery.hpProgressBar'],
function(common, FormStateView, restorePresenter) { "use strict";

    var UploadAndRestoreView = ( function() {
        
        var restoreProcess = null;
        var formStateView = null;
        
        // elements in the HTML markup in common
        var RESTORE_FORM = "#fs-settings-restore-form",
            
            // specific to restoreUnattendedPage
            
            STOP_UPLOAD_LINK = '#fs-settings-restore-stop-upload',
            CANCEL_RESTORE_LINK = '#fs-settings-restore-stop-restore';
        
        /**
         * Constructor
         */
        function UploadAndRestoreView() {
            
////////////////////////////////////////////////////////////////////////////////
/// All ordered beyond this point to make SONAR happy                        ///
////////////////////////////////////////////////////////////////////////////////
            
            function performDelayedRestore() {
                restorePresenter.switchToDelayedRestoreMode();
            }
            
            function onValidationFailure (result) {
                restorePresenter.setFileSelection(null);
                restorePresenter.recoverFromErrors();
                
            }
            
            function onStopUpload(errorInfo) {
                restorePresenter.stopFileUpload();
            }
            
            function onCancelRestore() {
                clearTimeout(restoreProcess);
                restorePresenter.cancelRestore();
            }
            
            function performUpload() {
                restorePresenter.startFileUpload();
            }
            
            function getPresenterEventHandlers () {
                var eventHandlers = {
                    uploadAndRestoreMode : performUpload,
                    uploadSuccess : performDelayedRestore,
                    uploadStopped : restorePresenter.switchToUploadMode,
                    validationFailure : onValidationFailure
                };
                return eventHandlers;
            }
            function registerEvents() {
                common.registerEvents();
                restorePresenter.registerPresenterEventHandlers(getPresenterEventHandlers());
                
                $(STOP_UPLOAD_LINK).on('click', onStopUpload);
                $(CANCEL_RESTORE_LINK).on('click', onCancelRestore);
            }
            
            function removeEvents() {
                restorePresenter.unregisterPresenterEventHandlers(getPresenterEventHandlers());
                common.removeEvents();
                
                $(STOP_UPLOAD_LINK).off('click', onStopUpload);
                $(CANCEL_RESTORE_LINK).off('click', onCancelRestore);
            }
            
            /**
             * @public
             */
            
            this.resume = function () {
                registerEvents();
                restorePresenter.switchToUploadAndRestoreModeContinued();
            };
            
            this.pause = function() {
                removeEvents();
            }
            /**
             * Initialization.
             */
            this.init = function () {
                
                formStateView = new FormStateView();
                formStateView.init({form: RESTORE_FORM, autoTrack: true});
                
                restorePresenter.init();
                restorePresenter.switchToUploadAndRestoreMode();
                
                this.resume();
            };
        }
        return new UploadAndRestoreView();
    }());
return UploadAndRestoreView;
});


