// (C) Copyright 2012-2013 Hewlett-Packard Development Company, L.P.
define(['hp/presenter/EulaPresenter','hp/core/Localizer','fs/view/common/CommonDisplayView'],
function(presenter,localizer, commonDisplayView) { "use strict";

    var SupportMoreView = (function() {

        var LABEL = "#statusLabel",
        ERROR_MSG = "#errMsg";

        function SupportMoreView () {

            function isSupportEnabledSucess(isSupportEnabled) {
                if (isSupportEnabled) {
                    $(LABEL).text(localizer.getString('fs.settings.eula.config.enabled'));
                } else {
                    $(LABEL).text(localizer.getString('fs.settings.eula.config.disabled'));
                }
            }

            function isSupportEnabledFailure(errorMessage) {
                var msg = JSON.stringify(errorMessage.message);
                $(ERROR_MSG).html(msg);
            }

            function registerEvents() {
                presenter.on("isSupportEnabledSucess", isSupportEnabledSucess);
                presenter.on("isSupportEnabledFailure", isSupportEnabledFailure);
            }

            this.resume = function() {
                presenter.checkIsSupportEnabled();
                commonDisplayView.manageDisplayInOverviewDropdown();
            };

            this.init = function() {
                registerEvents();
                presenter.checkIsSupportEnabled();
                commonDisplayView.manageDisplayInOverviewDropdown();
            };
        }
        return new SupportMoreView();
    }());
    return SupportMoreView;
});