// (C) Copyright 2012-2013 Hewlett-Packard Development Company, L.P.
define(['fs/presenter/status/StatusPresenter', 'hp/core/Localizer', 
        'hp/core/Router', 'hp/model/Session', 'hp/lib/jquery.hpProgressBar'], 
function(presenter, localizer, router, session) {"use strict";

    var StatusRestoreView = ( function() {

        var PROGRESS_BAR = '#hp-restore-progress';
        var PROGRESS_STATE = '#hp-restore-state';
  
        /**
         * @class View script for the /status/restore page
         */
        function StatusRestoreView() {
            
            /**
             * Redirect and reload to login page upon success or failure        
             */            
            function redirect() {
                router.go('/login', 'login');
            }
               
            /**
             * Function when the call to get restore status fails 
             */
            function onGetRestoreStatusFailure() {
                redirect();
            }

            /**
             * Update the restore progress bar
             */
            function updateProgressBar(restoreResource) {
                $(PROGRESS_BAR).hpProgressBar(restoreResource.percentComplete);
                var stepKey = 'fs.status.restore.' + restoreResource.progressStep;
                $(PROGRESS_STATE).text(localizer.getString(stepKey.toLowerCase()));
            }
            
            /**
             * Monitor the restore progress              
             */
            function monitorRestoreProgress() {

                presenter.monitorRestoreProgress({
                    running : function(restoreResource) {
                        updateProgressBar(restoreResource);
                    },
                    success : function(restoreResource) {
                         updateProgressBar(restoreResource);
                         redirect();
                    },
                    error : function() {
                        onGetRestoreStatusFailure();
                    }
                });
            }

            /**
             * Initialize the view
             *
             * Reset the session token so go to login page after restore
             */
            this.init = function() {
                document.title = localizer.getString('fs.status.restore.title');
                session.eraseAll(); 
                $(PROGRESS_BAR).hpProgressBar();
                $(PROGRESS_BAR).hpProgressBar(0);
                $(PROGRESS_STATE).text('');
                monitorRestoreProgress();
            };

            this.pause = function() {
                // nothing
            };

            this.resume = function() {
                this.init();
            };
        }

        return new StatusRestoreView();

    }());

    return StatusRestoreView;

});
