// (C) Copyright 2013 Hewlett-Packard Development Company, L.P.
define(['fs/presenter/users/UsersPresenter','fs/model/users/UserResource','hp/core/Notifications',
    'hp/view/MasterPaneView','hp/core/Localizer','hp/core/Router','hp/model/Session',
    'jquery','hp/lib/jquery.hpStatus'],
function(presenter, resource, notifications, MasterPaneView, localizer, router, session) { "use strict";

    var BaseUsersView = (function() {

        var TYPE = 'user',
            PAGE = '#fs-users-page',
            ROLE_LIST = '#user-role-list',
            ROLE_LIST_ITEMS = '#user-role-list li';

        /**
         * Constructor
         */
        function BaseUsersView (dataTableColumns) {

            var masterPaneView = new MasterPaneView();

            function updateRoles(){
                var roles = presenter.getRoles();
                $(ROLE_LIST_ITEMS).remove();
                var topLabel = localizer.getString('fs.users.common.all_roles');
                var topListitem = $('<li/>');
                topListitem.attr("data-id","all")
                    .text(topLabel)
                    .addClass("hp-selected");
                $(ROLE_LIST).append(topListitem);
                $.each(roles, function(index, role) {
                    if (role.roleName !== 'No_Privileges') {
                        var label = role.roleName ? role.roleName.replace(/_/, ' ') : 'noname';
                        var correctCaseRole = '';
                        var splitRole = role.roleName.replace(/_/, ' ').split(' ');
                        $.each(splitRole, function(key, word) {
                            if(key !=0){
                                correctCaseRole = correctCaseRole +' '+ word.toLowerCase();
                            }else{
                                correctCaseRole = correctCaseRole + word;
                            }
                        });
                        var listitem = $('<li/>');
                        listitem.attr("data-id",label.toLowerCase())
                            .text( correctCaseRole);
                        $(ROLE_LIST).append(listitem);
                    }
                });
            }

            this.init = function() {
                presenter.init();
                masterPaneView.init({
                    routePrefix: '/' + TYPE,
                    resource: resource,
                    page: $(PAGE),
                    addLink: presenter.getAddLink(),
                    dataTableOptions : {
                        aaSorting : [ [ 0, "asc" ] ],
                        aoColumns : dataTableColumns
                    }
                });
                presenter.on('notification', function(msg) {
                    notifications.show(msg.text, msg.type);
                });
                presenter.on('rolesChanged', updateRoles);
            };

            // public
            this.pause = function() {
                presenter.off('rolesChanged', updateRoles);
                masterPaneView.pause();
            };

            // public
            this.resume = function() {
                var directoryType = session.getProperty("directorytype");
                if (directoryType != null && dataTableColumns.length == directoryType) {
                    masterPaneView.resume();
                } else {
                    // REASON FOR reload()- on init() MasterPaneView is initialised with
                    // dataTableOptions containing 2 col's.
                    // But when an Active Directory is configured. It doesn't show Up 4cols.
                    // Because MasterPaneView is already initialised with 2 col's.
                    // So on reload or refresh, it re-initialises MasterPaneView to show 4col's.
                    window.location.replace('#/user/show');
                    window.location.reload(true);
                }
                presenter.on('rolesChanged', updateRoles);
            };

            this.init();
        }

        return BaseUsersView;
    }());

    return BaseUsersView;
});
