// (C) Copyright 2011-2014 Hewlett-Packard Development Company, L.P.
define([ 'hp/core/Localizer','jquery', 'hp/lib/jquery.hpStatus'],
function( localizer) { "use strict";

    var UsersViewUtil= (function() {

        function UsersViewUtil() {
            this.MIN_NAME_LENGTH = 0;
            this.MAX_NAME_LENGTH = 39;
            this.MIN_PASSWORD_LENGTH = 8;
            this.MAX_PASSWORD_LENGTH = 40;
            this.MAX_EMAIL_LENGTH = 64;
            this.MAX_NUMBER_LENGTH = 25;
            this.MIN_NUMBER_LENGTH = 0;
            this.PRODUCTCONFIG_PREFIX = "userconfig.";

            this.USERNAME_MINLENGTH = this.PRODUCTCONFIG_PREFIX + "username.minlength";
            this.FULLNAME_MINLENGTH = this.PRODUCTCONFIG_PREFIX + "fullname.minlength";
            this.PASSWORD_MINLENGTH = this.PRODUCTCONFIG_PREFIX + "password.minlength";
            this.MOBILE_MINLENGTH = this.PRODUCTCONFIG_PREFIX + "mobilephone.minlength";
            this.OFFICE_MINLENGTH = this.PRODUCTCONFIG_PREFIX + "officephone.minlength";

            this.USERNAME_MAXLENGTH = this.PRODUCTCONFIG_PREFIX + "username.maxlength";
            this.FULLNAME_MAXLENGTH = this.PRODUCTCONFIG_PREFIX + "fullname.maxlength";
            this.PASSWORD_MAXLENGTH = this.PRODUCTCONFIG_PREFIX + "password.maxlength";
            this.EMAIL_MAXLENGTH = this.PRODUCTCONFIG_PREFIX + "email.maxlength";
            this.MOBILE_MAXLENGTH = this.PRODUCTCONFIG_PREFIX + "mobilephone.maxlength";
            this.OFFICE_MAXLENGTH = this.PRODUCTCONFIG_PREFIX + "officephone.maxlength";

            this.USERNAME_VALID = this.PRODUCTCONFIG_PREFIX + "username.valid";
            this.FULLNAME_VALID = this.PRODUCTCONFIG_PREFIX + "fullname.valid";
            this.PASSWORD_VALID = this.PRODUCTCONFIG_PREFIX + "password.valid";
            this.MOBILE_VALID = this.PRODUCTCONFIG_PREFIX + "mobilephone.valid";
            this.OFFICE_VALID = this.PRODUCTCONFIG_PREFIX + "officephone.valid";

            this.FULLNAME_REQUIRED = this.PRODUCTCONFIG_PREFIX + "fullname.required";
            this.EMAIL_REQUIRED = this.PRODUCTCONFIG_PREFIX + "email.required";
            this.MOBILE_REQUIRED = this.PRODUCTCONFIG_PREFIX + "mobilephone.required";
            this.OFFICE_REQUIRED = this.PRODUCTCONFIG_PREFIX + "officephone.required";

            this.USERNAME_ERRORMSG = this.PRODUCTCONFIG_PREFIX + "username.valid.errormessage";
            this.FULLNAME_ERRORMSG = this.PRODUCTCONFIG_PREFIX + "fullname.valid.errormessage";
            this.PASSWORD_ERRORMSG = this.PRODUCTCONFIG_PREFIX + "password.valid.errormessage";
            this.EMAIL_ERRORMSG = this.PRODUCTCONFIG_PREFIX + "email.valid.errormessage";
            this.MOBILE_ERRORMSG = this.PRODUCTCONFIG_PREFIX + "mobilephone.valid.errormessage";
            this.OFFICE_ERRORMSG = this.PRODUCTCONFIG_PREFIX + "officephone.valid.errormessage";

            this.ROLES_TEMPLATE = this.PRODUCTCONFIG_PREFIX + "roles.template";
            this.LDAP_CREDENTIAL_SAVE = "settings.security.ldap.credential.save";

            this.configs = {};

            this.setProductConfigs = function(productConfigs){
                    this.configs = productConfigs;
            };

            this.isPropertyDefined = function(property){
                if(this.configs ===undefined || property === undefined){
                    return false;
                }else{
                    return true;
                }
            };

           function returnCorrectValueType(val){
               if (val === "true"){
                   return true;
               }else if (val === "false"){
                   return false;
               }
             return val;
           }

           this.getPropertyValue = function(val, defaultVal){
               return (this.isPropertyDefined(val)? returnCorrectValueType(val) : defaultVal);
           };

           this.checkRequired = function(FULLNAME_OPTIONAL,EMAIL_OPTIONAL,MOBILEPHONE_OPTIONAL,OFFICEPHONE_OPTIONAL){
               if( this.getPropertyValue(returnCorrectValueType(this.configs[this.FULLNAME_REQUIRED]), false)){
                   $(FULLNAME_OPTIONAL).hide();
               }else{
                   $(FULLNAME_OPTIONAL).show();
               }

               if( this.getPropertyValue(returnCorrectValueType(this.configs[this.EMAIL_REQUIRED]),false )){
                       $(EMAIL_OPTIONAL).hide();
               }else{
                   $(EMAIL_OPTIONAL).show();
               }

               if( this.getPropertyValue(returnCorrectValueType(this.configs[this.MOBILE_REQUIRED]),false )){
                   $(MOBILEPHONE_OPTIONAL).hide();
               }else{
                   $(MOBILEPHONE_OPTIONAL).show();
               }

               if( this.isPropertyDefined(returnCorrectValueType(this.configs[this.OFFICE_REQUIRED]),false )){
                   $(OFFICEPHONE_OPTIONAL).hide();
               }else{
                   $(OFFICEPHONE_OPTIONAL).show();
               }
           };

           this.getLocalizedRoleDisplay = function (role){
               var returnVal = role.replace(/_/, ' ');
               var key = role.toLowerCase().replace(/ /,'_');
               if (localizer.hasValueForKey('fs.users.common.'+ key)){
                   returnVal = localizer.getString('fs.users.common.'+ key);
               }
               return returnVal;
           };
        }

        return new UsersViewUtil();
    }());

    return UsersViewUtil;
});
