// (C) Copyright 2012-2014 Hewlett-Packard Development Company, L.P.
define(['./upload-ja', './settings-ja', './help-ja', './notify-ja', './datepicker-ja', './timepicker-ja'],
function (upload, settings, help, notify, datepicker, timepicker) {
"use strict";
    return {
        upload : upload,
        settings : settings,
        help : help,
        notify : notify,
        datepicker : datepicker,
        timepicker : timepicker,

        loading : "ロード中...",
        // TODO: remove styling and use CSS
        rest_error_fmt : "<b>{0}</b><BR>{1}<BR><b>解決方法:</b> {2}",

        //TODO consider moving the CIC specific stuff out of core.

        login : {
            "user" : "ユーザー",
            "password" : "パスワード",
            "loginButton" : "ログイン",
            "domain" : "ドメイン",
            "title" : "アプライアンス"
        },
        menu : {
            settings : "設定",
            search : "検索",
            map : "マップ",
            activity : "アクティビティ"
        },
        shell : {
            banner : {
                title : "一覧",
                session : {
                    control : {
                        tooltip : "セッション"
                    },
                    duration : "ログイン ",
                    logout : "ログアウト"
                },
                local : "ローカル"
            },
            unsupportedBrowser : "お使いのブラウザーはサポートされていません。Chrome、Safari、Firefox、Opera、Internet Explorer バージョン8 または、それ以降の安定しているバージョンの使用を検討してください。"
        },
        dataTables : {
            oLanguage : {
                sProcessing : "処理中...",
                sLengthMenu : "_MENU_ エントリを表示",
                sZeroRecords : "一致するレコードはありません",
                sEmptyTable : "アイテムなし",
                sLoadingRecords : "ロード中...",
                sInfo : "_TOTAL_ エントリから_START_ から _END_ まで表示",
                sInfoEmpty : "0エントリの0から0までを表示",
                sInfoFiltered : "(_MAX_ トータルエントリーからフィルターされました)",
                sInfoPostFix : "",
                sSearch : "検索:",
                sUrl : "",
                oPaginate : {
                    sFirst : "最初",
                    sPrevious : "戻る",
                    sNext : "次へ",
                    sLast : "最後"
                },
                fnInfoCallback : null
            }
        },
        master : {
            header : {
                all : "すべて",
                referenced : "参照元",
                searched : "検索",
                filtered : "フィルター済み"
            },
            filters : {
                title : "フィルター",
                filter : "フィルター",
                noFilters : "フィルターなし",
                error : "エラー",
                warning : "警告",
                recentlyAdded : "直近で追加",
                recentlyChanged : "直近で変更",
                resetAll : "リセット",
                date : {
                    specific : "特定の日付の範囲"
                },
                matchesCount : "{1}中{0}一致", // TODO: localize
                matchCount : "{0}中1一致", // TODO: localize
                referrerLabel : "次に関連：" // TODO: localize
            },
            loadingItems : 'ロード中 {0} ...',
            noItems : '{0}なし',
            noMatches : '一致するものがありません',
            showMore : 'さらに表示',
            top: '先頭',
            selectAll : 'すべてを選択'
        },
        details : {
            view : "表示",
            actions : "アクション",
            edit : "編集",
            close : "閉じる",
            cancel : "キャンセル",
            reset : "リセット",
            add : "追加",
            addAgain : "追加 +",
            addAgainTip : "追加および他を追加",
            create : "作成",
            createAgain : "作成 +",
            createAgainTip : "作成および他を作成",
            remove : "削除",
            removeAgain : "削除 +",
            select : "選択",
            save : "保存",
            update : "更新",
            "delete" : "削除",
            ok : "OK",
            apply : "適用",
            more : "さらに",
            enable: "有効",
            disable: "無効",
            addAll : "すべてを追加",
            addSelected : "選択されたものを追加",
            removeAll : "すべてを削除",
            removedSelected : "選択されたものを削除",
            overview : "概要",
            backToOverview : "概要に戻る"

        },
        deleteConfirm : {
            title : "{0}を削除",
            dependencyHeader : "{0}アイテムは {1}に依存してます",
            prompt : "削除して続行しますか?",
            ok : "削除します"
        },
        "delete" : {
            title : "警告: {0} {1}は、現在使用中です。",
            accordian_button : "{1}を使用した{0}サーバープロファイル",
            accordian_button_singular : "{0}を使用したサーバープロファイル",
            message : "{0} {1}を削除しますか?",
            name : "名前",
            description : "説明",
            delete_button : "削除します",
            cancel_button : "キャンセル"
        },
        formState : {
            changed : "変更済み: {0} を \"{1}\"",
            changed_label_only : "変更済み: {0}",
            unchanged : "リセット: {0}",
            checked : "チェック済み: {0}",
            unchecked : "未チェック: {0}",
            checkedValue: "チェック済み",
            uncheckedValue: "未チェック",
            navigateAway : {
                warning : "警告: 変更は失われます。",
                prompt : "新しいページに進みますか?",
                proceed : "進みます",
                cancel : "キャンセル"
            }
        },
        associationEdit : {
            selected : "{0}が選択されました",
            added : "{0}が追加されました",
            removed : "{0}が削除されました"
        },
        common : {
            close: "閉じる",
            yes : "はい",
            no : "いいえ",
            notset : "未セット",
            none : "なし",
            cancel : "キャンセル"
        },
        validator : {
            messages : {
                required : "このフィールドは必須です。",
                number : "有効な数値を入力してください。",
                digits : "すべての数値を入力してください(数字のみ)。",
                range : "{0}から{1}の間の値を入力してください。",
                max : "{0}と同じか、それ以下の値を入力してください。",
                min : "{0}と同じか、それ以上の値を入力してください。",
                name : "名前には印刷可能な文字だけを使用することができます。また先頭に空白を指定しないでください。",
                remote: "このフィールドを修正します。",
				email: "有効なメールアドレスを入力してください。",
				url: "有効なURLを入力してください。",
				date: "有効な日付を入力してください。",
				dateISO: "有効な日付(ISO)を入力してください。",
				equalTo: "同じ値をもう一度入力してください。",
				maxlength: "{0}文字以内で入力してください。",
				minlength: "{0}文字以上を入力してください。",
				rangelength: "{0}文字と{1}文字の間の長さの値を入力してください。"
            }
        },
        noDetails : {
            header : "リクエストされたアイテムを配置することができませんでした。",
            detail : "リクエストされたアイテムは存在しません。他のユーザーが、このアイテムを削除した可能性があります。このページを再読み込みするか、別のアイテムを選択してください。",
            specificErrorDetails : "詳細"
        },
        noItems : {
            header : "{0}を収集できませんでした。",
            detail : "アイテムのリストを取得中に問題が発生しました。このページを再読み込みしてもう一度試してください。"
        },
        noPage : {
            header : "リクエストされたページが見つかりません。",
            detail : "リクエストされたページまたは参照項目が存在しないか、URLが間違って入力されています。前のページでリンクをクリックしてこのページに到達した場合は、そのページに戻り、再読み込みし、再度試してください。手動でURLを入力またはブックマークを使用した場合は、それが正確で有効であるかをチェックしてください。"
        },
        notAuthorized : {
            header : "権限がありません。",
            detail_user : "{0}はこのページを参照する権限がありません。",
            detail : "このページを参照する権限がありません。"
        },
        noRoles : {
            header : "役割がありません。",
            detail : "このシステム上でいかなる管理の役割も持っていません。役割については、セキュリティ管理者に問い合わせてください。"
        },
        noSession : {
            header : "ログインセッションは、失われました。"
        },

        measurements : {
            "millimeters" : "{0} mm",
            "meters" : "{0} m",
            "celsius" : "{0} \u00B0C",
            "fahrenheit" : "{0} \u00B0F",
            "usMeasurement" : "{0}' {1}\"",
            "dimensions" : "{0}  x {1}",
            units : {
                "meter" : "m",
                "millimeter" : "mm",
                "feet" : "ft",
                "inches" : "in"
            }
        },
        units : {
            "meter" : "m",
            "millimeter" : "mm",
            "feet" : "ft",
            "inches" : "in",
            "bytes" : "B",
            "kilobytes" : "KB",
            "megabytes" : "MB",
            "gigabytes" : "GB",
            "terrabytes" : "TB",
            "petabytes" : "PB"
        },
        date : {
            absoluteFormat : "yyyy/M/d h:mm:ss a",
            today : "今日 {0}",
            yesterday : "昨日 {0}",
            tomorrow : "明日 {0}",
            todayFormat : "h:mm:ss a",
            yesterdayFormat : "h:mm:ss a",
            tomorrowFormat : "h:mm:ss a",
            thisYearFormat : "yyyy/M/d h:mm:ss a",
            priorYearFormat : "yyyy/M/d h:mm:ss a"
        },
        duration : {
            dh: "{0}日{1}時間", // days and hours
            hm: "{0}時間{1}分", // hours and minutes
            ms: "{0}分{1}秒", // minutes and seconds
            s: "{0}秒",      // seconds
            m: "{0}分",      // minutes
            h: "{0}時間",      // hours
            d: "{0}日",      // days
            y: "{0}年",      // years
            today: "今日"  // within today
        },
        timeago : {
            prefixAgo: null,
            prefixFromNow: null,
            suffixAgo: "前",
            suffixFromNow: "今から",
            seconds: "< 1 分",
            minute: "1 分",
            minutes: "%d 分",
            hour: "1 時間",
            hours: "%d 時間",
            day: "1 日",
            days: "%d 日",
            month: "1 月",
            months: "%d 日",
            year: "1 年",
            years: "%d 年",
            numbers: []
        },
        sort : {
            ascending : "昇順",
            descending : "降順"
        },
        map: {
            title: "マップ"
        },
        related: {
            title: "関連のある"
        },
        file: {
            upload: {
                control: {
                    tooltip: 'アップロード',
                    doNotExitBrowser: 'ファイルのアップロードが進行中の時には、ウィンドウを閉じたり、ログアウトまたはブラウザーを再読み込みしないでください。'
                },
                flyout: {
                    upload: "アップロード",
                    elapsed: "{0} 経過",
                    remaining: "{0} 残り"
                },
                cancel: {
                    confirmTitle: "アップロードを停止",
                    confirmQuestion: "ファイル{0}のアップロードを停止しますか?",
                    confirmNote: "注記:これまでに転送されたデータは破棄されます。",
                    yesButton: "アップロードを停止します",
                    canceled: "アップロードがキャンセルされました"
                },
                error : {
                    emptyResponse : "空の応答",
                    accessDenied : "アップロードが失敗しましたが、詳細な応答を取得することできませんでした: {0}。",
                    noDrop: "このブラウザーは、ファイルのドラッグアンドドロップをサポートしていません。"
                }
            },
            chooser : {
                label: "ファイル",
                dragAndDrop: "アップロードするために、ファイルをドラッグアンドドロップするか、選択してください。",
                browse_only: "アップロードするファイルを選択してください。",
                dragOverText: "ここにファイルをドロップしてください",
                oneFileOnly: "アップロードするファイルを、一つずつ選択してください。",
                dropOneFileOnly: "一つのファイルのみをドロップしてください。",
                invalidSelection: "ファイルが必要です。",
                noDragDrop: "このブラウザーでは、ドラッグアンドドロップはサポートされていません。",
                browse: "一覧",
                disabled: "コンソール上で実行している場合、ファイルのアップロードは無効になっています。",
                disclaimerMessage: "お使いのブラウザーのアップロードは{0}GBに制限されています。大きなファイルをアップロードするにはFireFoxまたはChromeを使用してください。"
            }
        },
        connectionError : "{0}との通信に問題が発生しました。もう一度やり直してください。",
        dashboard: {
            alerts : {
                label : {
                    single: 'アラート',
                    plural: 'アラート'
                }
            }
        }
    };
});
