﻿// (C) Copyright 2012-2014 Hewlett-Packard Development Company, L.P.
define(['./upload-zh', './settings-zh', './help-zh', './notify-zh', './datepicker-zh', './timepicker-zh'],
function (upload, settings, help, notify, datepicker, timepicker) {
"use strict";
    return {
        upload : upload,
        settings : settings,
        help : help,
        notify : notify,
        datepicker : datepicker,
        timepicker : timepicker,
        
       //  Do not convert above 4 properties to Chinese 
        loading : "正在加载...",
        // TODO: remove styling and use CSS
        rest_error_fmt : "<b>{0}</b><BR>{1}<BR><b>解决办法:</b>{2}",

        //TODO consider moving the CIC specific stuff out of core.

        login : {
            "user" : "用户",
            "password" : "密码",
            "loginButton" : "登录",
            "domain" : "域",
            "title" : "设备"
        },
        menu : {
            settings : "设置",
            search : "搜索",
            map : "映射",
            activity : "活动"
        },
        shell : {
            banner : {
                title : "浏览",
                session : {
                    control : {
                        tooltip : "会话"
                    },
                    duration : "已登录",
                    logout : "注销"
                },
                local : "本地"
            },
            unsupportedBrowser : "不支持您正在使用的 Web 浏览器。请考虑使用最新(稳定)版本的 Chrome、Safari、Firefox、Opera 或 Internet Explorer 版本 8 或更高版本。"
        },
        dataTables : {
            oLanguage : {
                sProcessing : "正在处理...",
                sLengthMenu : "显示 _MENU_ 项",
                sZeroRecords : "未找到任何匹配的记录",
                sEmptyTable : "没有任何项",
                sLoadingRecords : "正在加载...",
                sInfo : "正在显示第 _START_ 至 _END_ 项，共 _TOTAL_ 项",
                sInfoEmpty : "正在显示第 0 至 0 项，共 0 项",
                sInfoFiltered : "(从总计 _MAX_ 项中筛选而得)",
                sInfoPostFix : "",
                sSearch : "搜索:",
                sUrl : "",
                oPaginate : {
                    sFirst : "第一个",
                    sPrevious : "上一个",
                    sNext : "下一个",
                    sLast : "最后一个"
                },
                fnInfoCallback : null
            }
        },
        master : {
            header : {
                all : "全部",
                referenced : "引用",
                searched : "搜索",
                filtered : "筛选"
            },
            filters : {
                title : "筛选器",
                filter : "过滤器",
                noFilters : "无筛选器",
                error : "错误",
                warning : "警告",
                recentlyAdded : "最近添加",
                recentlyChanged : "最近更改",
                resetAll : "重置",
                date : {
                    specific : "具体日期范围"
                },
                matchesCount : "{0} 个匹配，共 {1} 个",
                matchCount : "1 个匹配，共 {0} 个",
                referrerLabel : "相关"
            },
            loadingItems : '正在加载 {0} ...',
            noItems : '无 {0}',
            noMatches : '没有匹配项',
            showMore : '加载更多',
            top: '顶部',
            selectAll : '全选'
        },
        details : {
            view : "视图",
            actions : "操作",
            edit : "编辑",
            close : "关闭",
            cancel : "取消",
            reset : "重置",
            add : "添加",
            addAgain : "添加 +",
            addAgainTip : "添加和添加另一个",
            create : "创建",
            createAgain : "创建 +",
            createAgainTip : "创建和创建另一个",
            save : "保存",
            update : "更新",
            "delete" : "删除",
            ok : "正常",
            apply : "应用",
            more : "更多",
            enable: "启用",
            disable: "禁用",
            addAll : "全部添加",
            addSelected : "添加所选项",
            removeAll : "全部删除",
            removedSelected : "删除所选项",
            overview : "概述",
            backToOverview : "返回概述"

        },
        deleteConfirm : {
            title : "删除 {0}",
            dependencyHeader : "{0} 项依赖于 {1}",
            prompt : "是否继续删除?",
            ok : "是，删除"
        },
        "delete" : {
            title : "警告:当前正在使用 {0} {1}。",
            accordian_button : "{0} 个服务器配置文件正在使用 {1}",
            accordian_button_singular : "1 个服务器配置文件正在使用 {0}",
            message : "是否删除 {0} {1}?",
            name : "名称",
            description : "说明",
            delete_button : "是，删除",
            cancel_button : "取消"
        },
        formState : {
            changed : "已更改:{0} 至 \"{1}\"",
            changed_label_only : "已更改:{0}",
            unchanged : "重置:{0}",
            checked : "已选中:{0}",
            unchecked : "已取消选中:{0}",
            checkedValue: "已选中",
            uncheckedValue: "取消选中",
            navigateAway : {
                warning : "警告:您的更改将丢失。",
                prompt : "是否前往新页面?",
                proceed : "是，前往",
                cancel : "取消"
            }
        },
        associationAdd : {
            selected : "已选择 {0} 项",
            added : "添加了 {0} 个"
        },
        common : {
            close: "关闭",
            yes : "是",
            no : "否",
            notset : "未设置",
            none : "无",
            cancel : "取消"
        },
        validator : {
            messages : {
                required : "此字段为必填字段。",
                number : "请输入有效数字。",
                digits : "输入整数(仅数字)。",
                range : "输入一个介于 {0} 和 {1} 之间的值。",
                max : "请输入小于或等于 {0} 的值。",
                min : "请输入大于或等于 {0} 的值。",
                name : "名称只能包含可打印字符，并且不能包括前导空白。",
                remote: "Fix this field.",
				email: "Enter a valid email address.",
				url: "Enter a valid URL.",
				date: "Enter a valid date.",
				dateISO: "Enter a valid date (ISO).",
				equalTo: "Enter the same value again.",
				maxlength: "Enter no more than {0} characters.",
				minlength: "Enter at least {0} characters.",
				rangelength: "Enter a value between {0} and {1} characters long."
            }
        },
        noDetails : {
            header : "找不到所请求的项。",
            detail : "所请求的项不存在。可能其他用户已删除此项。请刷新此页或选择其它项。",
            specificErrorDetails : "详细信息"               
        },
        noItems : {
            header : "无法检索 {0}。",
            detail : "获取项列表时有问题。请尝试刷新此页。"
        },
        noPage : {
            header : "找不到所请求的页。",
            detail : "所请求的页或引用项不存在或输入的 URL 不正确。如果通过单击上一页中的链接访问此页，则返回上一页，刷新它并重试。如果手动输入 URL 或使用书签，则检查其是否准确和有效。"
        },
        notAuthorized : {
            header : "未授权。",
            detail_user : "未授权 {0} 查看此页。",
            detail : "未授权您查看此页。"
        },
        noRoles : {
            header : "无角色。",
            detail : "您在此系统上没有任何管理角色。请与安全管理员联系了解您的角色。"
        },
        noSession : {
            header : "已丢失登录会话。"
        },

        measurements : {
            "millimeters" : "{0} 毫米",
            "meters" : "{0} 米",
            "celsius" : "{0} \u00B0C",
            "fahrenheit" : "{0} \u00B0F",
            "usMeasurement" : "{0}' {1}\"",
            "dimensions" : "{0}  x {1}",
            units : {
                "meter" : "m",
                "millimeter" : "毫米",
                "feet" : "ft",
                "inches" : "in"
            }
        },
        units : {
            "meter" : "m",
            "millimeter" : "毫米",
            "feet" : "ft",
            "inches" : "in",
            "bytes" : "B",
            "kilobytes" : "KB",
            "megabytes" : "MB",
            "gigabytes" : "GB",
            "terrabytes" : "TB",
            "petabytes" : "PB"
        },
        date : {
            absoluteFormat : "M/d/yy h:mm:ss a",
            today : "今天 {0}",
            yesterday : "昨天 {0}",
            tomorrow : "明天 {0}",
            todayFormat : "h:mm:ss a",
            yesterdayFormat : "h:mm:ss a",
            tomorrowFormat : "h:mm:ss a",
            thisYearFormat : "MMM d h:mm:ss a",
            priorYearFormat : "M/d/yy h:mm:ss a"
        },
        duration : {
            dh: "{0}d{1}h", // days and hours
            hm: "{0}h{1}m", // hours and minutes
            ms: "{0}m{1}s", // minutes and seconds
            s: "{0}s",      // seconds
            m: "{0}m",      // minutes
            h: "{0}h",      // hours
            d: "{0}d",      // days
            y: "{0}y",      // years
            today: "今天"  // within today
        },
        timeago : {
            prefixAgo: null,
            prefixFromNow: null,
            suffixAgo: "以前",
            suffixFromNow: "从现在起",
            seconds: "1 分钟内",
            minute: "1 分钟",
            minutes: "%d 分钟",
            hour: "1 小时",
            hours: "%d 小时",
            day: "1 天",
            days: "%d 天",
            month: "1 个月",
            months: "%d 个月",
            year: "1 年",
            years: "%d 年",
            numbers: []
        },
        sort : {
            ascending : "升序",
            descending : "降序"
        },
        map: {
            title: "映射"
        },
        related: {
            title: "相关"
        },
        file: {
            upload: {
                control: {
                    tooltip: '上载',
                    doNotExitBrowser: '正在上载文件时请勿关闭窗口、注销或重新加载浏览器。'
                },
                flyout: {
                    upload: "上载",
                    elapsed: "已用 {0}",
                    remaining: "剩余 {0}"
                },
                cancel: {
                    confirmTitle: "停止上载",
                    confirmQuestion: "是否停止上载文件 {0}?",
                    confirmNote: "注意:将丢弃迄今为止传输的任何数据。",
                    yesButton: "是，停止上载",
                    canceled: "上载已取消"
                },
                error : {
                    emptyResponse : "响应为空",
                    accessDenied : "上载失败，但无法获得响应详细信息:{0}.",
                    noDrop: "此浏览器不支持拖放文件。"
                }
            },
            chooser : {
                label: "文件",
                dragAndDrop: "拖放文件或选择文件进行上载。",
                browse_only: "选择要上载的文件。",
                dragOverText: "将文件拖至此处",
                oneFileOnly: "一次选择一个文件进行上载。",
                dropOneFileOnly: "仅拖动一个文件。",
                invalidSelection: "必须选择文件。",
                noDragDrop: "此浏览器不支持拖放。",
                browse: "浏览",
                disabled: "在控制台上运行时禁止上载文件。",
                disclaimerMessage: "您的浏览器上载仅限于 {0}GB。要上载更大的文件，请使用 Firefox 或 Chrome。"
            }
        },
        connectionError : "遇到了与 {0} 的通信问题。重试。",
        dashboard: {
            alerts : {
                label : {
                    single: '警报',
                    plural: '警报'
                }
            }
        }
    };
});
