// (C) Copyright 2014 Hewlett-Packard Development Company, L.P.
$(document).ready(function () {
    
    var ref;
    
    function onSpecificationHeaderClick(ev) {
        if ($(ev.currentTarget).parent().hasClass("hp-collapsed")) {
            $(ev.currentTarget).parent().removeClass('hp-collapsed');
            $(ev.currentTarget).parent().trigger('expand');
        } else {
            $(ev.currentTarget).parent().addClass('hp-collapsed');
            $(ev.currentTarget).parent().trigger('collapse');
        } 
    }
    
    function onPageLoaded() {
        var specificationElem = $('.hp-api-specification');
        specificationElem.addClass('hp-collapsible hp-collapsed');
      
        $.each(specificationElem, function(index, specificationElem) {
            var description = $('> div > div.hp-description', specificationElem);
            if (description.outerHeight() > 50) {
                  description.parents('.hp-api-specification').first().
                      addClass('hp-truncated-description');
            }
        });
        
        // scroll to any 'ref'
        if (ref) {
            var element = $('[data-ref="' + encodeURIComponent(ref) + '"]');
            if (element.length > 0) {
                var collapsers = element.parents('.hp-collapsible').
                    addBack('.hp-collapsible');
                $('> h2:first-child, > h3:first-child', collapsers).trigger('click');
                var content = $('#hp-doc-content');
                content.scrollTop(element.offset().top - content.offset().top);
            }
            ref = null;
        }
    }
    
    function parseQuery(query) {
        var paramList = query.split('&');
        var vars = {};
        var param, name, value;
        
        for (var i = 0; i < paramList.length; i++) {
            param = paramList[i].split('=');
            name = decodeURIComponent(param[0]);
            value = decodeURIComponent(param[1]);
            if (name.slice(-2) === '[]') {
                // array
                name = name.slice(0, -2);
                if (! vars[name]) {
                    vars[name] = [];
                }
                vars[name].push(value);
            } else {
                vars[name] = value;
            }
        }
        return vars;
    }
    
    function onHashChange() {
        var hash = location.href.split("#")[1] || "";
        if (hash) {
            var parts = hash.split('?');
            var path = parts[0];
            var query = parts[1];
            
            if (query) {
                var params = parseQuery(query);
                ref = params['ref'];
            }
            
            $('#hp-doc-content').load(path, onPageLoaded);
            $('#hp-doc-index li').removeClass('hp-selected');
            $('#hp-doc-index a[href="#' + path + '"]').parents('li').first().
                addClass('hp-selected');
        }
    }
    
    // load index
    var index = $('#hp-doc').attr('data-index');
    $('#hp-doc-index').load(index, onHashChange);
    
    // track location hash
    $(window).on('hashchange', onHashChange);
    //onHashChange();
    
    // listen for clicking expandable elements
    $('body').on('click',
        '.hp-api-specification > h2:first-child, .hp-api-specification > h3:first-child',
        onSpecificationHeaderClick);
});
