// (C) Copyright 2011-2013 Hewlett-Packard Development Company, L.P.

define(['hp/core/Style', 'jquery', 'lib/excanvas', 'hp/lib/jquery.hpStatus'],
function(style) { "use strict";
  
    var GraphicMoonshot = (function() {
      
        /**
         * Constructor
         */
        function GraphicMoonshot() {
          
            var container = null;
            var scrollContext = null;
            
            var resizeTimer = null;
            
            // LAYOUT functions
            
            function resetSmall() {
                if (scrollContext && scrollContext.length > 0) {
                    container.css('visibility', 'hidden');
                    container.removeClass('hp-small');
                    if (scrollContext.width() < container.width() ||
                        scrollContext.height() < container.height()) {
                        container.addClass('hp-small');
                    }
                    container.css('visibility', '');
                }
            }
            
            function layout() {
                resetSmall();
            }
            
            function reset() {
                layout();
            }
            
            function onResize(event) {
                clearTimeout(resizeTimer);
                resizeTimer = setTimeout(function () {
                    reset(false);
                }, 50);
            }
            
            function registerListeners() {
                $(window).on('resize', onResize);
                container.parents('.hp-page').on('relayout', reset);
            }
            
            function unregisterListeners() {
                $(window).off('resize', onResize);
                container.parents('.hp-page').off('relayout', reset);
            }
            
            /**
             * @public
             */
            this.init = function(containerArg, scrollContextArg) {
                container = $(containerArg);
                scrollContext = $(scrollContextArg);
                $('.hp-status', container).hpStatus();
                
                registerListeners();
                reset();
            };
            
            this.pause = function () {
                unregisterListeners();
            };
            
            this.resume = function () {
                registerListeners();
                reset();
            };
            
            this.reset = reset;
        }

        return GraphicMoonshot;
    }());
    
    return GraphicMoonshot;
});
