// (C) Copyright 2013 Hewlett-Packard Development Company, L.P.

define(['hp/core/Style', 'jquery', 'lib/excanvas'],
function(style) { "use strict";
  
    var GraphicSwitch = (function() {
      
        /**
         * Constructor
         */
        function GraphicSwitch() {
          
            var container = null;
            
            function onResize(event) {
                container.toggleClass('hp-small', $(window).width() < 800);
            }
            
            /**
             * @public
             */
            this.pause = function () {
                $(window).off('resize', onResize);
            };
            
            this.resume = function () {
                $(window).on('resize', onResize);
            };

            this.init = function(containerArg) {
                container = $(containerArg);
                onResize();
                this.resume();
            };
            
        }
        return GraphicSwitch;
    }());
    
    return GraphicSwitch;
});
