// (C) Copyright 2012 Hewlett-Packard Development Company, L.P.
/*!
 * jQuery dataTables ext
 *
 * Adds extensions for data tables.
 */
define(['jquery'], function() {
(function($) {
         /*
		 * alphanumeric sorting
		 * converts value like d10 to d00000010 and than does string comparison
		 */
		$.fn.dataTableExt.oSort['string-alphanumeric-asc'] = function ( a, b ) {
			var r = new RegExp("([^\\d]*)(\\d*)");
			var match = r.exec(a);
			var s = "0000000" + match[2];
			var x = match[1] + s.substr(s.length-8);
			match = r.exec(b);
			s = "0000000" + match[2];
			var y = match[1] + s.substr(s.length-8);
			return ((x < y) ? -1 : ((x > y) ? 1 : 0));
		};
		
		$.fn.dataTableExt.oSort['string-alphanumeric-desc'] = function ( a, b ) {
			var r = new RegExp("([^\\d]*)(\\d*)");
			var match = r.exec(a);
			var s = "0000000" + match[2];
			var x = match[1] + s.substr(s.length-8);
			match = r.exec(b);
			s = "0000000" + match[2];
			var y = match[1] + s.substr(s.length-8);
			return ((x < y) ? 1 : ((x > y) ? -1 : 0));
		};
})(jQuery);
});


