// (C) Copyright 2012-2013 Hewlett-Packard Development Company, L.P.

define(['hp/core/Style', 'jquery', 'lib/jquery.flot.selection',
    'lib/jquery.flot.fillbetween', 'lib/jquery.flot.time'],
function(style) {
    (function($) {
        // jQuery plugin definition
        
        $.hpPlot = function(elem, data, extraOptions) {
          
            var options = {
                series: {
                    lines: { show: true, lineWidth: 5 },
                    points: { show: false},
                    shadowSize: 0
                },
                colors: style.graphColors(),
                grid: {
                    borderWidth: 1,
                    borderColor: style.plotGuideColor()
                },
                legend: {
                    show: false
                },
                xaxis: {
                    tickLength: 0
                }
            };
            
            $.extend(true, options, extraOptions);
            
            var result = $.plot(elem, data, options);
            
            // massage inline CSS so we can control with stylsheets
            $('.tickLabels, .tickLabels .xAxis, .tickLabels .yAxis', elem).
                removeAttr('style');
                
            // unset legend customizations
            if (options.legend.hasOwnProperty('container')) {
                $('> table', options.legend.container).removeAttr('style');
                $('.legendColorBox > div > div', options.legend.container).unwrap();
                // re-order legend table columns
                $('table tr', options.legend.container).each(function(index, row) {
                    // remove first cell and re-append
                    var cell = $('td', row).first();
                    cell.detach();
                    $(row).append(cell);
                });
            }
            
            return result;
        };
    }(jQuery));
});
