// (C) Copyright 2011-2012 Hewlett-Packard Development Company, L.P.
/**
 * @type {MapRoutes}
 */
define(['hp/core/Router', 'hp/core/Localizer'],
function (router, localizer) { "use strict";

    var MapRoutes = ( function() {

        var CONTAINER = '#hp-page-container';

        function MapRoutes() {

            var registered = false;

            this.register = function () {

                if (registered) {
                    return;
                }
                registered = true;

                router.map('map', '^/map', {
                    menu: {
                        label: localizer.getString('core.menu.map'),
                        location: '/map'
                    },
                    container: CONTAINER,
                    enter: function (location, result) {
                        require(['text!hpPages/map/index.html',
                            'hp/view/map/MapView'],
                        function (page, view) {
                            result.load(page, view);
                        });
                    }
                });
            };
        }

        return new MapRoutes();
    }());

    return MapRoutes;
});
