// (C) Copyright 2013 Hewlett-Packard Development Company, L.P.
define(['hp/core/EventDispatcher',
        'fs/services/settings/ApplianceService',
        'hp/services/Log',
    'jquery'],
function (EventDispatcher, applianceService, log) {
"use strict";

    var SettingsResource = (function () {

        function SettingsResource() {

           // Derive from EventDispatcher
            EventDispatcher.call(this);

            var applianceUri = "",
                selection = "",
                self = this;

            function onGetApplianceUriSuccess(applianceUriObj) {
                applianceUri = applianceUriObj.value;
                selection = { uris: [ applianceUri ] };
                self.fire("selectionChange", selection);
            }

            function onGetApplianceUriError(errorInfo) {
                self.fire("applianceUriError", errorInfo);
            }

            function setApplianceUri() {
                applianceService.getApplianceUri({
                    success: onGetApplianceUriSuccess,
                    error: onGetApplianceUriError
                });
            };

            this.getSelection = function() {
                return selection;
            };

            this.init = function() {
                setApplianceUri();
            };
        }

        return new SettingsResource();
    }());

    return SettingsResource;
});
