// (C) Copyright 2011-2013 Hewlett-Packard Development Company, L.P.
/**
 * @type {MapRow}
 */
define(['hp/model/map/MapNode', 'hp/core/StatusState'],
function (MapNode, statusState) { "use strict";

    var MapRow = ( function() {

        function MapRow() {

            var self = this;
            var map;
            var category;
            var index;
            var column;
            var nodes = [];
            var nodeIndex = {}; // uri -> MapNode

            this.category = function () {
                return category;
            };
            
            this.index = function () {
                return index;
            };
            
            this.setIndex = function (indexArg) {
                index = indexArg;
            };
            
            this.column = function () {
                return column;
            };
            
            this.setColumn = function (columnArg) {
                column = columnArg;
            };
            
            this.nodes = function () {
                return nodes;
            };
            
            this.singleNode = function () {
                if (nodes.length === 1) {
                    return nodes[0];
                }
                return null;
            };
            
            this.getOrCreateNode = function(treeNode) {
                var node = nodeIndex[treeNode.uri];

                if (! node) {
                    node = new MapNode();
                    node.init(treeNode, self);
                    nodes.push(node);
                    nodeIndex[treeNode.uri] = node;
                }
                
                return node;
            };
            
            this.toString = function () {
                return category;
            };
            
            this.init = function(mapArg, categoryArg) {
                map = mapArg;
                category = categoryArg;
            };
            
            this.destroy = function() {
                var length, i;
                length = nodes.length;
                for (i=0; i<length; i++) {
                    nodes[i].destroy();
                }
                nodes = null;
                map = null;
            };
            
            this.hasDifferentNodes = function (otherMapRow) {
                var result = true;
                var length, otherNodes = otherMapRow.nodes();
                if (nodes.length === otherNodes.length) {
                    result = false;
                    length = nodes.length;
                    for (var i=0; i<length; i++) {
                        if (nodes[i].isDifferent(otherNodes[i])) {
                            result = true;
                            break;
                        }
                    }
                }
                return result;
            };
        }

        return MapRow;
    }());

    return MapRow;
});
