// (C) Copyright 2011-2013 Hewlett-Packard Development Company, L.P.
define(['hp/core/Router', 'hp/core/Localizer', 'hp/model/Session'],
function (router, localizer, session) { "use strict";

    var SettingsRoutes = ( function() {

        var ROOT_CONTAINER = '#hp-page-container';
        var CONTAINER = '#hp-settings-page';
        var SHOW_CONTAINER = '#hp-settings-show .hp-details-show-view';

        function SettingsRoutes() {

            var registered = false;
            var registeredPanels = false;
            var registeredDescriptors = false;
            var authCategories = [];

            this.register = function (panelDescriptors) {

                if (registered) {
                    return;
                }
                registered = true;

                if (panelDescriptors) {
                    $.each(panelDescriptors, function(index, descriptor) {
                        if (descriptor.authCategory) {
                            authCategories.push(descriptor.authCategory);
                        }
                    });
                    if (authCategories.length === 0) {
                        authCategories = null;
                    }
                }

                router.map('settings', '^/settings(/.*|$)', {
                    menu: {
                        footer: true,
                        label: localizer.getString('core.settings.menu'),
                        location: '/settings',
                        resourceUriPattern: '^/rest/(appliance.+|restores.+|backups.*)',
                        excludeUri: true,
                        authCategory: authCategories
                    },
                    container: ROOT_CONTAINER,
                    enter: function (location, result) {
                        require(['text!hpPages/settings/index.html',
                            'hp/view/settings/SettingsView'],
                        function (page, view) {
                            var descriptors;
                            if (!registeredDescriptors) {
                                registeredDescriptors = true;
                                descriptors = $.grep(panelDescriptors, function (descriptor) {
                                    return descriptor.authCategory ?
                                            session.canViewCategory(descriptor.authCategory) :
                                            true;
                                });
                                view.registerDescriptors(descriptors);
                            }
                            result.loadIfViewable(page, view, authCategories);
                        });
                    }
                });

                router.map('settings show overview', '/settings/show/overview(/.*|$)', {
                    container: SHOW_CONTAINER,
                    enter: function (location, result) {
                        require(['text!hpPages/settings/overview.html',
                                 'hp/view/settings/SettingsOverviewView',
                                 'hp/model/settings/SettingsShowRoutes'],
                        function (page, view, routes) {
                            if (!registeredPanels) {
                                registeredPanels = true;
                                if (panelDescriptors) {
                                    $.each(panelDescriptors, function (index, descriptor) {
                                        if (descriptor.registerOverview && (!descriptor.authCategory ||
                                            session.canViewCategory(descriptor.authCategory))) {
                                            descriptor.registerOverview(result);
                                        }
                                    });
                                }
                                routes.register();
                            }
                            result.load(page, view);
                        });
                    }
                });

                // Routes for settings pages need to be registered before the default handlers below
                // Let the callback register what it wants here.
                if (panelDescriptors) {
                    $.each(panelDescriptors, function(index, descriptor) {
                        if (descriptor.registerRoutes) {
                            descriptor.registerRoutes();
                        }
                    });
                }


                router.filter('settings default redirector', '/settings$|/settings/$', {
                    check: function (location, result) {
                        result.replaceWith('/settings/show/overview');
                    }
                });

                router.map('settings no route', '/settings/.+', {
                    container: CONTAINER,
                    enter: function (location, result) {
                        require(['text!hpPages/core/no_details.html'],
                        function (page) {
                            result.load(page);
                        });
                    }
                });
            };
        }

        return new SettingsRoutes();
    }());

    return SettingsRoutes;
});
