// (C) Copyright 2013 Hewlett-Packard Development Company, L.P.
define([ 'fs/services/status/StatusService', 'hp/core/EventDispatcher', 'hp/core/Localizer',
        'hp/services/settings/ApplianceShutdownService'],        
function(statusService, EventDispatcher, localizer, service) {
    "use strict";

    var ApplianceShutdownPresenter = (function() {
        
        function ApplianceShutdownPresenter() {
            
            function forceStatusPageLocally(option) {
                if (option) {
                    statusService.forceStateLocally('RESTARTING');
                } else {
                    statusService.forceStateLocally('SHUTDOWN1');
                }
            }
            this.startApplianceShutdown = function(option, handlers) {
                // Hack for Part 1 (AS6443) - in Part 2 (AS6306), this
                // browser should perhaps learn its next state by
                // observing the change in controller state on the
                // appliance - MAYBE?
                forceStatusPageLocally(option);
                
                // Start the actual shutdown
                service.startApplianceShutdown(option, handlers);
                
            };
            this.init = function() {
            };
        }

        return new ApplianceShutdownPresenter();

    }());

    return ApplianceShutdownPresenter;
});
