// (C) Copyright 2011-2014 Hewlett-Packard Development Company, L.P.
define(['hp/model/DevelopmentSettings', 'hp/core/EventDispatcher'],
function(settings, EventDispatcher) {"use strict";

    var DevelopmentPresenter = ( function() {

        /**
         * @class Presentation logic for the Development Settings panels in the
         *     Settings page.
         * @type {DevelopmentPresenter}
         */
        function DevelopmentPresenter() {

            var dispatcher = new EventDispatcher();

            this.getRefreshInterval = function() {
                return settings.getRefreshInterval();
            };

            this.getActivityRefreshInterval = function() {
                return settings.getActivityRefreshInterval();
            };

            this.getMaxIndexItems = function() {
                return settings.getMaxIndexItems();
            };

            this.isExperimentalFeatures = function() {
                return settings.useExperimentalFeatures();
            };

            this.getRoutingLogLevel = function() {
                return settings.routingLogLevel();
            };

            this.getLabelLengthFactor = function() {
            	return settings.getLabelLengthFactor();
            }

            this.getDisableAudio = function() {
                return settings.disableAudio();
            };
            this.getDisableIPv6 = function() {
                return settings.disableIPv6();
            };
            this.getDisableFactoryReset = function() {
                return settings.disableFactoryReset();
            };
            this.getHighContrast = function() {
                return settings.highContrast();
            };

            this.getTrackTiming = function() {
                return settings.trackTiming();
            };

            this.getLocale = function() {
                return settings.locale();
            };

            this.save = function(attrs) {
                settings.save(attrs);
                dispatcher.fire('change');
            };

            this.on = function(eventName, callback) {
                dispatcher.on(eventName, callback);
            };

            this.off = function(eventName, callback) {
                dispatcher.off(eventName, callback);
            };

        }

        return new DevelopmentPresenter();

    }());

    return DevelopmentPresenter;
});
