// (C) Copyright 2012-2013 Hewlett-Packard Development Company, L.P.
define([ 'hp/core/EventDispatcher', 'hp/core/Localizer',
        'hp/services/settings/SupportDumpService',
        'hp/model/settings/SupportDumpResource',
        'hp/model/Session','fs/services/users/UserService' ],
function(EventDispatcher,
        localizer, service, resource, session, userService) {
    "use strict";

    var SupportDumpPresenter = (function() {
        function SupportDumpPresenter() {
            var dispatcher = new EventDispatcher();
            var INFRA_ADMIN = 'infrastructure administrator';
            
            function onCreateDumpSuccess(value) {
                dispatcher.fire("createDumpSuccess", value);
            }

            function onCreateDumpError(value) {
                dispatcher.fire("createDumpError", value);
            }

            this.createDump = function(value) {
                resource.createDump(value);
                dispatcher.fire('createDumpRequestSuccess');
            };

            function dumpExists(){
                dispatcher.fire("dumpExists");
            }

            function dumpFailed(){
                dispatcher.fire("dumpFailed");
            }

            this.isUserAuthorized =function(){
                var currentUser = session.getUser();
                currentUser = (currentUser != null)? currentUser.toLowerCase(): currentUser;
                userService.getAllUserRoles(currentUser,{
                    success: function(data){
                        var allRoles=data.members;
                        for(var i=0;i<allRoles.length;i++){
                        if(allRoles[i].roleName.toLowerCase()===INFRA_ADMIN){
                            dispatcher.fire("userIsAuthorized", true);
                        }
                        }
                    }});
            };

            this.checkDownload =function(data){
                service.checkLink(data, {
                    success: dumpExists,
                    error: dumpFailed
                });
            };

            this.remove =function() {
                resource.off("onCreateDumpSuccess", onCreateDumpSuccess);
                resource.off("onCreateDumpError", onCreateDumpError);
            };

            this.clear = function() {
                resource.clear();
            };

            this.init = function() {
                resource.on("onCreateDumpSuccess", onCreateDumpSuccess);
                resource.on("onCreateDumpError", onCreateDumpError);
            };
            
            this.on = function(eventName, callback) {
                dispatcher.on(eventName, callback);
            };

            this.off = function(eventName, callback) {
                dispatcher.off(eventName, callback);
            };
        }

        return new SupportDumpPresenter();

    }());

    return SupportDumpPresenter;
});
