// (C) Copyright 2011-2012 Hewlett-Packard Development Company, L.P.

// You can run the link test by pasting this into your console:
// require(['hp/view/LinkTest'], function(linkTest) {linkTest.init();});

define(['hp/services/Log', 'jquery'],
function(log) { "use strict";

    var LinkTest = (function() {
        
        var DELAY = 5000,
            CONTROL = 'hp-link-test-control';
      
        function LinkTest() {
          
            var pending = [],   // array of what we still need to do
                found = {},     // hash of what we've done
                count = 0,
                delay = DELAY,
                timer = null,
                paused = false;
                
            function reset() {
                pending = [];
                found = {};
                count = 0;
                paused = false;
                timer = null;
                $('#' + CONTROL).remove();
            }
            
            function findLinks() {
                var href;
                $.each($('a'), function(i, anchor) {
                    href = $(anchor).attr('href');
                    if (href && href[0] && '#' === href[0] && ! found[href]) {
                        found[href] = true;
                        pending.push(href);
                    }
                });
            }
            
            function run() {
                var href;
                
                findLinks();
                
                if (paused) {
                    log.info("Link test paused with " + pending.length + " pending");
                } else if (pending.length > 0) {
                    href = pending.shift();
                    count += 1;
                    log.info("Link test " + count + " " + href +
                        " (" + pending.length + " remaining)");
                    window.location.hash = href;
                    timer = setTimeout(run, delay);
                } else {
                    log.info("Link test completed, tested " + count);
                    reset();
                }
            }
            
            function toggleTest() {
                paused = ! paused;
                if (! paused) {
                    log.info('Link testing resumed');
                    run();
                    $('#' + CONTROL).css('background-color', '#933').html('pause');
                } else {
                    log.info('Link testing paused');
                    clearTimeout(timer);
                    $('#' + CONTROL).css('background-color', '#393').html('resume');
                }
            }
          
            this.init = function(delayArg) {
                delay = delayArg ? delayArg : DELAY;
                $('body').append($('<div id="' + CONTROL + '" ' +
                    'style="position:absolute; top:20px; right:5px; z-index: 1000; ' +
                    'padding: 5px; cursor: pointer; ' +
                    'color:#fff; background-color:#933; border-radius:3px">' +
                    'pause</div>'));
                $('#' + CONTROL).click(toggleTest);
                log.info("Link testing every " + delay + " milliseconds");
                timer = setTimeout(run, delay);
            };
        }

        return new LinkTest();
    }());
    
    return LinkTest;
});
