// (C) Copyright 2011-2013 Hewlett-Packard Development Company, L.P.

define(['hp/presenter/dashboard/DashboardIndicatorPresenter',
    'jquery'],
function(DashboardIndicatorPresenter) { "use strict";

    var DashboardIndicatorView = (function() {
      
        /**
         * Constructor
         */
        function DashboardIndicatorView() {
          
            var presenter;
            var container;
            var registered = false;
          
            function onSummaryChange(summary) {
                $('.hp-indicator .hp-value', container).
                    text(summary.total);
                $('a', container).attr('href', '#/search?query=' +
                    summary.query);
                $('.hp-indicator label', container).text(summary.label);
            }
          
            /**
             * @public
             */
            this.pause = function () {
                presenter.pause();
                presenter.off('summaryChange', onSummaryChange);
                registered = false;
            };
            
            this.resume = function () {
            	if (!registered) {
                    presenter.on('summaryChange', onSummaryChange);
                    registered = true;
                }
                presenter.resume();
            };

            this.update = function () {
                presenter.update();
            };

            this.init = function (configurationArg, containerArg) {
                container = containerArg;
                presenter = new DashboardIndicatorPresenter();
                presenter.init(configurationArg);
            };
        }

        return DashboardIndicatorView;
    }());
    
    return DashboardIndicatorView;
});
