// (C) Copyright 2013 Hewlett-Packard Development Company, L.P.

define(['hp/presenter/dashboard/DashboardResourceAlertPresenter',
    'hp/core/LinkTargetBuilder',
    'hp/model/Session',
    'hp/core/Localizer',
    'jquery'],
function(DashboardResourceAlertPresenter, linkTargetBuilder, session, localizer) { "use strict";

    var DashboardResourceAlertView = (function() {
      
        /**
         * Constructor
         */
        function DashboardResourceAlertView() {
          
            var presenter;
            var container;
            var configuration;
            var registered = false;
            
            function onSummaryChange(summary) {
                var params = [];
                var uri = presenter.getResourceUri();
                if (uri) {
                    params.push('f_q=associatedResourceUri:' + uri  + ' status:critical status:warning');
                }
                else {
                    params.push('freset=true');
                }
                
                var link = linkTargetBuilder.makeLink(null, null, null, 'alerts',
                            null, null, params);
                var haveItems = (summary.total > 0);

                $('header .hp-name', container).text(configuration.title);

                if (link) {
                    $('header h2 a', container).
                        attr('href', $(link).attr('href')).
                        removeClass('hp-inactive');
                } else {
                    $('header h2 a', container).addClass('hp-inactive');
                }
                
                var anchor =
                        $('.hp-summary-status a.hp-summary-warning', container);
                var icon = $('> .hp-status', anchor);
                    
                $('.hp-count', anchor).text(summary.total);
                
                var labelKey = (summary.total === 1) ? 'core.dashboard.alerts.label.single' : 'core.dashboard.alerts.label.plural';
                $('.hp-summary-warning .hp-name', container).text(localizer.getString(labelKey));
                
                if (! summary.total) {
                    icon.addClass('hp-unset');
                    anchor.removeAttr('href').addClass('hp-inactive');
                } else {
                    icon.removeClass('hp-unset');
                    link = linkTargetBuilder.makeLink(summary.total, null, null, 'alerts',
                            null, null, params);
                    if (link) {
                        anchor.attr('href', $(link).attr('href')).
                            removeClass('hp-inactive');
                    } else {
                        anchor.removeAttr('href').addClass('hp-inactive');
                    }
                }
                $('label.hp-summary', container).text(summary.summary);
            }
          
            /**
             * @public
             */
            this.pause = function () {
                presenter.pause();
                presenter.off('summaryChange', onSummaryChange);
                registered = false;
            };
            
            this.resume = function () {
            	if (!registered) {
                    presenter.on('summaryChange', onSummaryChange);
                    registered = true;
                }
                presenter.resume();
            };
            
            this.update = function () {
                presenter.update();
            };
            
            this.init = function (configurationArg, containerArg) {
                configuration = configurationArg;
                container = containerArg;
                
                presenter = new DashboardResourceAlertPresenter();
                presenter.init(configuration);
            };
        }

        return DashboardResourceAlertView;
    }());
    
    return DashboardResourceAlertView;
});
