// (C) Copyright 2011-2014 Hewlett-Packard Development Company, L.P.
define(['hp/presenter/settings/DevelopmentPresenter',
        'hp/core/Localizer', 'hp/model/Session'],
function(presenter, Localizer, session) {"use strict";

    var DevelopmentShowView = ( function() {

        var REFRESH_INTERVAL = '#hp-settings-refresh-interval',
            MAX_INDEX_ITEMS = '#hp-settings-max-index-items',
            EXPERIMENTAL_FEATURES = '#hp-settings-experimental-features',
            ROUTING_LOG_LEVEL = '#hp-settings-routing-log-level',
            LABEL_LENGTH_FACTOR = '#hp-settings-label-length-factor',
            AUDIO = '#hp-settings-audio',
            DISABLE_IPV6 = '#hp-settings-ipv6-disable',
            DISABLE_FACTORY_RESET = '#hp-settings-factory-reset-disable',
            HIGH_CONTRAST = '#hp-settings-high-contrast',
            TRACK_TIMING = '#hp-settings-track-timing',
            LOCALE='#hp-settings-development-locale',
            EDIT_LINK='#hp-settings-development-edit',
            MS_LABEL = Localizer.getString('core.settings.development.ms'),
            YES = Localizer.getString('core.common.yes'),
            NO = Localizer.getString('core.common.no');

        /**
         * @class View script for the Development Settings panel on the
         *     Overview pane of the Settings page.
         * @type {DevelopmentShowView}
         */
        function DevelopmentShowView() {

            function updateContent() {
                if (session.canPerformAction("appliance", "Update")) {
                    $(EDIT_LINK).show();
                }else{
                    $(EDIT_LINK).hide();
                }

                $(REFRESH_INTERVAL).text(presenter.getRefreshInterval() + " " + MS_LABEL);
                $(MAX_INDEX_ITEMS).text(presenter.getMaxIndexItems());
                $(EXPERIMENTAL_FEATURES).text(presenter.isExperimentalFeatures() ? YES : NO);
                $(ROUTING_LOG_LEVEL).text(presenter.getRoutingLogLevel());
                $(LABEL_LENGTH_FACTOR).text(presenter.getLabelLengthFactor());
                $(AUDIO).text(presenter.getDisableAudio() ? NO : YES);
                $(DISABLE_IPV6).text(presenter.getDisableIPv6() ? YES : NO);
                $(DISABLE_FACTORY_RESET).text(presenter.getDisableFactoryReset() ? YES : NO);
                $(HIGH_CONTRAST).text(presenter.getHighContrast() ? YES : NO);
                $(TRACK_TIMING).text(presenter.getTrackTiming() ? YES : NO);
                $(LOCALE).text(presenter.getLocale() ? presenter.getLocale() :
                    ('default (' + hp.getLang() + ')'));
            }

            this.init = function() {
                this.resume();
                presenter.on('change', updateContent);
            };

            this.resume = function() {
                updateContent();
            };

        }

        return new DevelopmentShowView();

    }());

    return DevelopmentShowView;
});
