// (C) Copyright 2012-2013 Hewlett-Packard Development Company, L.P.
define(['hp/model/SettingsResource',
        'hp/view/DetailsShowView',
        'hp/view/NotificationsView',
        'fs/view/settings/license/LicenseAlertFormatter',
        'hp/core/Localizer',
        'hp/model/Session',
        'jquery',
        'hp/lib/jquery.hpDropMenu'
        ],
function(settingsResource, DetailsShowView, NotificationsView, licenseAlertFormatter, Localizer, Session) {"use strict";

    var SettingsView = ( function() {

        var VIEW = '#hp-settings-show',
            SELECTOR = '#hp-settings-panel-selector',
            ADD_NOTIFICATION = 'addNotification',
            REMOVE_NOTIFICATION = 'removeNotification',
            ACTIONS =  '#hp-settings-actions',
            ACTION_GROUP_PREFIX = 'hp-settings-actions-',
            REGULAR_ACTIONS_LIST = '#' + ACTION_GROUP_PREFIX + 'regular',
            SELECTOR_LIST = '#hp-settings-panel-selector > ol',
            PARENT_ACTIONS_GROUP = '#hp-settings-actions';




        /**
         * @class View script for the Settings page.
         */
        function SettingsView() {

            var detailsShowView = new DetailsShowView(),
                notificationsView = new NotificationsView(),
                panelDescriptors = [];

            // One of our panels wants to add a notification to the notifications view.
            // Do that for them.
            function addNotification(event, data, isNew) {
                notificationsView.add(data, isNew);
            }

            function removeNotification(event, notif) {
                notificationsView.remove(notif);
            }

            function createActions(actions) {
                $.each(actions, function(index, action) {
                    // if user is authorized to perform this action , add it to the menu
                    // if not authCategory is specified a user is allowed to perform the action
                    if (!action.authCategory || Session.canManageCategory(action.authCategory)) {
                        var item = $('<li>'),
                            link = $('<a>').text(action.label)
                                .appendTo(item);
                        if (action.id) {
                            link.attr('id', action.id);
                        }
                        if (action.location) {
                            link.attr('href', action.location);
                        }
                        if (action.click) {
                            link.click(action.click);
                        }
                        if (action.group) { // add it to the separate list on the actions menu
                            var groupId = ACTION_GROUP_PREFIX + action.group;
                            var group = $('#' + groupId);
                            if (group.length === 0) {
                                group = $('<ol></ol>').attr('id', groupId).appendTo( PARENT_ACTIONS_GROUP  + ' .hp-options');
                            }
                            group.append(item);

                        } else {
                            $(REGULAR_ACTIONS_LIST).append(item);
                        }
                    }
                });
            }

            function initDescriptors() {
                var addedActions = false;
                $.each(panelDescriptors, function(index, descriptor) {
                    if (descriptor.actions && (descriptor.actions.length > 0)) {
                        createActions(descriptor.actions);
                        addedActions = true;
                    }
                    if (descriptor.registerViewSelectors) {
                        descriptor.registerViewSelectors();
                    }
                });

                if (!addedActions) {
                    $(ACTIONS).hide();
                }
            }

            this.registerViewSelectors = function(selectors) {
                var selectorsElement = $(selectors);
                Localizer.localizeDom(selectorsElement);
                $(selectorsElement).appendTo(SELECTOR_LIST);
            };

            this.registerDescriptors = function(descriptors) {
                panelDescriptors = descriptors ? descriptors : [];
            };

            this.init = function() {
                initDescriptors();
                licenseAlertFormatter.register();
                $(VIEW).on(ADD_NOTIFICATION, addNotification);
                $(VIEW).on(REMOVE_NOTIFICATION, removeNotification);
                detailsShowView.init($(SELECTOR));
                settingsResource.init();
                var context = {context : $(VIEW),
                           resource : settingsResource};
                notificationsView.init(context);
                $('.hp-details-actions').hpDropMenu();

                this.resume();
            };

            this.pause = function() {
                notificationsView.pause();
                notificationsView.clear();
            };

            this.resume = function() {
                document.title = Localizer.getString('core.settings.overview.title');
                notificationsView.resume();
                $('.hp-page-item-count').empty();
            };

        }

        return new SettingsView();
    }());

    return SettingsView;
});
