// (C) Copyright 2011-2013 Hewlett-Packard Development Company, L.P.

define([ 'hp/presenter/settings/SupportDumpPresenter', 'hp/core/Localizer',
         'hp/core/Notifications', 'hp/core/Router', 'jquery',
         'hp/lib/jquery.hpCollapsible' ],
function(presenter, Localizer, notifications, router) { "use strict";

    var SupportDumpCreateView = (function() {

        // buttons/links in the form
        var CREATE_DUMP_BUTTON_FINAL = '#hp-details-create-dump',
            CANCEL_DUMP = '#hp-details-cancel-dump',
            ENCRYPTION_OPTION='#hp-support-dump-encryption',
            ENCRYPTION_DUMP_CHECKBOX = '#hp-support-dump-encryption-checkbox',
            checkDownloadDelay = 3000,
            userAuthorized =false;

        /**
         * Constructor
         */
        function SupportDumpCreateView() {
            
            var dumpCount = 0;
            var dumpCountOutput =0;
            var dumpId;
            var dumpIdOutput=0;
            var link;
            var postData = {
                errorCode : 'CI',
                encrypt : true
            };// This will be added in Dump File Name

            function gotoSettingsPage(){
                //return to previous page
                router.returnToPrevious();
            }

            function userIsAuthorized(isAuthorized){
                $(ENCRYPTION_OPTION).show();
                userAuthorized=true;
            }

            function onCreateDumpError(errorInfo) {
                var errorCreatingDump = {
                    summary : Localizer.getString('fs.settings.supportdump.error_creating_dump'),
                    details : Localizer.getString('fs.settings.supportdump.error_creating_dump_message'),
                    status : "error",
                    uri : dumpId,
                    errorMessage: errorInfo,
                    changing: false
                };
                notifications.add(errorCreatingDump, true);
                presenter.clear();
            }
            function dumpExists(){
                var dumpCreated = {
                    summary : Localizer.getString('fs.settings.supportdump.dump_created'),
                    status : "ok",
                    uri : dumpIdOutput,
                    changing : false
                    };
                link.click();
                notifications.add(dumpCreated, true);
            }

            function dumpFailed()
            {
                var dumpFailed = {
                    summary : Localizer.getString('fs.settings.supportdump.error_downloading_dump'),
                    details : Localizer.getString('fs.settings.supportdump.error_downloading_dump_message'),
                    status : "error",
                    uri : dumpIdOutput,
                    changing : false
                    };
                notifications.add(dumpFailed, true);
            }

            function getDump(data){
                dumpIdOutput="supportDump" + dumpCountOutput++;
                link = document.getElementById("hiddenDownloader");
                if (link === null)
                {
                    link = document.createElement('a');
                    link.setAttribute('id', "hiddenDownloader");
                    link.style.display = 'none';
                    link.setAttribute('type', "application/octet-stream");
                    document.getElementsByTagName('body')[0].appendChild(link);
                }
                link.setAttribute('href', data);
                setTimeout(function () {
                    presenter.checkDownload(data);
                }, checkDownloadDelay);
            }

            function onCreateDumpSuccess(data) {
                getDump(data);
                presenter.clear();
            }

            function createDump() {
                dumpId = "supportDump" + dumpCount++;
                var creatingDump = {
                    summary : Localizer.getString('fs.settings.supportdump.creating_dump'),
                    uri : dumpId,
                    changing : true
                };
                notifications.add(creatingDump, true);
                if(($(ENCRYPTION_DUMP_CHECKBOX).is(':unchecked')) && userAuthorized )
                {
                    postData.encrypt = false;
                }
                else
                {
                    postData.encrypt = true;
                }
                presenter.createDump(postData);
            }

            function cancelDump() {
                gotoSettingsPage();
            }

            function onCreateDumpRequestSuccess(){
                gotoSettingsPage();
            }

            function registerEvents() {
                presenter.on('createDumpSuccess', onCreateDumpSuccess);
                presenter.on('createDumpError', onCreateDumpError);
                presenter.on('createDumpRequestSuccess', onCreateDumpRequestSuccess);
                presenter.on('userIsAuthorized', userIsAuthorized);
                presenter.on('dumpExists', dumpExists);
                presenter.on('dumpFailed', dumpFailed);
            }

            this.pause = function() {
            };
            this.init = function() {
                presenter.init();
                registerEvents();
                presenter.isUserAuthorized();
                $(CREATE_DUMP_BUTTON_FINAL).on('click', createDump);
                $(CANCEL_DUMP).on('click', cancelDump);
            };

        }

        return new SupportDumpCreateView();
    }());

    return SupportDumpCreateView;
});