// (C) Copyright 2012 Hewlett-Packard Development Company, L.P.
define([], function () {"use strict";
return {
    baseline : {
        add : {
        	availableBundles: "Available Web Bundles",
            title : "Add Baseline",
            deleteBaseline : "Delete Baseline",
            enterDirectory : "Enter directory path",
			reportPathLabel: "Set report output path:",
            enterHTTPURL: "Enter HTTP URL",
            enterWorkingDirectory : "Enter working directory",
            enterURIPath  : "Enter URI for the baseline",
            enterValidHTTPURL: "Enter HTTP URL with valid baseline XML file",
            baselineAdded: "A new Baseline is added successfully",
            browseText: "Browse or manually enter a directory path where the components for the baseline are located.",
			errorReportText: "Selected location is read-only. Select a writable location for report generation",
			emptyReportText: "Provide valid report directory",
			emptySelectionReportText: "Select valid report directory",
			browseReportText: "Browse or manually enter a directory path where the reports should be generated.",
            browsePFWText: "Browse or manually enter a directory path where the Available Web Bundles list and components being downloaded from hp.com can be stored. Please select an empty folder.",
            browseHTTPText: "Enter a directory path where the components being downloaded can be stored. Please select an empty folder.",
			browseUNCText: "Enter an URI where the components for the baseline are located.",
            getList: "Retrieve List",
            locationAdded: "A new Location is added successfully",
            locationAlreadyExists: "Baseline location already exists",
            locationType : "Location type",
            locationDetails : "Location Details",
            scheduleInformation : "Schedule and Recurrence Options",
            selectLocation : "Select the location type",
            local :"Browse HP SUM server path",
            unc :"UNC path  (for example \\\\host\\dir )",
            http :"HTTP",
            httpshare: "Download from http share",
            httpshareurl: "HTTP Share URL",
            httpText:"Provide an HTTP URL to validate a bundle file (bpxxxxxx.xml). All components must be present in the same directory on the HTTP server.",
            httpPrefix: "http://",
            httpsPrefix: "https://",
            httpSuffix: ".xml",
            ftp :"Download from hp.com" ,
            enableSchedule: "Schedule download from web?",
            port : "Port",
            proxySettings : "Proxy Settings",
            proxyOptions: "Proxy Options",
			proxyOptionshelp: "Options for adding the proxy if needed.",
            proxyServer: "Proxy server",
            proxyuser : "Username",
            proxypasswd: "Password",
			required : "Required",
            scheduleDatetime : "Select schedule date and time",
            scheduleType : "Recurrence pattern",
            daily : "daily",
            weekly : "weekly",
            monthly : "monthly",
            onetime : "one time",
            noProxyNeeded: "No Proxy Needed",
            none : "none",
            selectBundles: "Select one of the available web bundles to be downloaded from hp.com. Note: If a component included in the initial release of " + 
            			   "the web bundle has been unpublished from hp.com, then it  will not be downloaded from hp.com with the web bundle. " + 
            			   "An SPP-sized bundle download may take more than several minutes to complete. Monitor the baseline page for download progress.",
            scheduleRecurring : "Recur every",
            script : "Script",
			scriptconfiguration : "Automatic Configuration Script",
            url : "Address",
            usehp : "Use hp.com",
            useScript : "Proxy script",
            username : "Please enter the username",
            password : "Please enter the password",
			usecurrentcreds : "Use Current Credentials",
            inValidLocation: "Please enter a valid location!",
            addInProgress: "Baseline Add is in progress. Please wait...",
            abortInProgress: "Baseline Abort is in progress. Please wait...",
			retrieveInProgress : "Retrieving  list of  Web bundles. Please wait...",
			HPEntitlementPassportToken : "HP Support Center entitlement token",
			HPPassportTokenDescription:"HP has made significant investments in our intellectual capital to provide the best value and experience to our customers."+
			                            "We continue to offer a differentiated customer experience with our comprehensive support portfolio.Only HP Customers and authorized channel "+
										"partners may download and use support materials.",
			HPPassportIntellectualCapitalManagementSingleSignIn :"HP Support Center Entitlement Token Single Sign In",
			HPPassportICMSingleSignIn:"HP Passport ICM Single Sign In",
			HPPassportTokenWarning : "Please enter a valid HP Support Center Entitlement Token to access Proliant Firmware "+
									"or else leave it blank in order to access only publicly available updates.",
			HPPassportTokenValidation : "Support validation required",
			HPPassportTokenValidationStr1 : "An active warranty or support agreement covering HP ProLiant servers must be linked to your HP Support Center profile to access ProLiant firmware. Please enter a valid ",
			HPPassportTokenValidationStr2 : "to continue",
			HPPassportTokenValidationStr3 : "More Information",
			HPPassportTokenValid :" HP Passport Token given is valid.You can download all the components.",						
			retrytitle:"Retry Download",
			retry:"Retry Download",
			retryall : "Retry All",
            HPPassportTokenNote:"Note: An HP Support Center entitlement token provides access to HP support materials (e.g. HP ProLiant firmware) based on the active contracts & warranties associated to your HP Support Center profile.",
			osFilterOpt : "Download components based on OS type"
        },
        addBaseline : {
            configured : "Configured",
            description : "Description",
            id : "ID",
            select : "Select baselines",
            system : "System"
        },
        custom : {
            add : "Add...",
            advancedFilters : "Advanced Filters",
            applyfilters : "Apply Filters",
            applyfiltersHelp : 'Apply filters on the selected baseline source. The filtered components will be displayed below',
            applyfiltersError : 'No baseline source(s) selected. Select one or more baseline source(s)',
            architecture : "Architecture",
            arrayctrl : "Array Controller",
            baselines : "Baselines",
            bootableiso : "Make Bootable ISO file",
            bootableisoHelp : "Check this option to create Custom Baseline ISO that is bootable. This baseline includes HP SUM binary files and contents included in the Source ISO.",
            bootableisoHelpLinux : "To create UEFI bootable ISO, xorrisofs must be installed on the system or else the ISO created will only be bootable on legacy BIOS based systems.",
			matchCloudSystem : "Check this option to create a custom baseline compliant to a CloudSystem Matrix recipe",
            both : "Firmware and Software",
            comptype : "Component Type",
            comptypehelp: "Select which component type",            
			createBaseline : "Create Custom Baseline",
            createCBLMsg : "Creating custom baseline",
            createCBLMsgSuccess : "Custom baseline creation request accepted successfully",
            createCBLMsgError : "Failed to create custom baseline",
            createiso : "Create ISO and save Baseline",
            criticalUpdates : "Critical Updates",
			customCreateMsgError : "Baseline has been saved successfully. ISO creation failed. Baseline has been added successfully.",
			customCreateMsgSuccess : "Baseline has been saved successfully. ISO creation was successful. Baseline has been added successfully.",
			customCreateMsgInProgress: "{0} Custom Baseline(s) creation already in progress. Maximum limit reached. Please try after sometime.",
			customSaveMsgSuccess : "The custom baseline has been saved and added to the list of baselines successfully",
			c7000EnclosureComponent: "C7000 Enclosure Components",
            description : "Description *",
            descriptionError : "Description error: ",
            descriptionRequired : "Custom Baseline description is required.",
            descriptionValidationMsg : "Enter only alpha-numeric, hyphen or underscore.",
            deviceType : "Enclosure and Individual Device Types",
			IndividualTypes: "Individual Device Types",
	    deviceTypehelp: "Display components for device type",
            DL360p : "DL360 G6 Server",
            DL320p : "DL320 G6 Server",
			DL : "HP ProLiant DL Series",
			BL : "HP ProLiant BL Series",
			SL : "HP ProLiant SL Series",
			deselectall : "Deselect all",
			DL480p : "DL480 G6 Server",
            fcHbaCna : "FC HBA/CNA",
            fcswitches : "Fibre Channel Switches",
            filters : "Step 2 - Filters",
            filterMsg: "Server Model filters are disabled since hardware information is unavailable in one or more selected baseline(s).",
			filterInternalErrMsg: "Server Model filters are disabled, current HP SUM installation does not contain required metadata file(s).",			
            firmware : "Firmware",
			firmwareInclusionWarning : "Note: Onboard Administrator and iLO firmware components must be included for a custom ISO to work with Enclosure Firmware Management",
            harddrive : "Hard Drive",
			hardwareType : "Server Model",
			hardwareTypehelp: "Display components for server models",
            ilo : "iLO",
            isolocation : "Extracted Source ISO Location *",
            isolocRequired : "Extracted Source ISO location required",
            isolochelp : "This is the location where an SPP ISO is mounted or the extracted contents of an SPP ISO are placed. The boot environment and HP SUM are picked from here.",
            information : "Information",
            customCreateMsgErr : "Cannot create custom baseline when some of the baselines are still being inventoried",
            maxlen : "Maximum length can be ",
			ML : "HP ProLiant ML Series",
			ML440p : "ML 440 G6 Server",
			ML280p : "ML280 G6 Server",
			ML560p : "ML560 G6 Server",
            name : "Baseline Name",
            nic : "NIC",			
            oa : "OA",
            optionalUpdates : "Optional Updates",
            osType : "OS Type",
			osFilterOpt : "OS Filter Options",
            osTypeMsg : "OS list under OS Type filter and Server list under Server Model filter are populated dynamically from the selected baseline(s).<br>If no filters are checked under a section, no filtering is done on that criteria.",
			operatingsystem : "Operating System",
            osTypes : {
                rhel5 : "RHEL 5",
                rhel6 : "RHEL 6",
                sles10 : "SLES 10",
                sles11 : "SLES 11",
                vmwareEsxi50 : "VMware vSphere 5.0",
                vmwareEsxi51 : "VMware vSphere 5.1",
                vmwareEsxi55 : "VMware vSphere 5.5",
                windows2003R2 : "Windows 2003 R2",
                windows2008 : "Windows 2008",
                windows2008R2 : "Windows 2008 R2",
                windows2012 : "Windows 2012",
		windows2012R2 : "Windows 2012 R2"
            },
            outputDirWarning: "Warning: Please specify an empty location as Output Location.",
            noBaselinesAvailable : "No baselines available!",
            noMatchingComponents : "No matching components found!",
            overview : "Overview",
            populateComponentOsMsg : "Populating component OS details. Please wait...",
            populateComponentOsErrorMsg : "Error occurred while populating component OS details. Error: ",
            populateSourcesMsg : "Populating sources. Please wait...",
            populateSourcesErrorMsg : "Error occurred while populating sources. Error:", 
            recommendedUpdates : "Recommended Updates",
            remove : "Remove",
            retrieveCompMsg : "Retrieving components",
            retrieveCompMsgDone : "Completed retrieving components",
            retrieveCompMsgError : "Error retrieving components",
            review : "Step 3 - Review",
            runinback : "Run in background",
            runinbackHelp : "Create Custom Baseline in background. The status will be available in Activity screen",
            saveBaseline : "Save Baseline",
            sasswitches : "SAS BL switch Interconnects",
            server : "Server",
            software : "Software",
			selectall : "Select all",
            sources : "Step 1 - Baseline Sources",
            storage : "Storage",
            systemrom : "System ROM",
            tape : "Tape",
            targetlocation : "Output Location *",
            targetlocRequired : "Output location required",
            unknown : "Unknown",
            validationErrorMsg : "Validation errors - Field value required",
            vc : "Virtual Connect (VC)",
            version : "Version *",
            versionError : "Version error: ",
            versionRequired : "Version required",
            versionValidationMsg : "Enter only numeric value.",
            x64 : "x64 (64 bit)",
            x86 : "x86 (32 bit)",
            versionHelp: "Version Identifier. Enter a one or two character version (ex: 00, 01, a1, 1A)",
            versionIdentifierError: "Please enter a one or two character version identifier.",
            XL : "HP ProLiant XL Series",
            hpsumSourcePath : "HP SUM path",
            hpsumSourcePathHelp : "This is the location where HP SUM binary files are located. HP SUM files will be copied from this location to target location.",
            hpsumSource : "Select HP SUM Source Location",
            hpsumSourceTooltip : "To include HP SUM select source location type",
            doNotInclude : "Do not include",
            extractedISODirectory : "Extracted source ISO directory",
            currentWorkingDirectory : "Current working directory",
            customDirectory : "Custom directory",
            hpsumVersionSelected : "HP SUM version selected : ",
            hpsumlocationRequired : "HP SUM source path required",
			nosupportedcomps: "No applicable components selected for this model family.",
            selectingAll : "Selecting components. Please wait...",
            deselectingAll : "Deselecting components. Please wait..."
        },
        matrix : {
         matchCSMVersion: "Match CloudSystem Matrix Version",
         locationType: "Select Location",
         defintionXML: "CloudSystem Matrix Definition XML file:",
         csmVersion: "CloudSystem Matrix Version:",
         sppBase: "Starting baseline required:"
        },
        start_inventory : "Start Inventory",
        schedule_download : "Schedule Download",
        download_now : "Download Now",
        starting_download : "Starting Download", 
        compDownloadInProgress : " Component download in progress",
		compDownloadingFinished : "Components downloading finished",
        locations : "Locations",
        nodeInventoryFailed : "Node inventory failed",
        nodeInventoryInProgress : "Node inventory in progress",
        selectLocation : "Select a valid baseline location.",
        show : {
			yesAbort: "Yes, Abort",
			allBaselinesSelected : "No baselines available for selection.",
            addFromMedia : "Add",
            baselineComponentWarnings : "Baseline has component warnings.",
            component : "Component",
            componentHelp : "Component help",
            componentTitle : "Component title",
            componentVersion : "Component version",
            componentConfig: "Component Configuration",
	    componentConfigError: "There was an error saving the configuration values for this component. Please configure the component outside HP SUM.",
			componentConfigExport: "Component Configuration - Export",
            componentConfigFor : "Component Configuration for {0}",
			componentConfigImport: "Component Configuration - Import",
			componentConfigSaved: "Status: Component configuration data saved successfully in HP SUM.",
			configuration: "Configuration state",
            createCustom : "Create custom",
			credentialsmsg : "Include credentials while exporting the configuration",
			credentialsNote : "Note: The files will be in plain text",
            criticality : "Criticality",
			emptyimportpath : "Folder Path should not be empty for importing the configuration",
            enhancements : "Enhancements",
			exportwarning : "The component configuration could potentially contain credentials that are stored in plain text. Please deselect the checkbox if you don't want to export the credentials.",
            compConfigExportImportFooter : "Note : Any existing component configurations in the specified location will be overwritten.",
			componentWarnings : "Component Warnings",
			components : "Components",
			folderpath : "Enter Directory Path",
			importConfig : "Import Configuration",
			importConfigMsg : "Warning: Importing configuration will overwrite any existing configuration in this baseline",
			missingcomponents : "Missing Components",
			retry:"Retry",
			ICMtokenInvalid : "An active warranty or support agreement covering HP ProLiant servers must be linked to your HP Support Center profile to access ProLiant firmware.  To download all available ProLiant firmware, please cancel this operation and confirm the status of your contracts and warranties in HP Support Center. ",
            inventoryCompleted : "Inventory completed",
			inventoryCompletedMissingComponents : "Inventory completed. There are missing components.",
            inventoryFailed : "Inventory failed",
			reinventory : "Re-inventory",
            inventoryError : "Inventory error",
            downloadNeeded : "Download needed to complete the processing",
            inventoryNeeded : "Inventory needed",
            inventoryInProgress : "Inventory in progress",
			locationdetails: "Location Details",
			locationimporttext: "Browse or manually enter the folder name from where the configuration should be imported",
			locationexporttext: "Browse or manually enter the folder name to where the configuration should be exported",
			locationerrormsg : "Selected location is not writable. Select a writable location for export",
            name: "Name",
            needConfig : "Configurable",
            noComponentsFound : "Loading or inventory in progress",
            noMissingComponents : "There are no missing components",
            numMissingComponents : "{0} components are missing.",
            parDesc : "Parameter Description",
            parName : "Parameter Name",
            releaseDate : "Release date",
            revisionHistory : "Revision History",
            versionDetails   : "Version Details",
            seeComponentWarnings : "Refer to the component warnings section for more details.",
            subType : "Subtype",
            totalComponents : "Total components",
            type : "Type",
            validate: "Validate",
            value : "Value",
            yesDelete : "Yes, Delete",
            bundleFileDownloadFailed : "Bundle file location is invalid or download failed"
        },
        storageRemaining : "Storage remaining",
        version : "Version",
	remove : {
			baseline : "Baseline ",
			association : " is associated with ",
			assigned : "Assigned to",
			nodes : " node(s), ",
			continueDel : "continue with delete?",
			deleteMessage : "All nodes will be moved to Inventory Needed state after deleting the baseline.",
			currentlyAssign : " is currently assigned to ",
			assignNodes : " node(s).",
			delWarning : "Cannot delete baseline because ",
			activelyUse : " node(s) are actively accessing the baseline.",
			device : " Node",
			devices : " Nodes",
			type : "Type",
            status : "Status",
			deleteBaseline : "Delete Baseline",
			delWarningNoNode : "Baseline is not assigned to any node(s), continue with delete?",
			deletingBaselineInProgress: "Delete is in progress...",
			close: "Close"
		},
        validate : {
            blUsedLabel : "Starting baseline used:",
            blUsedLabelValue : "Service Pack for ProLiant",
            bundle : "Validate",
            csmPath : "Select CloudSystem Matrix XML",
            csmTitle : "Validate Baseline",
            csmLabel : "CloudSystem Matrix Version",
            ftp : "Latest MatrixConfig.xml from hp.com",
            getMatrixFile : "Retrieve File", 
            local : "Latest MatrixConfig.xml from local",
            locationType : "CloudSystem Matrix Definition XML File",
			locationTypehelp : "Location of the Matrix config XML file",
            retrieveInProgress : "Retrieving CloudSystem Matrix recipe file... Please wait...",
            selectedBaseline : "Selected Baseline",
            selectedBaselineXML : "bp****.xml",
            sppBundleLocation : "Baseline bundle file location",
            validateBundle : "Validate against bundle file",
            validateCSM : "Validate against CloudSystem Matrix version",
            validationType : "Validation Type",
			validationTypehelp: "Validate against a bundle or version",
            vblBundleSummary : "Summary of validate baseline against bundle",
            saveInProgress : "Save in progress..... Please wait.",
            validationInProgress : "Validation in progress..... Please wait.",
            totalSummary : " components specified in the baseline",
            missingSummary : " components are missing"
        }
    },
    common : {
        abort: "Abort",
		abortMessage: "Abort Baseline",
		missingComponentsInfo : "Missing Components While Downloading",
		abortWarning: "Abort will stop the download, inventory and deletes the baseline. Do you want to Continue?",
        actions: "Actions",
        activity: "Activity",
		activitywait: "Activity page is loading...",
        activeFirmwareVersion: "Active Firmware Version",
        activeROMVersion: "Active ROM Version",
        add : "Add",
        adding: "Adding",
        addMessages: "Add Messages...",
        addNote : "Add note",
        addPlus : "Add +",
        added : "Added",
		
		addSingleNode : "Add a single node or known range of nodes",
		addType : "Select the type of add",
		all: "All",   
		allDevices : "All Devices",
        allLabels : "All labels",
        allStatuses : "All statuses",
        allTypes : "All types",
        always: "Always",
        analysisErrors: "Analysis Errors",
        analysisWarnings: "Analysis Warnings",
        anyone: "Anyone",
        apply : "Apply",
        arrayController: "Array Controller",
        assignAlert: "Assign alert",
        associatedDevices : "Associated devices",
		associatedOACredentials : "Associated Onboard Administrator Credentials",
		associatedOAIp : "Associated Onboard Administrator IP/DNS",
		associatedOAIpOptMsg : "Optional: required when installing VC firmware prior to 4.01",
		associatedservers : "Device Bays",
		associatedswitches : "Interconnect Bays",
        back : "Back",
        bandwidth : "Bandwidth",
        baseline : "Baseline",
        baselines : "Baseline Library",
        baselineToApply: "Baseline to Apply",
        bayNumber: "Bay Number",
        bios: "BIOS",
        bpm: "BPM",
        broadcom: "Broadcom",
        brocade: "Brocade",
        powerpic : "PMC",
        cpld : "CPLD",
        browse : "Browse",
        cancel: "Cancel",
        cartridges : "Cartridges",
	confirm : "Confirm",
        confirmWarning: "Click {0} to continue and enable updates or {1}.",
		applyUserSelection: "Applying user selection, Please wait..",
        confirmSelected: "The configuration warnings have been confirmed and updates will continue. Please wait...",
        cancelSelected: "Updates will be blocked because user has selected to cancel it. Please wait...",
        rerunInventory : "To re-enable updates, please rerun {0}.",
        bootDiskWarningSummary: "Configuration Warnings: If the boot disks on this node are not configured with LVM or if LVM is configured without failover capability, IO firmware update can cause significant system downtime in case any error occurs during the ROM update.",
        category : "Category",
        clearAlert : "Clear alert",
        close : "Close",
        clusterWarningSummary1 : "The node ",
        clusterWarningSummary2 : " is currently an active member of a Serviceguard cluster.",
        clusterWarningConfirm : "Continue with updates",
        clusterWarningDetails :"       or       ",
        clusterWarningCancel : "Cancel updates",
        clusterWarningContinueInventory : "Continuing with inventory",
        clusterWarningCancelInventory   : "Cancelling inventory",
        collapseContent: "Collapse Content",
	comments : "Comments",
        complex : "Complex",
        connections : "Connections",
        continueWithAbort : "Continue with abort?",
        continueWithDelete: "Continue with delete?",
		continueWithDeleting: "Continue with deleting",
	currentdatetime : "Current date/time:",
        core: "Core",
        cores: "Cores",
        count : "Count",
        credentials : "Credentials",
        critical : "Critical",
        daily: "Daily",
        dashboard : "Dashboard",
        date : "Date",
        compName : "Component name",
        prerequisite : "Prerequisites",
        days : {
            friday : "Friday",
            monday : "Monday",
            saturday : "Saturday",
            sunday : "Sunday",
            thursday : "Thursday",
            tuesday : "Tuesday",
            wednesday : "Wednesday"
        },
        deleteAlert : "Delete alert",
        deleteArg : "Delete {0}",
        deleteStr: "Delete",
        dependencyHeader: "{0} items depend on {1}",
        depot: "Depot",
        description: "Description",
        details: "Details",
        dhoa: "DHOA",
        disabled : "Disabled",
        doActionInventory : "Inventory to get the complete details",
        doInventory : "Inventory",
        download: "Download",
        driver: "Driver",
        edit: "Edit",
        emulex: "Emulex",
        enabled : "Enabled",
        enclosure: "Enclosure",
        enclosureName: "Enclosure Name",
        enterAdministratorCredentials : "Enter administrator credentials",
    	enterRootCredentials : "Enter super user credentials to update components",
		enterVcenterAdministratorCredentials : "Enter vCenter details to get ticket(for authentication to host)",
		vcenterCredentials : "vCenter Credentials",
		useVcenter : "Use vCenter",
        error : "Error",
    	evaController: "EVA Controller",
    	evaDrive: "EVA Drive",
        every : "Every",
	exit : "Exit",
	exportMsg: "Save and Export",
        fcbha: "FCBHA",
        F_VMWARE_NIC_DISC_ERR_MSG : "VMware node inventory failed while reading NIC information.",
        F_VMWARE_FCHBA_DISC_ERR_MSG : "VMware node inventory failed while reading FCHBA information.",
        F_VMWARE_ILO_DISC_ERR_MSG : "VMware node inventory failed while reading iLO information.",
        F_VMWARE_OS_DISC_ERR_MSG : "VMware node inventory failed while reading Operating System information.",
        F_VMWARE_SYSHW_DISC_ERR__MSG : "VMware node inventory failed while reading System Hardware information.",
        F_VMWARE_GENERAL_DISC_ERR_MSG : "VMware node inventory failed while reading Hardware / Operating System information.",
        F_VMWARE_SA_DISC_ERR_MSG : "VMware node inventory failed while reading Smart Array information.",
        F_VMWARE_PCI_DISC_ERR_MSG : "VMware node inventory failed while reading PCI information.",
        F_VMWARE_MSG : "Please check your network connectivity and HP WBEM Provider status in the VMware node.",
        F_VMWARE_SECOND_MSG : "{0} after checking the above.",
        F_VMWARE_SELF_DISC_DNL_ERROR_MSG : "VMware node inventory failed to download, ",
        failedComponents : "components.",
        fieldRequired : "This field is required.",
        file: "File",
        filter: "Filter",
        filters : "Filters",
		find : "Find Nodes",
		findNodesWithIPRange : "Find nodes on network with an IP range",
        firmware : "Firmware",
		firmwareBaseline: "Firmware Baseline",
        firmwareVersion : "Firmware Version",
        first : "First",
        found : "Found",
        fourth : "Fourth",
        general : "General",
        group: "Node Group",
        healthStatus: "Health Status",
        help : "Help",
        hpux: "HP-UX",
        hpuxsmif: "HPUXSMIF",
        id : "ID",
        ifNeeded : "If needed",
        ignoreWarnings: "Ignore Warnings",
        ilo : "iLO",
        iloDomain : "iLO Domain:",
        iloDomainNotifyMsg : "The iLO domain is ready to deploy",
        iloFederation : "iLO Federation",
        iloFederationGroupName: "iLO Federation Group Name",
        iloFederationGroupNameError : "iLO Federation group name is necessary",
        iloFederationInterfaceIP : "Interface IP",
        iloFederationWarning : "Node will be converted to a regular iLO node if the iLO Federation service is not detected on it or if the specified iLO Federation group does not exist.",
        iloType : "iLO Type",
        importMsg : "Import",
	    incorrectCredentials : "Incorrect username/password or user does not have admin rights.",
	    installedROM: "Installed ROM",
	    important: "Important",
        infiniband: "Infiniband",
        initiator : "Initiator",
        installationNotes : "Installation notes",
        installedFirmwareVersion: "Installed Firmware Version",
        integritysfw: "Integrity SFW",
        intelBroadcom: "Intel and Broadcom",
        inventoryhelp: "Gather information about the node",
        ipDns : "IP/DNS",
		ipDnshelp: "IP address or DNS name of the node",
		ipDnshelpedit : "IP address or DNS name of the node added",
        ipdu : "iPDU",
        label : "Label",
        languages : "Languages",
        last: "Last",
        library: "Library",
        linux : "Linux",
		linuxcredentials : "Access Level",
		linuxcredentialsApplicable : "Access Level (Not applicable for use current credentials. Applicable only for administrator credentials)",
		loading: "Loading",
		local: "Local",
		locationStr: "Location",
		
		loggedIn : "Logged in",
		logout: "Logout",
		managementProcessor: "Management Processor",
        ManagementSWat : "Management Software is accessible at: {0}",
        message: "Message",
		model: "Model",
        moonshot: "Moonshot",
        more: "More",
        na: "N/A",
        name: "Name",
        next: "Next",
        nic: "NIC",
        nicIntel: "Intel NIC",
        nicNetXEN: "NetXEN NIC",
        nicEmbedded: "Embedded NIC",
        no : "No",
		none : "none",
        yes: "Yes",
        noAssociatedDevicesFound : "No associated devices found.",
		noWarnings: "No Warnings found.", 
        nodes : "Nodes",
		noderange : "Node Range",
        oa : "OA",
        ok : "OK",
		oddeven: "Odd-Even",
		serial: "Serial",
		parallel: "Parallel",
        manual: "Manual",
        oneTouchUpdate : "Localhost Guided Update",
		open : "Open",
        operatingSystems : "Operating Systems",
        optional : "Optional",
        os: "OS",
        overview : "Overview",
        password : "Password",
	PartnerIpduCredentials : "Partner iPDU Credentials",
	PartnerIpduIP: "Partner iPDU IP/DNS",
        pci: "PCI",
	power: "Power",
        progress : "Progress",
        previous: "Prev",
        qlogic: "QLogic",
        query : "?",
        questionMark : "?",
        reboot : "Reboot",
        recommended : "Recommended",
        reenterCredentials: "Re enter Credentials",
		rebootRequired : "Reboot Required",
        related : "Related",
        reset : "Reset",
        resetAll : "Reset all",
        retry: "Retry",
        rpm: "RPM",
        rollbackSupported: "Rollback Supported",
        rollbackVersion: "Rollback Version",
        saController: "SA Controller",
        sas: "SAS",
        sashba: "SASHBA",
        sasHD:"SAS Hard Drive",
		continueDownload : "Continue download",
        save: "Save",
		savetohpsum: "Save in HP SUM",
		saveAs: "Save As",        
        scalableUpdate : "iLO Federated Update",
        scoutingDevice: "Scouting device...",
        sdoa: "SD2OA",
        search : "Search",
        second: "Second",
        selectDevices: "Select Devices",
        selectOption: "Select option",
        sep: "SEP",
        server : "Server",
        servers: "Servers",
        session: "Session",
        slot : "Slot",
        shutdownMsg: "HPSUM Engine is Shutdown. Please restart the engine to Login.",
        shutdownRequestFailed: "There was an error processing the request. Please try again.",
        software: "Software",
        solex: "Solex",
        source: "Source",
        staging : "Staging",
        start : "Start",
        startOver : "Start Over",
        state : "State",
        statusStr : "Status",
        strDelete: "Delete",
        switchBrocade: "Brocade Switch",
        switchCisco: "Cisco Switch",
        switchQLogic: "QLogic Switch",
        switchStr : "Switch",
        switches : "Switches",
        succeeded: "Succeeded",
        tape: "Tape",
        task: "Task",
        tasks : "Activity",
        the : "The",
        third : "Third",
        time : "Time",
	timezone : "Timezone:",
        type : "Type",
		typetoadd : "Type of node to add",
		typetoaddhelp : "Check this option to add all the chassis nodes",
        undefinedStr : "Undefined",
        unknown: "Unknown",
        updateType: "Update Type",
        updating : "Updating",
        uploads : "Uploads",
        useCurrentCredentials : "Use current credentials (requires existing trust relationship with the node).",
        user : "User",
        username : "Username",
		useSudoCredentials : "Use sudo to update components",
        utility: "Utility",
		utilization: "Utilization",
		version: "Version",
		vc: "VC",
		vmware: "VMware",
		vmwareDriver: "VMware Driver",
        viewAllActivity : "View all activity",
        warning : "Warning",
        weekly : "Weekly",
        weeks : "weeks",
        welcome : "Welcome to HP Smart Update Manager",
        windows : "Windows",
        yesDelete : "Yes, delete",
        unsupportedBrowser : "Warning: The browser you are using is not officially supported by HP SUM.  Some features may not work properly. Supported browsers are: Internet Explorer 9 or greater, Firefox 17 (Linux)/ 18 (Windows) or greater, Chrome 24 or greater",
        unsupportedBrowserVersion : "Warning: The browser version you are using is below the version officially supported by HP SUM.  Some features may not work properly. Supported browsers are: Internet Explorer 9 or greater, Firefox 17 (Linux)/ 18 (Windows) or greater, Chrome 24 or greater",
        unknownNodeError : "Unable to identify node as a supported node type. Please ensure that node is supported, reachable on the network and credentials are correct.",
		vmwareLoginError : "Login Error",
		vmwareLockDownMode : "Unable to login.Please ensure that login credentials are correct or Enter the vCenter credentials if the host is in lockdown mode.",
        unknownNodeFederationGrpError : "The specified iLO Federation group was not found in the network. Please ensure that the specified iLO is part of the iLO Federation group. Delete the node and add again with a valid iLO Federation group.",
		deleteBaseline : "Delete Baseline",
        minimumResolutionWarning: "A minimum screen resolution of 1024 x 768 is recommended when using HP Smart Update Manager in order to ensure all functionality is available.",
		enterSSHKeyCredentials: "Enter SSH key Credentials",
		SshKeyFile: "Private Keyfile(PEM format)",
		SshKeyFilePassphrase: "Passphrase",
		SshKeyFilePassphraseHint: "Required only if a passphrase is required for the private key file"
		
    },
    dashboard : {
        age : "Age",
        sinceLastMonth : "Since last month",
        sinceLastWeek : "Since last week",
        sinceYesterday : "Since yesterday",
        totals : "Totals"
    },
    enclosure : {
        addEnclosure : "Add Enclosure",
        deviceType : "Device type",
		deployEnclosure : "Deploy Enclosure",
        embedded : "Embedded",
        ended : "Ended",
        expected : "Expected",
        hostnameOrIpAddress : "Hostname or IP address",
        link : "Link",
        longModelDescription : "Long Model Description",
        matrixEnabled : "CloudSystem Matrix enabled",
        matrixVersion : "CloudSystem Matrix version",
        measured : "Measured",
        notes : "Notes",
        started : "Started",
        units : "Units",
        usage : "Usage"
    },
    host : {
        addVmHost: "Add VM host",
        connectionError : "Encountered a communication problem with {0}. Try again.",
        history : "History",
        memoryAlloc : "Memory allocated",
        sortBy : "Sort by",
        storageAlloc : "Storage allocated",
        vCoreAlloc : "vCore allocated",
        uptime : "Uptime",
        vmHosts : "VM hosts",
        vms : "VMs"
    },
    menu : {
        deploymentTypes : "Deployment Types",
        enclosures : "Enclosures",
        sources : "Options",
        vmHosts : "VM hosts",
        welcome : "Home",
        general : "General",
        pageTypes : "Deployment Types",
        dashboard : "Dashboard",
        node : "Node",
    	ilo : "iLO",
        vc: "Virtual Connect",
        ipdu : "Intelligent Power Distribution Units (iPDU)",
        ilofederation : "iLO Federation"
    },
    group: {
    	groups : "Node Groups",
    	addGroup : "Create Node Group",//Changes done as part of HFS requirement dated 07/25/2014
    	addNew: "Add New Node Group",
    	addedNewGroup: "Added a new Node Group",
        addingNewGroup: "Adding a new Node Group",
        general: "General",
        groupName: "Node Group Name",
        enterGroupName : "Please enter Node Group Name",
		managegroups : "(Manage Groups)",
        inValidGroupName : "Should start with an alphabet followed by an alphabet, a space, - or a digit.",
        groupDescription: "Node Group Description",
        groupBaseline : "Node Group Baseline",
        groupBaselinehelp : "Select a baseline for the Node Group. Individual nodes can override this selection",
        groupHotfix : "Node Group Additional Package",
        groupHotfixhelp : "Select an additional package for the Node Group. Individual nodes can override this selection",
        description: "Description",
        groupStatus: "Node Group Status",
    groupscheduledatetime : "Node Group Schedule DateTime",
    scheduleInventoryWarning : "Performing inventory now causes the node schedules below to be cancelled",
        scheduleGroupOverviewDesc : "Updates will be scheduled for this Node Group at the time set below. The time is based on the local time where HP SUM engine is running. ",
    scheduleAddWarning : "The nodes being added to this Node Group are scheduled for deployment as below:",
    scheduledatetime : "Schedule DateTime",
    scheduleMessage : "Nodes in the Node Groups are scheduled for deployment",
    scheduleUnMatchedMessage : "One or more nodes in the Node Group have node schedules different from the Node Group schedule",
    scheduleToggleWarning : "Creating a Node Group schedule will override node schedules for the nodes below",
    scheduleDeployWarning : "Performing Deploy causes the below node schedules to be cancelled",
        selectNodes: "Select Nodes",
        deleteschedule : "Continue with Node Group schedule delete? ",
        selectAll: "Select All",
        deselectAll: "Unselect All",
        name: "Name",
        type: "Type",
        addNode: "New Node",
        addNewNode: "Add a new Node",
        edit: "Edit Node Group",
        noMoreNodesAvailable : "No more Node(s) available",
        noNodesInGroup : "No Node(s) in the Node Group",
        groupAlreadyExists: "Node Group already exists",
        status: "Status",
        addNodesToGroup: "Assign existing Node(s) to Node Group",
        removeNodesFromGroup: "Remove Node(s) from Node Group",
        editCredentials: "Change Node Group credentials",
        requiredUserName: "Required User Name along with Password",
        requiredPassword: "Required Password along with User Name",
        editedGroup: "Edited Node Group",
        groupNodes: "Node Group Nodes",
        nodeName: "Node Name",
        groupInitSummary: "Node Group initialization is in progress",
        groupNoNodesSummary: "No Node(s) in the Node Group",
		groupPendingFwUpdate: "One or more nodes are in pending firmware updates", 
		groupNodeActivatingPendingFw: "One or more nodes are activating firmware updates",
		groupIntNodePendingFw: "One or more nodes require activation of pending firmware",
        groupInActiveSummary: "Node Group is inactive",
        groupInActiveDetails: "Please Activate/Remove inactive node(s)",
        groupErrorSummary: "An error occurred on Node Group",
        groupErrorDetails: "Node Group has error node(s)",
        groupScoutingSummary: "Scouting is in progress",
        readyForInventory: "Ready to start inventory",
        startInventory: "Start Inventory",
        inventory: "Inventory",
        inventoryGroup: "Inventory Node Group",
        selectedBaseline: "Currently selected Baseline",
        selectBaseline: "Select a Baseline",
        currentlySelectedBaseline: "Currently selected baseline for this Node Group",
        currentBaselineSelected: "Current Baseline",
        additionalPackageSelected: "Current additional package",
        selectBaselineInventory: "Select the baseline you want to use to do the inventory.",
        baselines: "Baselines",
        baseline: "Baseline",
        additionalPackage: "Additional package",
        groupBaseLines: "Node Group Baselines",
        inventoryProgress: "Inventory is in progress",
        selfInventoryProgress: "Self inventory is in progress",
        startInventoryAgain: "Start inventory again",
        inventoryError: "Inventory error",
        readyForDeploy: "Ready to start deploy",
        startDeploy: "Online Review/Deploy",
        analysisProgress: "Analysis is in progress",
        analysisProgressPW: "Analysis is in progress. Please wait...",
		applyingInstallationOptions: "Applying installation options. Please wait...",
		applyingSelectionChanges: "Applying user selection changes. Please wait...",
        applicableComps: "Applicable components are repopulated after applying changes.",
        deployProgress: "Deployment is in progress",
        noApplicableComp: "Node Group is up to date. No applicable components found.", 
        deployGroup: "Deploy Node Group",
        deployErrorSummary: "Deployment error",
        deployHoldSummary: "Deployment is on hold",     
        deployDone: "Deployment done",
        deployStarted: "Deployment started",
        deletedGroup: "Deleted Node Group",
        deleteConfirm: "Continue to remove Node Group. ",
        abortConfirm: "Continue to abort Node Group operation?",
        yesAbort: "Yes, abort",
        abortedGroup: "Aborted Node Group",
        okGroupNodes: "Node(s) up to date",
        errorGroupNodes: "Node(s) with Error",
        warningGroupNodes: "Node(s) waiting or with warnings",
        inProgressGroupNodes: "Busy Node(s)",
        unKnownGroupNodes: "Node(s) in an unknown state",
        defaultName: "Default",
        defaultGroup: "This is the default Node Group",
        noBaseline: "No Baseline",
        noAdtPackage: "No additional package",
        baselineWarning: "Assigning a baseline will replace the existing baselines of all the nodes in this Node Group",
        credentialsWarning: "Changing Node Group credentials will override credentials of all nodes in this Node Group",
        noBaselineWarning: "No Baseline associated with this Node Group.<br/><br/>Select baseline(s) to apply to all nodes in this group. Applying this baseline will override the baseline assigned to the individual nodes currently. Not assigning any baseline will retain the baseline(s) that are already assigned to the individual nodes.",
        //Changes done as part of HFS requirement dated 07/25/2014
        noBaselineNodes: "No Baseline associated with the following Node(s). A Baseline should be associated with the Node Group or all of its Node(s).",
    useSchedule : "Use Node Group Schedule",
    retainSchedule : "Retain Node Schedule",
    timezone : "Node Group TimeZone"
    },
    node : {
        abortActionSuccessful : "Abort Successful",
        abortFor : "Abort for {0}",
        abortInProgress : "Abort in progress...",
        abortInstallFor : "Abort installation for {0}",
        activeProcess: "If active update process is detected on the remote node, HP SUM should",
        activeVersion : "Active Version",
        ActivationOrder: "Activation Order",
        activationDelay: "Activation Delay",
        addassociatednodes : "Auto Add Associated Nodes",
        addBaselineOptional : "(Optional) Select an already added and inventoried baseline and/or additional package to apply to this node.  If not added now, a baseline or additional package must be specified when Inventory is started on the node.",
        addBaselineOptionalGU : "(Optional) Select an already added baseline and/or additional package to apply to this node. The location from where HPSUM is running is used as the default.",
        addBaselineMandatory : "Select an already added and inventoried baseline and/or additional package to apply to this node.Components from the selected baseline(s) will be used to gather some information from the node.",
        associatedNodeDetails : "Associated Node Details",
        additionalPackages : "Additional Packages",
		additionalPackageshelp : "Components that are not part of any bundle",
        addNew : "Add New",
        addNode : "Add Node",
		addnodes : "Add Nodes",
        addedNodes : "Added Nodes",
		selectnodes : "Select Nodes",
		//adding on going activity details..
		AddingNodesMsg: "Adding Nodes",
		AddingNodesSuccessMsg: "Completed adding nodes",
		nodesAddedSuccessfully: " node(s) added successfully",
		addnodesError: "Errors while adding nodes: ",
		//Changes done as part of HFS requirement dated 07/25/2014
		addMoonshotNode : "Add Moonshot",
		addIloNode : "Add iLO",
		addIloFedarationNode : "Add iLO Federation",
		addSwitch : "Add Switch",
		addServer : "Add Server",
		addVC : "Add Virtual Connect",
		addIPDU : "Add iPDU",
		addGroup : "Add Group",
		addEnclosure : "Add Enclosure",
		addVmWare : "Add VM Host",
        agentlessManagementService : "Agentless Management Service",
        always : "Always",
        analysis : "Analysis",
        applicableComponents : "Applicable Components",
        assignTo : "Assign to",
	assignTohelp : "Optional: The node can be assigned to an existing node group.",
	addHelp : "Enter a single IP or DNS name (ex: 10.1.2.3 or server.ab.com) <br>Enter Multiples using comma seperator (ex: 10.1.2.3, 10.1.4.45) <br>Enter ranges using a dash (ex: 10.2.3.51 - 10.2.3.64)",
        assignNewBaseline : "Assign a new baseline to the node.",
        availableNodes : "Available Nodes",
        availableVersion : "Available Version",
	cancelSchedule : "DeleteSchedule",
        cannotDelete : "Cannot delete localhost!",
        close : "Close",
        combinedReport: "Combined report",
		combinedReporthelp : "All report types in one file.",
        componentDetails : "Component Details",
        compFailedDep : "Components with failed dependencies selected",
        compSelect : "{0} Components Selected",
        compSelectZero : "0 Components Selected",
        cpuSockets : "CPU Sockets",
        csv : "CSV",
		csvhelp : "Generates reports in CSV format that can be opened in any application that supports CSV format.",
        currentBaselineSelected : "Current baseline selected",
        currentlySelectedBaseline : "Currently selected baseline for this node",
        currentStatus : "Current Status",
        daily : "Daily",
        dayOfEveryMonth : "day of every month",
        days : "days",
	deleteschedule : "Continue with schedule delete? ",
	deletenode : "Continue with delete? ",
        deleteNodes: "Delete the node(s).",
        deploy : "Deploy",
        descriptionPlaceholder : "Description placeholder",
        doActionDeploy : "Ready for deployment.  Deploy",
        doDeploy : "Deploy",
        dummyIpAddress : "99.99.99.240",
	duplicateNode : "Node already added. Use Edit Node option to change attributes",
	invalidIP : "Invalid IP/DNS name entered",
        enableSchedule : "Enable schedule",
        encryptionKey: "Encryption Key *",
        encryptionKeyHelp: "Requires minimum 8 characters",
        encryptionSettings: "VC FIPS Encryption Settings",
        enterAssociatedOADetails: "Enter associated Onboard Administrator details",
        enterIPAddress : "Enter IP Address",
        enterPartnerIpduDetails: "Enter Partner iPDU Details",
        enterRebootMessage : "Enter reboot message",
        errorPleaseSelectBaseline : "Error - Select baseline",
        estimatedDeploymentTime : "Estimated deployment time: 15 mins",
	EnetOrder : "VC Enet Modules Activation Order",
	EnetDelay :"VC Enet Modules Activation Delay",
	FCDelay: "VC FC Modules Activation Delay",
	Fips_VC_Msg: "Note: If FIPS support is enabled on the Virtual Connect (VC), perform deploy from the Virtual Connect(VC) node deploy page where 	FIPS settings and other options can be set.",
        
        every : "Every",
        failedAnalysis : "Analysis failed.",
        failedDependencyDetails : "Failed dependency details",
		failedDependencyDetailshelp : "This report provides information about the failed dependencies for the node.",
        family : "Family",
        fibreChannelSwitch : "Fibre Channel Switch",
        filteringIsInProgressPleaseWait: "Filtering Components. Please wait...",
        findNodeRange : "Find Node Range",
        firmwareDetails: "Firmware details",
		firmwareDetailshelp : "This report provides information about the firmware versions that are currently installed on the node.",
        first : "First",
	FCOrder: "VC FC Modules Activation Order",
        forceOptions : "Force Options",
        forceOptionFirmware : "Firmware",
        forceOptionMessage  : "Firmware and Software options must be used in conjunction with Downgrade and/or Rewrite options.",
        forceOptionSoftware : "Software",
		forceOptionSoftwareError : "Firmware and/or Software option must be selected.",
        forceOptionsCanBeAppliedTo : "Firmware/Software options can be applied to",
        fourth : "Fourth",
        friday : "Friday",
        generate : "Generate",
        hpSasBlInterconnectSwitch : "HP SAS B/L Interconnect Switch",
        html : "HTML",
	htmlhelp : "Generates reports as HTML files that you can view in a JavaScript-enabled web browser.",
        ifNeeded : "If needed",
        iloHpCom : "ilo.hp.com",
        installableDetails : "Deploy preview",
	installableDetailshelp : "This report provides information about components that HP SUM would install on the node",
        iLOFedTechPreviewWarning : "The current version of HP SUM only provides a technology preview of iLO Federation.  Firmware Deploy functionality is unavailable in this version.",
	installDone : "Install done.",
        installDoneWithErrors: "Install done with error(s)",
        installDoneSee : "Install done. See component logs for more information.",
        installDoneSeeErrors : "Install done with error(s). See component logs for more information.",
        installProgress : "Install in progress.",
        installProgressMoonshot : "Install in progress. This deploy may take several minutes per cartridge in the system.",
		compVerboseLog : "Component verbose log",
        installationOptions : {
            applyingOptions : "Applying Installation options...",
            optionsSuccess : "Successfully applied installation options",
            message : "Installation Options allow you to choose Downgrade, Rewrite and other settings.",
            help : "Upgrade/Downgrade/Rewrite options",
            header : "Installation options",
            options : "Options",
            upgradeBoth : "Upgrade Both – Allow upgrades to already installed components and installation of new software packages",
			upgradeFirmware : "Upgrade Firmware - Allow upgrades to newer versions of already installed firmware components",
			upgradeSoftware : "Upgrade Software – Allow upgrades to already installed software and installation of new packages",
            downgradeFirmware : "Downgrade Firmware - Allow downgrades to older versions of already installed firmware components",
            downgradeSoftware : "Downgrade Software - Allow downgrades to older versions of already installed software components",
            downgradeBoth : "Downgrade Both - Allow downgrades to older versions of already installed components",
            rewriteFirmware : "Rewrite Firmware - Allow the same version to be rewritten for already installed firmware components",
            rewriteSoftware : "Rewrite Software - Allow the same version to be rewritten for already installed software components",
            rewriteBoth : "Rewrite Both - Allow the same version to be rewritten for already installed components",
            firmware : "Downgrade & Rewrite Firmware - Allow already installed firmware components to be downgraded or rewritten to older or same version",
            software : "Downgrade & Rewrite Software - Allow already installed software components to be downgraded or rewritten to older or same version",
            both : "Downgrade & Rewrite Both - Allow already installed components to be downgraded or rewritten to older or same version"
        },
        installedDetails : "Deploy details",
	installedDetailshelp : "This report provides information about what HP SUM installed on the node.",
        installedBios : "Installed BIOS",
        installedIlo : "Installed iLO",
        installedPowerpic: "Installed PMC",
        installedCPLD: "Installed CPLD",
	installedVersion : "Installed version",
        installing : "Installing",
        intelligentPowerDistributionUnit : "Intelligent Power Distribution Unit (iPDU)",
	invalid : "Invalid IP Address or Range specified",
		invalidBaseline : "Please select a valid baseline",
		invalidAdtPackage : "Please select a valid additional package",
        inventory : "Inventory",		
	inventoryhelp : "This report provides information on the applicable components  in the specified baseline.",
        inventoryInProgress : "Inventory in progress.",
	ip : "IP Address",
        ipCannotBe : "IP cannot be",
	ipend : "End IP Address",
	iprangeError1 : 'There can be only two IPs separated by "-" provided as an IP range',
	iprangeError2 : "Start and end IP provided in an IP range cannot be same",
	iprangeError3 : "Start IP cannot be greater than end IP provided in an IP range",
	iprangeError4 : 'The first three numbers of IPs separated by "-" must be same',
	ipstart : "Start IP Address",
	ipdu : "iPDU",
        keyPemForSshAuth : "PEM key for SSH authentication access",
        last : "Last",
        leaveAlone :"Leave the update running and bypass the node",
        monday : "Monday",
        monthly : "Monthly",
        needAssociatedOADetails: "Requires associated Onboard Administrator credentials to continue inventory",
        needAssociatediPDUDetails: "Requires partner iPDU credentials to continue inventory",
		never : "Never",
        no : "No",
        noAddedNodes : "No nodes added!",
        noApplicableComponentsFound : "No applicable components found",
        noFoundNodes : "No nodes found!",
        noItemsFound : "No items found!",
        firewallBlocking : "Verify no firewalls are blocking HTTP/FTP traffic between the system running HPSUM and the remote node.",
        noAssociatedNodes : "No associated nodes found!",
        noBaselineAvailable : "No baseline available to proceed with deployment.",
        noBaselineDefined: "No baseline defined",
        nodesBelowList: "Nodes selected from the below list will be deployed along with {0}.",
	nodeCount : "{0} Node(s)",
        nodeDetails : "Node Details",
        nodeInventoryInProgress : "Node inventory in progress ...",
        nodesPopulatedAfterSearch : "Nodes will be populated after search.",
        nodeUpToDate : "Node up to date",
		node_name : "DNS Node Name",
        nodeNotReady : "Node not ready for deployment.",
        none : "None",        
        notValidIpOrDns : "Not a valid IP (IPV4/IPV6) or DNS",
        ofEveryMonth : "of every month",
        offlineDeploy: "Offline Deploy",
        offlineReviewDeploy: "Offline Review/ Deploy",
        onboardAdministrator : "Onboard Administrator",
        one : "One",
        onlineDeploy: "Online Deploy",
        onlineReviewDeploy: "Online Review/ Deploy",
        optional: "Optional",
        openFirewall : "Click here to open the HP SUM ports in firewall and start inventory", //"Open Firewall",
        openFirewallMsg : "HP SUM ports are blocked in firewall", //"Restart HP SUM with open_firewall option or click here to open the ports",
        openFirewallSuccessNotifMsg : "HP SUM ports unblocked successfully for ",
        openFirewallErrorNotifMsg : "Failed to unblock HP SUM ports for ",
        openFirewallInventoryStartNotifMsg : "Inventory has started for the node ",
        openFirewallInventoryErrorNotifMsg : "Failed to start inventory for the node ",
        openFirewallDeploy : "Click here to open the HP SUM ports in firewall and start deploy",
        openFirewallDeployStartNotifMsg : "Deploy started for the node ",
        openFirewallDeployErrorNotifMsg : "Failed to start deploy for the node ",
        osManagementOptions : "OS Management Options",
        phase: "Phase",
        pleaseSelectAPorB: "Please select a Baseline or Additional Package.",
        pleaseSelectType : "Please select a type.",
        pleaseSelectCorrectNode : "Please select the correct node.",
        proliantBl460cG7 : "ProLiant BL460c G7",
        readyForDeploy : "Ready for deployment.",
        rebootAndForceOptions : "Reboot and Force Options",
        rebootDelay : "Reboot Delay (60-3600 Seconds)",
        rebootMessage : "Reboot at user request after deploy",        
        rebootMessageLength : "Message up to 255 characters",
        rebootOptions : "Reboot Options",
        rebootSystemAfterInstallation : "Reboot system after installation",
		nodeTypeErrorMessage: "Select a node type.",
		nodeNameErrorMessage: "Provide a valid IP/DNS or range.",
		nodeCredentialsErrorMessage: "Provide the credentials with administration privileges or member of a administrators group.",
		nodeSudoCredentials: "Provide the Sudo credentials.",
		nodeUsername: "Provide the Username",
		nodePassword: "Provide the Password",
		validationErrorMsg : "Validation errors - Field value(s) required",
	rebootRequired : "Reboot required after install",
   	refresh: "Refresh",
	runNow : "DeployNow",
	nodeRebooted : "Node is rebooted",
	rangeIpsNotOfSameType : "Please provide start IP and end IP of same type - IPV4 or IPV6.",
	rangeNotInSameSubnet : "Please provide start and end IP address from same subnet mask.",
	rebootDelaySecondsErrMsg : "Valid reboot delay required",
	rebootDelayNotANumber: "Please enter a number here",
        recurEvery : "Recur every",
        replaceSession: "Stop any currently running update process on the node and replace it with updates from this session",
        reports : "Reports",
        reportsDesc : "Reports description (TBD)",
        reportInProgress : "Report generation is in progress",
        required : "Required",		
		invalidIPV4orIPV6: "Enter valid IP (IPV4/IPV6)",
        reviewDeploy : "Review/ Deploy",
        reviewAndDeploy: "Review and deploy updates",
		reportsLocationMessage: "All Reports are located at: ",
        saturday : "Saturday",
        sd2HasErrors : "SD2 has FW analysis errors. Check the Deploy screen for details",
        sd2HasWarnings : "SD2 has FW analysis warnings. Check the Deploy screen for details",
        scanning : "Scanning",
        schedule : "Schedule",
		schedulehelp : "Options to schedule the deployment",
	scheduledate : "Schedule Date",
	scheduletime : "Schedule Time [hh:mm (24hr) format]",
	scheduledeploy : "Schedule Deploy",
        scheduleNodes : "Schedule Nodes",
	scheduleset : "Schedule is set at ",
        scheduleOverviewDesc : "Updates will be scheduled for this node at the time set below. The time is based on the local time where HP SUM engine is running. ",
	scheduletimeformat : "Time should be entered in hh:mm (24 hr) format",
        searchIsInProgressPleaseWait : "Search is in progress. Please wait...",
        second : "Second",
        selectBaseline : "Select the baseline you want to associate with this node",
        selectBaseline2 : "Select the baseline you want to use to do the inventory",
        selectType : "Select Type",
        serial : "Serial",
        servers : "{0} Servers",
        shutdownNodeDeploy: "The following nodes are scheduled for deployment. The deployments for these nodes will occur at the scheduled time even if HP SUM engine is shutdown:",
        shutdownNodeError: "Shutdown cannot be done, because one or more nodes are currently doing operations that cannot be aborted. Manually abort those nodes; then, proceed to shutdown.",
        start: "Start",
        sunday : "Sunday",
		superdome2onboardAdministrator : "Superdome 2 Onboard Administrator",
		moonshot : "Moonshot",
        the : "The",
        third : "Third",
        thisNodeAlready: "This node was already added.",
        three: "Three",
        thursday : "Thursday",
        tuesday : "Tuesday",
		type : "Node Type",
        two : "Two",
        vcOptionstitle:"Virtual Connect Options",
        virtualConnect : "Virtual Connect",
        useCredentialsAbove : "Use credentials above",
	useroptions : "User Options",
        userSshAuth : "User SSH Authentication Access",
        useSnmp : "Use SNMP",
        useWebem : "Use WBEM",
        vmWareHost : "VMware host",
        vmwareRewriteWarning: "VMware does not support rewrite of driver components.",
		vcOptions : "VC Activation Options",
		vcOptionsMsg : "VC options such as VC activation order can be set via the Edit Node or Review/Deploy pages.",
    vcFIPSEncryptionKeyHelp : "VC Domain is in FIPS mode. Encryption Key is mandatory (minimum 8 characters)",
	vcDomainNotConfigured: "VC Domain not configured. Please configure domain to discover and update firmware",
        waitingforAssoc : "Waiting for associated node to finish installation.",
        waitingforComp : "Waiting for component information...",
	pendingfwUpdate : "The firmware update is pending. Waiting for associated nodes to finish installation",
	activatingPendingfwUpdate : "Activating the pending firmware update",
        wednesday : "Wednesday",
        weekly : "Weekly",
        weeks : "weeks",
        xml : "XML",
	xmlhelp : "Generates reports as XML files that you can view in a JavaScript-enabled web browser.",
        selectReportTypes : "Select Report Types",
        selectReportFormats : "Select Report Format",
        advancedReportOptions : "Advanced Report Options",
        runbackReport : "Generate Report in Background",
	    runbackReporthelp : "Check this box to hide the dialog window",
        analysisProgress : "Analysis is in progress. Please wait...",
	    applicableComps : "Applicable components are re-populated after analysis",
        runningReportInBack : "Report generation running in Background for {0}.",
        runningReportInBackMulti : "Report generation running in Background for Multiple Nodes.",
        doneReportMulti : "Report generated successfully for Multiple Nodes.",
        partialReportMulti : "Report generated Partially for Multiple Nodes.",
        failedReportMulti : "Failed to generate Report for Multiple Nodes",
        referForReportStatus : "Please refer Activity screen or Reports Center for the report details",
        doneReport : "Report generated successfully for {0}",
        failedReport : "Failed to generate Report for {0}",
        pleaseWait : "Please Wait...",
        partialReport : "Report generated Partially for {0}",
        viewLogs: "View installation log(s)",
        installationLogs : "Installation logs",
        logDetails : "Log details",
	nodeName : "Node(s)",
	nodeScheduled : "Node is scheduled for deployment at ",
        timeStamp : "Generated At",
		reportLocationPath: "Report Path",
        reportFormat : "Format",
        reportStatus : "Status",
        reportDelete : "Delete?",
        completed : "Completed",
        partiallyCompleted : "Partially Completed",
        inProgress : "In Progress",
        failed : "Failed",
        firmWareType : "Firmware",
        installableType : "Installable",
        installedType : "Installed",
        failledDepencyType : "Failed Dependency",
        reportPath : "Location",
        noReports : "No Reports Available",
        allReports : "Reports Center",
        deleteReportConfirm: "Continue with Delete Report?",
        vcDomain: "VC Domain",
        vcModules: "VC Modules",
        viewDetails : "View Details",
		accessType : "Access Type",
		requiresTrustRelationship : "Requires existing trust relationship with the node.",
		nodeCommonPanel : {
		always : "Always reboot after installation",
		applyTo : "Apply to:",
		assignBaseline : "Assign different baseline",
		autoAddAssoNodes : "Automatically add associated nodes",
		forceOptionAll : "All components",
        forceOptionFirmware : "Only firmware components",
		forceOptionSoftware : "Only software components",
		ifNeeded : "Reboot after installation if needed",
		installationforceOptions : "Installation / Force Options",
		suUsername : "su Username",
		suPassword : "su Password",
		rootCredentials : "Enter root level credentials",
		sudoCredentials : "Enter user with Sudo permissions credentials",
		selectManagementOptions : "Select Management Options to Install",
		noManagementOptions : "Select no Management Options",
		normalCredentials : "Enter normal user and su user credentials",
		noreboot : "Do not reboot after installation",
		currentCredentials : "Use current credentials",
		assoAddPack : "Additional Package at",
		assoBaselineSPP :"SPP at ",
		baselineSelection : "Baseline selection"
		},
	liveLog : "LiveLog",
	liveLogInstalling : "Deploying the package ",
    liveLogInstalled : "Deployed the package ",
	liveLogInprogress : "Deploy in progress ",
	liveLogCompleted : "Deploy Completed "
    },
    notLocalized : "FIXME: NOT LOCALIZED",
    oneTouchUpdate : {
        actionTitle : "Localhost Guided Update",
        activation : "Activation",
        activeVersion : "Active Version",
	addBaseline: "Add Baseline",
	addBaselineOptional: "(Optional) Select an already added and inventoried baseline and/or additional package to apply to this node.",
        addBaselines : "Select baselines",
        addBaselinesError : "Failed to get results",
	additionalPackage: "Additional Package",
        addNodes : "Select Nodes",
        addedNode : "Added node",
        advancedOptions : {
			applyFilters : "Apply Filters",
            dayOfEveryMonth : "day of Every month",
            days : "days",
            downgrade : "Downgrade",
            enableSchedule : "Enable Schedule",
            enterRebootMessage : "Enter reboot message",
            firmware : "Firmware",
            forceOptions : "Global Force Options",
            installOptions : "Global Install Options",
            ofEveryMonth : "of Every month",
            reboot : "Global Reboot Options",
            rebootDelay : "Reboot Delay (60-3600 Seconds)",
			rebootDelaySecondsErrMsg : "Valid reboot delay required",
            rebootDelayNotANumber: "Please enter a number here",
            rebootMessageLength : "Message up to 255 characters",
            rebootNodesAfterInstallation : "Reboot nodes after installation",
            rebootOptions : "Global Reboot options",
            recurEvery : "Recur every",
            rewrite : "Rewrite",
            schedule : "Schedule",
            scheduleOptions : "Schedule options",
            software : "Software",
            title : "Advanced options"
        },
		
        applicableComponents : "- applicable components",
	assignBaseline: "Assign Baseline",
        availableVersion : "Available Version",
        analyze : "Analyze",
	assoAddPack: "Additional Package at ",
	assoBaselineSPP: "HP Service Pack for ProLiant at ",
        baselineAdded : "Baseline added",
	baselineNodeInvTitle: "Inventory of baseline and node",
        baselines : "Baselines",
	baselineSelection: "Baseline Selection",
        component : "Component",
        componentDetails : "Component details",
        componentDetailsFor : "Component details for {0}",
        componentHelp : "Component help",
        componentLog : "Component log",
        componentTitle : "Component title",
        componentVersion : "Component Version",
		criticality : "Criticality",
        confirmAutoUpdate : "Continue with full automatic inventory and deploy all suggested updates on the system running HP SUM?",
        deployment : "Deployment",
        deploymentCompleted : "Deployment completed",
        deploymentError : "Deployment error",
        deploymentInProgress : "Deployment in progress",
        deploymentLog : "Deployment log",
        deploymentResults : "Deployment results",
        deploymentStatus : "Deployment status",
        deploymentSummary : "Deployment summary",
        enterCredentials : "Enter credentials",
        enterPassword : "Enter password",
        enterUserName : "Enter user name",
	errorDeployProgress: "Currently node deploy is in progress, cannot change the baseline.",
	errorInvProgress: "Currently node inventiory is in progress, cannot change the baseline.",
        failedToAddBaseline : "Failed to add baseline",
        failedToAddNode : "Failed to add node",
        family : "Family",
        force : "Force",
        forced : "Forced",
        installedVersion : "Installed Version",
        interactive : "Interactive",
        inventory : "Inventory",
        inventoryBaselineNode : "Inventory of baseline and node",
        inventoryOfBaseline : "Inventory of baseline",
        inventoryOfNode : "Inventory of Localhost",
        localhostOnly : "Localhost only",
        log : "Log",
        manageBaselines : "Add Baselines",
        manageNodes : "Add Nodes",
        mode : "Mode",
	moreBundles: "Multiple baselines found in the location ",
        moreDetails : "Automatic mode will inventory and deploy all applicable updates without user interaction on the system running HP SUM.",
        multipleNodesBaselines : "Multiple nodes/baselines",
	noBaselineDefault : "No default baseline found.",
	noCompFound: "No components found at the location",
        noComponentsInstalled : "No components were installed.",        
        nodeInventoryAborted : "Node inventory aborted",
	nodeInventoryTitle: "Inventory of node",
        nodeDeployAborted : "Node deploy aborted",
        nodes : "Nodes",
        nonInteractive : "Automatic",
	onlyOneAllowed: ". Only one baseline is acceptable in the specified location.",
        overview : "Overview",
        packageStr : "Package",
        password : "Password",
        reboot : "Reboot",
		localhost : "Localhost",
		alreadyadded : "Already added node",
		newnode : "New node",
		node : "Node",
	rebootDelayErrMsg : "Enter delay value between 60 and 3600 seconds",
	never : "Never",
        reports : {
            csv : "CSV",
            description : "Description",
            failedDependencyDetails : "Failed Dependency details",
            firmwareDetails : "Firmware details",
            html : "HTML",
            installableDetails : "Installable details",
            installedDetails : "Installed details",
            overview : "Overview",
            reports : "Reports",
            type : "Type",
            xml : "XML"
        },
        review : "Review",
		select : "Select",
		selectComponents : "Select Components",
		selected : "Selected",
        selectModeTypeDeployment : "Select deployment mode",
        statusStr : "Ready to proceed",
        step : "Step",
        title : "Localhost Guided Update",
        useCurrentCredentials : "Use current credentials",
        useCurrentCredentialsHelp : "Select to use current credentials",
        userAborted : "Aborted by user",
        userAbortedError : "Error occurred while aborting operation",
        userName : "User name",
        viewLog : "View log",
		warningsSummary: "Deploy may encounter issues due to the following warning(s): ",
		warningsHead: "Warnings/Alerts"
    },
    server : {
        addServer : "Add server",
        advancedMemoryProtection : "Advanced Memory Protection",
        cpu : "CPU",
        controller : "Controller",
        controllerFV : "Controller Firmware Version",
        defaultStr : "Default",
        defaultEnabled : "Default enabled",
        defaultOn : "Default On",
        deviceWriteCache : "Device write cache",
        diskFV : "Disk Firmware Version",
        driverVersion : "Driver version",
        editSettings : "Edit settings",
        embeddedSataConfiguration : "Embedded SATA Configuration",
        embeddedSerialPort : "Embedded serial port",
        intelAmdVirtualizationTechnology : "Intel/AMD Virtualization Technology",
        intelHyperthreadingOptions : "Intel Hyper-threading options",
        intelTurboBoostTechnology : "Intel Turbo Boost Technology",
        intelVtdAmdVi : "Intel VT-d/AMD-Vi (IOMMU)",
        manageBios : "Manage BIOS",
        managedByFusion : "Managed by HP OneView",
        memory : "Memory",
		group : "Node Groups",
        modified : "Modified",
        modifiedSettings : "Modified settings",
        msExchange : "Microsoft Exchange 2010 Gold, 5000 Users",
        nicFcHbaCna : "NIC/FC-HBA/CNA",
        noExecuteMemoryProtection : "No-Execute Memory Protection",
        noSupportedNicFcHbaCnaFound : "No supported NIC/FC-HBA/CNA found",
        noSupportedStorageArraysFound : "No supported storage arrays found",
        numlockPowerOnState : "NUMLOCK Power-On State",
        onlineSpareWithAdvancedEccSupport : "Online spare with advanced ECC support",
        npar: "nPar",
        optimizedForLowPower : "RM-Optimized for low power",
        optimizedForPerformance : "Optimized for performance",
        processorOptions : "Processor options",
        proliant : "Proliant BL460c G7, mezz1",
        sataControllerOptions : "SATA controller options",
        serialNo : "Serial no",
        serialPortConfiguration : "COM2; IRQ3; IO: 2F8h-2FFh",
        serialPortOptions : "Serial port options",
        serverType : "Server model",
        storage : "Storage",
        systemOptions : "System options",
        systemRomVersion : "System ROM version",
        tbd : "TBD",
        virtualSerialPort : "Virtual serial port",
        virtualSerialPortConfiguration : "COM1; IRQ4; IO: 3F8h-3FFh",
        stage : "Stage",
        stageslashDeploy: "Stage/Deploy",
        stageandDeploy: "Stage and Deploy",
        stageDeploy: "Staged Deploy",
        startStageDeploy : "Start deploy after staging"
    },
    shell : {
        serverFirmwareDistribution : "Server firmware distribution",
        switchPortsInUse : "Switch ports in use",
        terrabytesInUse : "Terabytes in use"
    },
    switchUI : {
        activeFirmwareVersion : "Active firmware version",
        adapterPort : "Adapter port",
        added : "Added",
        address : "Address",
        addressType : "Address type",
        addSwitch : "Add switch",
        allCategories : "All categories",
        average : "Average",
        bandwidthGbs : "Bandwidth GB/s",
        bitTransferRate : "Bit transfer rate",
        connectionState : "Connection state",
        connectivity : "Connectivity",
        connector : "Connector",
        deleted : "Deleted {0}",
        detailsTitle : "Details title",
        devices : "Devices",
        discoveredTime : "Discovered time",
        doThis : "do this",
        downlinks : "Downlinks",
        ethernet : "Ethernet",
        extended : "Extended",
        fibreChannel : "Fibre Channel",
		FTPUpdatesFailure : "FTP server on the HP SUM Service is currently not running. The switch inventory requires ftp server to be enabled and running. <br>Enable ftp port, restart the HP SUM service and then perform switch Inventory.",
        flexNic : "Flex NIC",
        hasStatus : "{0} has a {1}.",
        identifier : "Identifier",
        linkState : "Link state",
        noConnectionsDiscovered : "No connections discovered",
        networks : "Networks",
        oui : "OUI",
        packetTransferRate : "Packet transfer rate",
        partnerSwitch : "Partner switch",
        partNumber : "Part number",
        port : "Port",
        portDescription : "Port description",
        portId : "Port ID",
        portType : "Port type",
        received : "Received",
        receivedErrors : "Received errors",
        remoteConnection : "Remote connection",
        revision : "Revision",
        serialNumber : "Serial number",
        serverHardware : "Server hardware",
        serverProfile : "Server profile",
        speed : "Speed",
        statistics : "Statistics",
        systemDescription : "System description",
        systemName : "System name",
        toFixIt : "To <b>Fix</b> it, {0}",
        transmitErrors : "Transmit errors",
        transmitted : "Transmitted",
        transmittedErrors : "Transmitted errors",
        updated : "Updated",
        uplinks : "Uplinks",
        vendor : "Vendor",
        weHaveNoIdeaWhy : "Notification is undefined.",
        writtenFirmwareVersion : "Written Firmware Version",
        wwn : "WWN"
    },
    task : {
        active : "Active",
        alerts : "Alerts",
        allTime : "All time",
        assign : "Assign (TBD)",
        clear : "Clear",
        cleared : "Cleared",
        finished : "Finished",
        from : "From",
        lastUpdated : "Last updated",
        mine : "Mine",
        olderThan1Year : "Older than 1 year",
        olderThan3Months : "Older than 3 months",
        pending : "Pending",
        resetToDefaults : "Reset to defaults",
        running : "Running",
        selectAll : "Select all",
        source : "Source",
        specificDateRange : "Specific date range",
        to : "To",
        today : "Today",
        withinLastMonth : "Within last month"
    },
    integrityilo : {
 		haspendingupdate : "Node has a pending firmware update",
 		hasprevious : "{0} has a previous firmware update pending activation.",
 		activateorcancel : "Activate or cancel pending firmware update.",
 		activatepending: "Activate pending",
 		pendingwarning: "Firmware updates cannot be performed on the node until the previous firmware update is either activated or canceled.",
 		activatependingfw: "Activate the pending firmware update",
 		activatependingWarning: "This will shutdown the OS on the node and let the firmware activation process complete",
 		cancelpendingfw: "Cancel the pending firmware update",
 		cancelpendingWarning: "WARNING: This may leave the system with an unbootable mix of iLO/System FW. Only use this if you are about to upgrade this server to a new version.",
 		doDeployDomain : "Review and Deploy updates to Domain",
        deployDomain: "Deploy Domain",
        rebootToActivate: "Reboot node to activate firmware",
        rebootNotNeeded: "Reboot is not required. The node is powered off",
        activateOnNodeScreen: "Node has a pending firmware update. The pending firmware update can be activated or canceled from the node screen"
    },
    sd2oa: {
        activeFirmware: "Active Firmware",
        allDevices: "All Devices",
        bay: "Bay",
        blades: "Blades",
        cplxFW: "Complex Firmware",
        cplxMismatchDetails: "Complex mismatch details",
        complexName: "Complex Name",
        complexOnly: "Complex Only",
        complexVer: "Complex Version",
        fwBaseline: "Firmware Baseline",
        installedFW: "Installed Firmware",
        mismatch: "Mismatch",
        noActivePartitions: "No active partitions.",
        noBladesUnassigned: "No unassigned Blades.",
        noPartitions: "No available partitions.",
    	number: "Number",
    	parFW: "Partition Firmware",
    	partitions: "Partitions",
    	partitionsBlades: "Partitions / Blades",
        rebootActivePartitions: "Reboot active partitions",
    	serialNumber: "Serial Number",
    	unassignedBlades: "Unassigned Blades",
    	vpars: "vPars"
    },
    moonshot: {
       chassisName: "Chassis Name",
       credentials: "iLO CM Administrator Credentials",
       edit: "Edit Moonshot switch credentials",
       enablePassword: "Enable Password",
       failedtoValidateSwitchCredentials: "Failed to verify Moonshot switch credentials",
       invalidSwitchCredentials: "Invalid switch credentials",
       productName: "Product Name",
       noCartridges: "No cartridges found.",
       noSwitches : "No switches found.",
       serialNo: "Serial Number",
       switchCredentials: "Switch Credentials",
       switchBCredentials: "Switch B Credentials",
       switchUseSameCredentials: "Credentials are the same on both switches",
       productID: "Product ID",
       uuid: "UUID"
    },
    ipdu : {
        extbars: "Ext Bars",
        noExtBars: "No supported Ext bars found.",
        paired: "Paired IPDU"
    },
    title : "HP Smart Update Manager ",
    welcome : {
        baselinesDescription : "Manage firmware and system software baselines",
        dashboardDescription : "Overview of what is happening with your infrastructure",
        getStarted : "Get started",
        scalableUpdateDescription: "Scalable update powered by iLO Federation",
        nodesDescription : "Manage, analyze, and deploy updates to nodes",
        oneTouchUpdateDescription : "Simplified deployment in three steps"
    },
    
    AbortConfirm : {
            title : "Abort {0}",
            dependencyHeader : "{0} items depend on {1}",
            prompt : "Continue with delete?",
            ok : "Yes, Abort"
	},
	
	RebootConfirm : {
            title : "Reboot",
            dependencyHeader : "{0} items depend on {1}",
            errorReboot : "Error occurred while performing reboot operation.",
            node : "Node rebooted.",
            prompt : "Are you sure you want to reboot the node?",
            ok : "Yes, Reboot"
	},
	confirmation : {
            title : "Confirmation",
            dependencyHeader : "{0} items depend on {1}",
            prompt : "Are you sure you want to continue with the selected action?",
            promptDeploy : "Are you sure you want to continue with deploy?",
            ok : "Yes, Continue"
	},
	logout : {
            logoff : "Log Off - Current user.",
            shutdown : "Shutdown - This option will shutdown HP SUM engine.",
            title : "Log Off/Shutdown"
       },
	shutdown : {
		title : "ShutDown",
		shutdown : "Continue with shutdown of HP SUM engine?",
		ok : "Yes, Shutdown",
		cancel : "Cancel",
		shutdownButton : "Shutdown"
		},
    linuxAccess : {
           useAdminCredentials: "Use administrator credentials",
           useSudoWithCredentials: "Use sudo with credentials entered above",
           useSuperUserCredentials: "Use super user credentials"
       },
    ilofederation : {
        viewversion : "View all versions of :",
        ilotype : "iLO type",
        powerpictype: "PMC type",
        cpldtype:"CPLD type",
        isoimage: "ISO Image",
        filtering: "Filters",
        filterMsg: "Select a subset of servers within the group to perform the update on",
        groupInActiveSummary : "Group is being discovered",
        interfaceilo: "Interface iLO",
		onlinedeploymessage: "<br>Online Deploy applies the update while the OS is up and running.<br>Reboot may be needed to activate the update. Reboot must be done manually to activate.",
        inventoryError : "Inventory error",
        enterManual: "Enter an iLO manually by IP or DNS",
        offlinedeploymessage: "HP SUM will use iLO to mount the specified ISO image to all servers in the group and then reboot all of the servers in the group. If the ISO is a valid update ISO, all servers will run an automatic offline update and then reboot",
        additionalofflinedeploymessage : "All Applicable updates on the ISO baseline will be performed on the specified servers.",
		selected: "Selected",
        selectDiscovered: "Select from discovered list of member iLO IPs",
        useISOandhpsum: "Use local ISO image and HP SUM as HTTP server",
        useISOandother: "Use ISO on a user specified HTTP server",
        add : "Add group",
        edit : "Edit scalable update group",
        editError : "Failed to edit scalable update group",
        deletemsg : "Deleted scalable update group",
        addedbyUser: "Auto discovered",
        iLOFederationGroup: "iLO Federation group",
        lastDiscovered : "Last discovered on",
        groupname: "iLO Federation group name",
        groupDescr : "iLO Federation group description",
        rebootAndDeploy: "Power off and Deploy",
        offlineDeployConfirmHeader: "Confirm Offline Deployment",
        offlineDeployConfirmMsg: " server(s) will be immediately powered off if needed and rebooted to the specified ISO to start automatic offline update.",
        confirmOk: "Continue with Reboot",
        filternotSelectedError: "Please select at least one server model filter",
        abortedGroup: "Aborted iLO Federation Group",
        abortConfirm:"Continue with abort operation?",
		validISOrequired: "Please enter a valid Service Pack for ProLiant ISO URL.",
        addGroup : "Add Group",
        powerByIloFederation:" - powered by iLO Federation",
        rescan:"Rescan",
		noIloDiscovered: "No iLO discovered",
        notOnNetwork: "Unable to find the previously discovered iLO Federation group on the network",
        selectall:"Select All",
        deselectall:"Deselect All",
        deleteConfirm: "Continue with the deletion of iLO Federation group?",
        addTextInfo: "Enter an existing iLO Federation group name for HP SUM to work with. iLO Federation groups can be created in the iLO management user interface.",
        addextraTextInfo: "After the iLO Federation group has been added, go to the Inventory page to complete setting up the group so HP SUM can work with it.",
        editTextInfo: "Edit group allows you to modify iLO Federation group information so HP SUM can work with the group. You cannot modify the contents of the group from HP SUM. The contents of the iLO Federation group can be modified in the iLO management user interface.",
        enterCredentialsDescription:"Please enter the credentials for the interface iLO IP address specified above.",
        iLOFederationFWItemDetails : "Inventoried firmware versions of the group",
        numNodes:"Group iLO node count",
        poweredOnServersCount: "Powered On servers count",
        serverModel : "Server Model",
        onlineDeploy: "Online deploy",
        validateInProgress: "Validating ISO image. Please wait...",
        isoUrlEmpty: "ISO image URL cannot be empty",
        gatherServerInfo:"must be performed to gather iLO Federation group member details",
        selectedModel: "Selected {0} for deploy, Click Apply Filters button to apply the filters",
        deselectedModel: "Deselected {0}, Click Apply Filters button to apply the filters",
        allselected: "All server models selected for deploy, Click Apply Filters button to apply the filters",
        alldeselected: "All server models deselected, Click Apply Filters button to apply the filters",
        requiredFieldMissing : "Required Field {0} is empty.",
        toassignInterfaceIlo : "to assign an interface iLO to this group",
        notDiscoveredinthisSession: "This iLO Federation group can not be discovered in this HP SUM session. Please rescan to check if this group still exists"
    },
    thankyou: {
        shutdown:  "HP Smart Update Manager has been successfully shutdown",
        thank: "Thank you for using HP Smart Update Manager",
        reference_videos:"Some reference documentation and videos."
    }
};});
