// (C) Copyright 2011 Hewlett-Packard Development Company, L.P.
/**
 * @type {BaselineRoutes}
 * This is used to provide route map for each Baseline action.
 * This also provides default redirector and shows default error page if no matching URI identified.
 * Provide route for add, edit and show actions.
 */
define(['hp/core/Router', 'hp/core/UrlFragment'],
function (router, urlFragment) { "use strict";

    var BaselineRoutes = ( function() {

        var CONTAINER = '#hpsum-baseline-page .hp-details-pane';
        var CHANGE_CONTAINER = '#hp-change-page-container';

        function BaselineRoutes() {

            var registered = false;

            this.register = function () {

                if (registered) return;
                registered = true;

                router.map('baseline show',
                    '/baseline/show' + urlFragment.pagePatternTerminal, {
                    container: CONTAINER,
                    enter: function (location, result) {
                        require(['text!hpsumpages/baseline/show.html',
                            'hpsum/view/baseline/BaselineShowView'],
                        function (page, view) {
                            result.load(page, view);
                        });
                    }
                });

                router.map('baseline add',
                    '/baseline/add' + urlFragment.pagePatternTerminal, {
                    container: CHANGE_CONTAINER,
                    enter: function (location, result) {
                        require(['text!hpsumpages/baseline/add.html',
                            'hpsum/view/baseline/BaselineAddView'],
                        function (page, view) {
                            result.load(page, view);
                        });
                    }
                });

                router.map('baseline edit',
                    '/baseline/edit' + urlFragment.pagePatternTerminal, {
                    container: CHANGE_CONTAINER,
                    enter: function (location, result) {
                        require(['text!hpsumpages/baseline/edit.html',
                            'hpsum/view/baseline/BaselineEditView'],
                        function (page, view) {
                            result.load(page, view);
                        });
                    }
                });
		
		router.map('baseline retry',
                    '/baseline/retry' + urlFragment.pagePatternTerminal, {
                    container: CHANGE_CONTAINER,
                    enter: function (location, result) {
                        require(['text!hpsumpages/baseline/retry.html',
                            'hpsum/view/baseline/BaselineRetryview'],
                        function (page, view) {
                            result.load(page, view);
                        });
                    }
                });
		router.map('baseline custom',
                    '/baseline/custom' + urlFragment.pagePatternTerminal, {
                    container: CHANGE_CONTAINER,
                    enter: function (location, result) {
                        require(['text!hpsumpages/baseline/custom.html',
                            'hpsum/view/baseline/BaselineCustomView'],
                        function (page, view) {
                            result.load(page, view);
                        });
                    }
                });
                
                router.map('baseline reports', '/baseline/reports' +
                urlFragment.pagePatternTerminal, {
                    container: CHANGE_CONTAINER,
                    enter: function(location, result) {
                        require(['text!hpsumpages/node/reports.html',
                        'hpsum/view/node/NodeReportsView'],
                        function (page,view){
                            result.load(page,view);
                        });
                    }
                })

        router.map('baseline validate',
                    '/baseline/validate' + urlFragment.pagePatternTerminal, {
                    container: CHANGE_CONTAINER,
                    enter: function (location, result) {
                        require(['text!hpsumpages/baseline/validate.html',
                            'hpsum/view/baseline/BaselineValidateView'],
                        function (page, view) {
                            result.load(page, view);
                        });
                    }
                });


                router.filter('baseline default redirector',
                    '/baseline' + urlFragment.viewPatternTerminal, {
                    check: function (location, result) {
                        result.replaceWith(
                            urlFragment.replaceView(location, 'show'));
                    }
                });

                router.map('baseline no route', '/baseline/.+', {
                    container: CONTAINER,
                    enter: function (location, result) {
                        require(['text!hpPages/core/no_details.html'],
                        function (page) {
                            result.load(page);
                        });
                    }
                });
            }
        }

        return new BaselineRoutes();
    }());

    return BaselineRoutes;
});