// (C) Copyright 2013 Hewlett-Packard Development Company, L.P.
/**
 * @type {GroupRoutes}
 * This is used to provide route map for each Group action.
 * This also provides default redirector and shows default error page if no matching URI identified.
 * Provide route for add, edit and show actions.
 */
define(['hp/core/Router', 'hp/core/UrlFragment'],
function (router, urlFragment) { "use strict";

	var GroupRoutes = ( function() {

			//Consts can go here
			var CONTAINER = '#hpsum-groups-page .hp-details-pane',
			    CHANGE_CONTAINER = '#hp-change-page-container',
			    DIALOG_CONTAINER = '#hp-dialog-container';

			/**
			 * @constructor
			 */
			function GroupRoutes() {

				var registered = false;

				this.register = function() {

					if (registered)
						return;

					registered = true;

					router.map('group show', '/group/show' + urlFragment.pagePatternTerminal, {
						container : CONTAINER,
						enter : function(location, result) {
							require(['text!hpsumpages/group/show.html',
							'hpsum/view/group/GroupShowView',
							'hpsum/model/group/GroupShowRoutes'],
							function(page, view, routes) {
								routes.register();
								result.load(page, view);
							});
						}
					});

					router.map('group add', '/group/add' + urlFragment.pagePatternTerminal, {
						container : CHANGE_CONTAINER,
						enter : function(location, result) {
							require(['text!hpsumpages/group/add.html',
							'hpsum/view/group/GroupAddView'],
							function(page, view) {
								result.load(page, view);
							});
						}
					});

					router.map('group edit', '/group/edit' + urlFragment.pagePatternTerminal, {
						container : CHANGE_CONTAINER,
						enter : function(location, result) {
							require(['text!hpsumpages/group/edit.html',
							'hpsum/view/group/GroupEditView'],
							function(page, view) {
								result.load(page, view);
							});
						}
					});

					router.map('group inventory', '/group/inventory' + urlFragment.viewSinglePatternTerminal, {
						container : CHANGE_CONTAINER,
						enter : function(location, result) {
							require(['text!hpsumpages/group/inventory.html',
							'hpsum/view/group/GroupInventoryView'],
							function(page, view) {
								result.load(page, view);
							});
						}
					});

					router.map('group deploy', '/group/deploy' + urlFragment.pagePatternTerminal, {
						container : CHANGE_CONTAINER,
						enter : function(location, result) {
							require(['text!hpsumpages/group/deploy.html',
							'hpsum/view/group/GroupDeployView'],
							function(page, view) {
								result.load(page, view);
							});
						}
					});
					
					router.map('group reports', '/group/reports' + urlFragment.pagePatternTerminal, {
						container : CHANGE_CONTAINER,
						enter : function(location, result) {
							require(['text!hpsumpages/group/reports.html',
							'hpsum/view/group/GroupReportsView'],
							function(page, view) {
								result.load(page, view);
							});
						}
					});

					router.filter('group default redirector', '/group' + urlFragment.viewPatternTerminal, {
						check : function(location, result) {
							result.replaceWith(urlFragment.replaceView(location, 'show'));
						}
					});

					router.map('group no route', '/group/.+', {
						container : CONTAINER,
						enter : function(location, result) {
							require(['text!hpPages/core/no_details.html'],
							function(page) {
								result.load(page);
							});
						}
					});
				}
			}

			return new GroupRoutes();
		}());

	return GroupRoutes;
	});

