// (C) Copyright 2011-2012 Hewlett-Packard Development Company, L.P.
/**
 * @type {iloRoutes}
 */
define(['hp/core/Router', 'hp/core/UrlFragment'],
function (router, urlFragment) { "use strict";

    var iloRoutes = ( function() {

        var CONTAINER = '#hpsum-ilo-page .hp-details-pane';
        var CHANGE_CONTAINER = '#hp-change-page-container';
        var CONFIRM_CONTAINER = '#hp-dialog-container';
		var DIALOG_CONTAINER = '#hp-dialog-container';
        function iloRoutes() {

            var registered = false;

            this.register = function () {

                if (registered) return;
                registered = true;

                router.map('ilo show',
                    '/ilo/show' + urlFragment.pagePatternTerminal, {
                    container: CONTAINER,
                    enter: function (location, result) {
                        require(['text!hpsumpages/node/show.html',
                            'hpsum/view/node/NodeShowView',
                            'hpsum/model/ilo/iloShowRoutes'],
                        function (page, view, routes) {
                            routes.register();
                            result.load(page, view);
                        });
                    }
                });
				//Human Factor changes req:HF03 dated 07/25/2014
                                router.map('ilo add',
                    '/ilo/add' + urlFragment.pagePatternTerminal, {
                    container: CHANGE_CONTAINER,
                    enter: function (location, result) {
                        
                        require(['text!hpsumpages/node/add.html',
                            'hpsum/view/node/NodeAddView'],
                        function (page, view) {
                            result.load(page, view);
                        });
                       
                    
                    }
                });
				//Human Factor changes req:HF03
                router.map('ilo edit',
                    '/ilo/edit' + urlFragment.pagePatternTerminal, {
                    container: CHANGE_CONTAINER,
                    enter: function (location, result) {
                       
                        require(['text!hpsumpages/node/edit.html',
                            'hpsum/view/node/NodeEditView'],
                        function (page, view) {
                            result.load(page, view);
                        });
                        
                    
                    }
                });
                
				// router for find action.
				router.map('ilo find',
                    '/ilo/find' + urlFragment.pagePatternTerminal, {
                    container: CHANGE_CONTAINER,
                    enter: function (location, result) {
                        require(['text!hpsumpages/node/find.html',
						'hpsum/view/node/NodeFind'],
                        function (page, view) {
                        	//routes.register();
                            result.load(page, view);
                        });
                    }
                });
             router.map('ilo inventory', '/ilo/inventory' +
				urlFragment.viewSinglePatternTerminal, {
					container: CHANGE_CONTAINER,
					enter: function(location, result) {
						require(['text!hpsumpages/node/doinventory.html',
						'hpsum/view/node/NodeInventoryDView'],
						function (page,view){
							result.load(page,view);
						});
					}
				});
                
             
				router.map('ilo deploy',
                    '/ilo/deploy' + urlFragment.pagePatternTerminal, {
                    container: CHANGE_CONTAINER,
                    enter: function (location, result) {
                        require(['text!hpsumpages/node/deploy.html',
                            'hpsum/view/node/NodeDeployView'],
                        function (page, view) {
                            result.load(page, view);
                        });
                    }
                });
                router.map('ilo integrityilo activatepending',
                    '/ilo/integrityilo/activatepending' + urlFragment.pagePatternTerminal, {
                    container: DIALOG_CONTAINER,
                    enter: function (location, result) {
                        require(['text!hpsumpages/integrityilo/activatepending.html',
                            'hpsum/view/integrityilo/activatePendingView'],
                        function (page, view) {
                            result.load(page, view);
                        });
                    }
                });
                
                router.map('ilo integrityilo deploydomain',
                    '/ilo/integrityilo/deploydomain' + urlFragment.pagePatternTerminal, {
                    container: CHANGE_CONTAINER,
                    enter: function (location, result) {
                        require(['text!hpsumpages/integrityilo/deploydomain.html',
                            'hpsum/view/integrityilo/deploydomainView'],
                        function (page, view) {
                            result.load(page, view);
                        });
                    }
                });
                
                                
               router.map('ilo reports', '/ilo/reports' +
				urlFragment.pagePatternTerminal, {
					container: CHANGE_CONTAINER,
					enter: function(location, result) {
						require(['text!hpsumpages/node/reports.html',
						'hpsum/view/node/NodeReportsView'],
						function (page,view){
							result.load(page,view);
						});
					}
				});


                router.map('ilo deploy-results', '/ilo/deploy-results' +
                urlFragment.pagePatternTerminal, {
                    container: CHANGE_CONTAINER,
                    enter: function(location, result) {
                        require(['text!hpsumpages/node/install_results.html',
                        'hpsum/view/node/NodeDeployResults'],
                        function (page,view){
                            result.load(page,view);
                        });
                    }
                });
 
                router.filter('ilo default redirector',
                    '/ilo' + urlFragment.viewPatternTerminal, {
                    check: function (location, result) {
                        result.replaceWith(
                            urlFragment.replaceView(location, 'show'));
                    }
                });

                router.map('ilo no route', '/ilo/.+', {
                    container: CONTAINER,
                    enter: function (location, result) {
                        require(['text!hpPages/core/no_details.html'],
                        function (page) {
                            result.load(page);
                        });
                    }
                });
            }
        }

        return new iloRoutes();
    }());

    return iloRoutes;
});
