// (C) Copyright 2014 Hewlett-Packard Development Company, L.P.
/* This is a Resource object for Scalable resource.
 * The resource object created for particular type of resource and association with other resources.
 */
define(['hp/model/Resource',
'hp/services/IndexService',
'hp/core/EventDispatcher',
'hp/services/REST',
'hp/model/Session'
],
function(Resource,indexService,eventDispatcher,restService,session) {"use strict";
	
	var iloFederationResource = (function(){
		
		function iloFederationResource() {
			var prefix = '/hpsum';
			var nodeResource;
			//Derive from Resource
			var category= 'ilofederation';
			 Resource.call(this, category);
			 var index;
			function hoursAgo(hours) {
                var now = new Date();
                return new Date(now.getTime() - (1000 * 60 * 60 * hours));
            }
			 
			 nodeResource =this;
			 this.category='ilofederation';
			 // Inits nodes for mockup

			function OnAddNodeSuccess(data,item){
				
				var notDetails={
			 		summary:null,
			 		details:null
			 	};
				var alertTemplate = {
                        category: 'alert',
                        sourceUri: item.uri,
                        sourceName: item.name,
                        notes: []
                    };
                    
				var alert = $.extend({name: 'Added '+item.name,
                uri: '/alert/alert-t1',
                status: 'info', owner: session.getUser(), state: 'active',
                date: hoursAgo(36).toISOString()}, alertTemplate);
                //indexService.addItem('alert', alert);
                item.index = data.hapi.sug_id;
                if(item.username && item.password)
                	item.state = 'scouting';
                else {	
                	item.state = 'init';
                	notDetails.summary='Need Credentials';
			 		notDetails.details= '<p><a href="#/node/edit/credentials"> Need Credentials</a>.</p>';
                }  
                item.stateDetails=notDetails,
                item.uri = '/Session/'+session.getToken() + '/Node/ScalableUpdate/' + data.hapi.sug_id + '/getdata';

				
			}

            function OnAddGroupSuccess(data,item){
                
                var notDetails={
                    summary: "Idle",
                    details:"Ready to start inventory"
                };
                var alertTemplate = {
                        category: 'alert',
                        sourceUri: item.uri,
                        sourceName: item.name,
                        notes: []
                    };
                var id = data.hapi.sug_id;

                var alert = $.extend({name: 'Added '+ data.hapi.sug_id,
                uri: '/alert/alert-t1',
                status: 'info', owner: session.getUser(), state: 'active',
                date: hoursAgo(36).toISOString()}, alertTemplate);
                //indexService.addItem('alert', alert);
                item.index = data.hapi.sug_id;
                item.state ="Idle";
                item.stateDetails=notDetails;
                item.uri = '/Session/'+session.getToken() + '/Node/ScalableUpdate' + id + '/getdata';
           
            }

            
			function OnAddNodeFailed(data,item){
				
				var alertTemplate = {
                        category: 'alert',
                        sourceUri: item.uri,
                        sourceName: item.name,
                        notes: []
                    };
                    
				
				var alert = $.extend({name: 'Add Failed '+item.name,
                uri: '/alert/alert-t1',
                status: 'info', owner: session.getUser(), state: 'active',
                date: hoursAgo(36).toISOString()}, alertTemplate);
                //indexService.addItem('alert', alert);
			}
			 
			this.addScalableGroup = function(item, handlers){
					var alertTemplate = {
                        category: 'alert',
                        sourceUri: item.uri,
                        sourceName: item.name,
                        notes: []
                    };
                    
                    var object ={
                    	hapi: {
                    		group_name: item.group_name,
							name: item.group_name,
                            description:item.description,
                            group_description : item.group_description,
                    		baselines: {
                    		              baseline: item.baselines,
                    		}
            			  }
            			};

                    var options = {
                    	encodeResults: false,
                    	encodeErrors: false
                    };
                    var sessionurl = '/session/'+session.getToken();
					restService.postObject( sessionurl + '/node/scalableupdate/add', object,{
						success: function(data){
							if(data.hapi.hcode == 0){
								OnAddGroupSuccess(data,item);
								handlers.success(data);
							}
							else 
								handlers.error(data.hapi.hmessage);
                   	},
                   		error: function () {
                   			var alert = $.extend({name: 'Add Failed '+item.name,
                        	uri: '/alert/alert-t1',
                        	status: 'failed', owner: 'HPSUM', state: 'active',
                        	date: hoursAgo(36).toISOString()}, alertTemplate);
                   			indexService.addItem('alert', alert);
                   		}
                 }, options);
			 };

			 
			 this.init =function(count){
			 	 var i, status, name, item,description, nodeType,prefix='Node';
			 	index =1001;
                                
                for (i = 1; i <= count; i += 1) {
                    name = prefix + ' ' + i;
                    // make most 'ok'
                    if (i % 1 === 0) {
                        status = ['all', 'scanning', 'scan-complete', 'scheduled','web','error'][i % 6];
                    } else {
                      //name += ' make it much longer to see what happens'; /// !!!
                        status = 'ok';
                    }
                    description = name;
                    nodeType = 'Windows Server';
                   // this.addNode(name, description, status, nodeType,1);

                }
			 	
			 };
			
		}
		return new iloFederationResource();
	}());
    return iloFederationResource;
});
